/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Triple;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.fmi.Fmi2ModelDescription;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.framework.fmi2.ModelSwapInfo;
import org.intocps.maestro.framework.fmi2.api.FmiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PredicateFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ComponentVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;
import org.intocps.maestro.plugin.IdentifierReplacer;
import org.intocps.maestro.plugin.JacobianStepBuilder;

class ModelSwapBuilder {
    ModelSwapBuilder() {
    }

    static PortFmi2Api getSwapSourcePort(PortFmi2Api port, Set<Fmi2SimulationEnvironment.Relation> swapRelations, Map<String, ComponentVariableFmi2Api> fmuInstances) {
        PortFmi2Api sourcePort = null;
        Optional<Fmi2SimulationEnvironment.Relation> relation = swapRelations.stream().filter(r -> r.getTargets().values().stream().anyMatch(v -> v.toString().equals(port.getMultiModelScalarVariableNameWithoutFmu()))).findFirst();
        if (relation.isPresent()) {
            String source = relation.get().getSource().getInstance().getText();
            sourcePort = fmuInstances.entrySet().stream().filter(pair -> ((ComponentVariableFmi2Api)pair.getValue()).getEnvironmentName().equals(source)).map(pair -> ((ComponentVariableFmi2Api)pair.getValue()).getPort(((Fmi2SimulationEnvironment.Relation)relation.get()).getSource().getName())).findFirst().orElse(null);
        }
        return sourcePort;
    }

    static ModelSwapInfo getSwapSourceInfo(PortFmi2Api port, Set<Fmi2SimulationEnvironment.Relation> swapRelations, Map<String, ComponentVariableFmi2Api> fmuInstances, Fmi2SimulationEnvironment env) {
        ModelSwapInfo swapInfo = null;
        Optional<Fmi2SimulationEnvironment.Relation> relation = swapRelations.stream().filter(r -> r.getTargets().values().stream().anyMatch(v -> v.toString().equals(port.getMultiModelScalarVariableNameWithoutFmu()))).findFirst();
        if (relation.isPresent()) {
            String source = relation.get().getSource().getInstance().getText();
            Optional<Map.Entry> infoEntry = env.getModelSwaps().stream().filter(e -> ((ModelSwapInfo)e.getValue()).swapInstance.equals(source)).findFirst();
            if (infoEntry.isPresent()) {
                swapInfo = (ModelSwapInfo)infoEntry.get().getValue();
            }
        }
        return swapInfo;
    }

    public static Map.Entry<DoubleVariableFmi2Api, Optional<PredicateFmi2Api>> updateStep(ModelSwapContext swapCtxt, Fmi2SimulationEnvironment env, ComponentVariableFmi2Api instance, DoubleVariableFmi2Api communicationTime) {
        PredicateFmi2Api stepPredicate = null;
        for (Map.Entry modelSwapInfoEntry : env.getModelSwaps()) {
            if (!instance.getName().equals(modelSwapInfoEntry.getKey()) && !instance.getName().equals(((ModelSwapInfo)modelSwapInfoEntry.getValue()).swapInstance)) continue;
            if (instance.getName().equals(modelSwapInfoEntry.getKey())) {
                stepPredicate = ((BooleanVariableFmi2Api)swapCtxt.modelSwapConditions.get(modelSwapInfoEntry.getValue()).getLeft()).toPredicate().not();
                break;
            }
            stepPredicate = ((BooleanVariableFmi2Api)swapCtxt.modelSwapConditions.get(modelSwapInfoEntry.getValue()).getMiddle()).toPredicate();
            communicationTime = (DoubleVariableFmi2Api)swapCtxt.modelSwapConditions.get(modelSwapInfoEntry.getValue()).getRight();
            break;
        }
        return Map.entry(communicationTime, stepPredicate == null ? Optional.empty() : Optional.of(stepPredicate));
    }

    public static void updateDiscardStepTime(ModelSwapContext swapCtxt, DynamicActiveBuilderScope dynamicScope, DoubleVariableFmi2Api currentStepSize) {
        swapCtxt.modelSwapConditions.forEach((info, value) -> {
            DoubleVariableFmi2Api communicationTime = (DoubleVariableFmi2Api)value.getRight();
            PredicateFmi2Api stepPredicate = ((BooleanVariableFmi2Api)value.getMiddle()).toPredicate();
            if (stepPredicate != null) {
                dynamicScope.enterIf((FmiBuilder.Predicate)stepPredicate);
            }
            communicationTime.setValue((FmiBuilder.DoubleExpressionValue)communicationTime.toMath().addition((FmiBuilder.NumericTypedReferenceExp)currentStepSize));
            if (stepPredicate != null) {
                dynamicScope.leave();
            }
        });
    }

    public static ModelSwapContext buildContext(Fmi2SimulationEnvironment env, DynamicActiveBuilderScope dynamicScope) {
        ModelSwapContext ctxt = new ModelSwapContext();
        HashMap<ModelSwapInfo, Triple<BooleanVariableFmi2Api, BooleanVariableFmi2Api, DoubleVariableFmi2Api>> modelSwapConditions = new HashMap<ModelSwapInfo, Triple<BooleanVariableFmi2Api, BooleanVariableFmi2Api, DoubleVariableFmi2Api>>();
        List swapInfoList = env.getModelSwaps().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        int index = 0;
        for (ModelSwapInfo info : swapInfoList) {
            BooleanVariableFmi2Api swapVar = dynamicScope.store("swapCondition" + index, false);
            BooleanVariableFmi2Api stepVar = dynamicScope.store("stepCondition" + index, false);
            DoubleVariableFmi2Api currentCommunicationTimeOffset = dynamicScope.store("jac_current_communication_point_offset" + index, 0.0);
            modelSwapConditions.put(info, (Triple<BooleanVariableFmi2Api, BooleanVariableFmi2Api, DoubleVariableFmi2Api>)Triple.of((Object)swapVar, (Object)stepVar, (Object)currentCommunicationTimeOffset));
            ++index;
        }
        ctxt.modelSwapConditions = modelSwapConditions;
        return ctxt;
    }

    public static void updateSwapConditionVariables(ModelSwapContext swapCtxt, DynamicActiveBuilderScope dynamicScope, Map<ComponentVariableFmi2Api, Map<PortFmi2Api, VariableFmi2Api<Object>>> componentsToPortsWithValues) {
        Map<String, PExp> replaceRule = componentsToPortsWithValues.entrySet().stream().flatMap(c -> ((Map)c.getValue()).entrySet().stream().map(p -> Map.entry(((PortFmi2Api)p.getKey()).getMultiModelScalarVariableNameWithoutFmu(), ((PortFmi2Api)p.getKey()).getSharedAsVariable().getReferenceExp()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        swapCtxt.modelSwapConditions.forEach((info, value) -> {
            BooleanVariableFmi2Api swapVar = (BooleanVariableFmi2Api)value.getLeft();
            BooleanVariableFmi2Api stepVar = (BooleanVariableFmi2Api)value.getMiddle();
            swapVar.setValue((FmiBuilder.Variable)new BooleanVariableFmi2Api(null, null, (FmiBuilder.DynamicActiveScope)dynamicScope, null, (PExp)MableAstFactory.newOr((PExp)swapVar.getExp(), (PExp)IdentifierReplacer.replaceFields(info.swapCondition, replaceRule))));
            stepVar.setValue((FmiBuilder.Variable)new BooleanVariableFmi2Api(null, null, (FmiBuilder.DynamicActiveScope)dynamicScope, null, (PExp)MableAstFactory.newOr((PExp)stepVar.getExp(), (PExp)IdentifierReplacer.replaceFields(info.stepCondition, replaceRule))));
        });
    }

    public static void setWithModelSwapLinking(Map<String, ComponentVariableFmi2Api> fmuInstances, Fmi2SimulationEnvironment env, DynamicActiveBuilderScope dynamicScope, ModelSwapContext swapCtxt) {
        fmuInstances.values().forEach(instance -> {
            Predicate<PortFmi2Api> onlyInputs = p -> p.scalarVariable.causality == Fmi2ModelDescription.Causality.Input;
            Set swapRelations = env.getModelSwapRelations();
            Optional<Map.Entry> swapInfoOutput = env.getModelSwaps().stream().filter(e -> ((String)e.getKey()).equals(instance.getName())).findFirst();
            Optional<Map.Entry> swapInfoInput = env.getModelSwaps().stream().filter(e -> ((ModelSwapInfo)e.getValue()).swapInstance.equals(instance.getName())).findFirst();
            if (swapInfoOutput.isPresent()) {
                if (instance.getPorts().stream().filter(onlyInputs).anyMatch(PortFmi2Api::isLinkedAsInputConsumer)) {
                    PredicateFmi2Api swapPredicate = ((BooleanVariableFmi2Api)swapCtxt.modelSwapConditions.get(swapInfoOutput.get().getValue()).getLeft()).toPredicate();
                    dynamicScope.enterIf((FmiBuilder.Predicate)swapPredicate.not());
                    instance.setLinked();
                    dynamicScope.leave();
                }
            } else if (swapInfoInput.isPresent()) {
                instance.getPorts().stream().filter(onlyInputs).forEach(port -> {
                    PortFmi2Api sourcePort = ModelSwapBuilder.getSwapSourcePort(port, swapRelations, fmuInstances);
                    if (sourcePort != null) {
                        JacobianStepBuilder.relinkPorts.accept(sourcePort, (PortFmi2Api)port);
                    }
                });
                if (instance.getPorts().stream().filter(onlyInputs).anyMatch(PortFmi2Api::isLinkedAsInputConsumer)) {
                    PredicateFmi2Api stepPredicate = ((BooleanVariableFmi2Api)swapCtxt.modelSwapConditions.get(swapInfoInput.get().getValue()).getMiddle()).toPredicate();
                    dynamicScope.enterIf((FmiBuilder.Predicate)stepPredicate);
                    instance.setLinked();
                    dynamicScope.leave();
                }
            } else if (instance.getPorts().stream().filter(onlyInputs).anyMatch(port -> ModelSwapBuilder.getSwapSourcePort(port, swapRelations, fmuInstances) != null)) {
                instance.getPorts().stream().filter(onlyInputs).forEach(port -> {
                    PortFmi2Api swapSourcePort = ModelSwapBuilder.getSwapSourcePort(port, swapRelations, fmuInstances);
                    if (swapSourcePort != null) {
                        ModelSwapInfo swapInfo = ModelSwapBuilder.getSwapSourceInfo(port, swapRelations, fmuInstances, env);
                        PredicateFmi2Api swapPredicate = ((BooleanVariableFmi2Api)swapCtxt.modelSwapConditions.get(swapInfo).getLeft()).toPredicate();
                        if (port.getSourcePort() != null) {
                            dynamicScope.enterIf((FmiBuilder.Predicate)swapPredicate.not());
                            instance.setLinked(new FmiBuilder.Port[]{port});
                            dynamicScope.leave();
                            port.breakLink();
                        }
                        JacobianStepBuilder.relinkPorts.accept(swapSourcePort, (PortFmi2Api)port);
                        dynamicScope.enterIf((FmiBuilder.Predicate)swapPredicate);
                        instance.setLinked(new FmiBuilder.Port[]{port});
                        dynamicScope.leave();
                    } else if (port.getSourcePort() != null) {
                        instance.setLinked(new FmiBuilder.Port[]{port});
                    }
                });
            } else if (instance.getPorts().stream().filter(onlyInputs).anyMatch(PortFmi2Api::isLinkedAsInputConsumer)) {
                instance.setLinked();
            }
        });
    }

    static class ModelSwapContext {
        Map<ModelSwapInfo, Triple<BooleanVariableFmi2Api, BooleanVariableFmi2Api, DoubleVariableFmi2Api>> modelSwapConditions;

        ModelSwapContext() {
        }
    }
}

