/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.fmi.Fmi2ModelDescription;
import org.intocps.maestro.framework.fmi2.api.FmiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.BooleanBuilderFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.MathBuilderFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.ScopeFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.values.IntExpressionValue;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ComponentVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.IntVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;
import org.intocps.maestro.plugin.JacobianInternalBuilder;
import org.intocps.maestro.plugin.JacobianStepConfig;

public class StabilisationBuilder {
    public static void step(StabilisationContext stabilisationCtxt, DynamicActiveBuilderScope dynamicScope) {
        stabilisationCtxt.stabilisation_loop.setValue((FmiBuilder.Variable)stabilisationCtxt.stabilisation_loop_max_iterations);
        stabilisationCtxt.convergenceReached.setValue((FmiBuilder.Variable)new BooleanVariableFmi2Api(null, null, (FmiBuilder.DynamicActiveScope)dynamicScope, null, (PExp)MableAstFactory.newABoolLiteralExp((Boolean)false)));
        stabilisationCtxt.stabilisationScope = dynamicScope.enterWhile((FmiBuilder.Predicate)stabilisationCtxt.convergenceReached.toPredicate().not().and(stabilisationCtxt.stabilisation_loop.toMath().greaterThan((FmiBuilder.NumericTypedReferenceExp)IntExpressionValue.of((int)0))));
    }

    public static void convergence(DynamicActiveBuilderScope dynamicScope, Map<ComponentVariableFmi2Api, Map<PortFmi2Api, VariableFmi2Api<Object>>> componentsToPortsWithValues, StabilisationContext stabilisationCtxt, JacobianInternalBuilder.BaseJacobianContext ctxt, MablApiBuilder builder, MathBuilderFmi2Api math, BooleanBuilderFmi2Api booleanLogic, List<FmiBuilder.StateVariable<PStm>> fmuStates) {
        ArrayList convergenceVariables = new ArrayList();
        for (Map<PortFmi2Api, VariableFmi2Api<Object>> portsToValues : componentsToPortsWithValues.values()) {
            ArrayList<BooleanVariableFmi2Api> converged = new ArrayList<BooleanVariableFmi2Api>();
            Map<PortFmi2Api, VariableFmi2Api> portsToValuesOfInterest = portsToValues.entrySet().stream().filter(ptv -> ((PortFmi2Api)ptv.getKey()).scalarVariable.type.type == Fmi2ModelDescription.Types.Real && (((PortFmi2Api)ptv.getKey()).scalarVariable.causality == Fmi2ModelDescription.Causality.Output || ((PortFmi2Api)ptv.getKey()).scalarVariable.causality == Fmi2ModelDescription.Causality.Input)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            for (Map.Entry<PortFmi2Api, VariableFmi2Api> entry : portsToValuesOfInterest.entrySet()) {
                VariableFmi2Api oldVariable = entry.getKey().getSharedAsVariable();
                VariableFmi2Api newVariable = entry.getValue();
                BooleanVariableFmi2Api isClose = dynamicScope.store("isClose", false);
                isClose.setValue((FmiBuilder.Variable)math.checkConvergence((FmiBuilder.ProvidesTypedReferenceExp)oldVariable, (FmiBuilder.ProvidesTypedReferenceExp)newVariable, (FmiBuilder.DoubleVariable)stabilisationCtxt.absTol, (FmiBuilder.DoubleVariable)stabilisationCtxt.relTol));
                dynamicScope.enterIf((FmiBuilder.Predicate)isClose.toPredicate().not());
                builder.getLogger().debug("Unstable signal %s = %.15E at time: %.15E", new Object[]{entry.getKey().getMultiModelScalarVariableName(), entry.getValue(), ctxt.currentCommunicationTime});
                dynamicScope.leave();
                converged.add(isClose);
            }
            convergenceVariables.addAll(converged);
        }
        if (stabilisationCtxt.convergenceReached == null) {
            throw new RuntimeException("NO STABILISATION LOOP FOUND");
        }
        stabilisationCtxt.convergenceReached.setValue((FmiBuilder.Variable)booleanLogic.allTrue("convergence", convergenceVariables));
        dynamicScope.enterIf((FmiBuilder.Predicate)stabilisationCtxt.convergenceReached.toPredicate().not()).enterThen();
        fmuStates.forEach(FmiBuilder.StateVariable::set);
        stabilisationCtxt.stabilisation_loop.decrement();
        dynamicScope.leave();
        componentsToPortsWithValues.forEach(ComponentVariableFmi2Api::share);
        stabilisationCtxt.stabilisationScope.leave();
    }

    public static StabilisationContext init(DynamicActiveBuilderScope dynamicScope, JacobianStepConfig jacobianStepConfig) {
        StabilisationContext stabilisationCtxt = new StabilisationContext();
        stabilisationCtxt.absTol = dynamicScope.store("absolute_tolerance", jacobianStepConfig.absoluteTolerance);
        stabilisationCtxt.relTol = dynamicScope.store("relative_tolerance", jacobianStepConfig.relativeTolerance);
        stabilisationCtxt.stabilisation_loop_max_iterations = dynamicScope.store("stabilisation_loop_max_iterations", jacobianStepConfig.stabilisationLoopMaxIterations);
        stabilisationCtxt.stabilisation_loop = dynamicScope.store("stabilisation_loop", stabilisationCtxt.stabilisation_loop_max_iterations);
        stabilisationCtxt.convergenceReached = dynamicScope.store("has_converged", false);
        return stabilisationCtxt;
    }

    public static class StabilisationContext {
        ScopeFmi2Api stabilisationScope = null;
        IntVariableFmi2Api stabilisation_loop = null;
        BooleanVariableFmi2Api convergenceReached = null;
        DoubleVariableFmi2Api absTol = null;
        DoubleVariableFmi2Api relTol = null;
        IntVariableFmi2Api stabilisation_loop_max_iterations = null;
    }
}

