/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import core.AbsoluteStepSize;
import core.AdaptiveModel;
import core.AlgebraicLoop;
import core.AlgebraicLoopInit;
import core.ConnectionModel;
import core.CosimStepInstruction;
import core.EnterInitMode;
import core.ExitInitMode;
import core.Get;
import core.GetTentative;
import core.InitGet;
import core.InitSet;
import core.InitializationInstruction;
import core.MasterModel;
import core.PortRef;
import core.RelativeStepSize;
import core.RestoreState;
import core.SaveState;
import core.ScenarioLoader;
import core.ScenarioModel;
import core.SetTentative;
import core.Step;
import core.StepLoop;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.xpath.XPathExpressionException;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.AModuleDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.AImportedModuleCompilationUnit;
import org.intocps.maestro.ast.node.ASimulationSpecificationCompilationUnit;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.core.Framework;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.fmi.Fmi2ModelDescription;
import org.intocps.maestro.fmi.ModelDescription;
import org.intocps.maestro.framework.core.ISimulationEnvironment;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.BooleanBuilderFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.DataWriter;
import org.intocps.maestro.framework.fmi2.api.mabl.LoggerFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.MathBuilderFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IMablScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.WhileMaBLScope;
import org.intocps.maestro.framework.fmi2.api.mabl.values.BooleanExpressionValue;
import org.intocps.maestro.framework.fmi2.api.mabl.values.DoubleExpressionValue;
import org.intocps.maestro.framework.fmi2.api.mabl.values.IntExpressionValue;
import org.intocps.maestro.framework.fmi2.api.mabl.values.PortValueExpresssionMapImpl;
import org.intocps.maestro.framework.fmi2.api.mabl.values.StringExpressionValue;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ArrayVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ComponentVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.IntVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;
import org.intocps.maestro.plugin.BasicMaestroExpansionPlugin;
import org.intocps.maestro.plugin.ExpandException;
import org.intocps.maestro.plugin.IMaestroExpansionPlugin;
import org.intocps.maestro.plugin.IPluginConfiguration;
import org.intocps.maestro.plugin.SigverConfig;
import org.intocps.maestro.plugin.SimulationFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.javaapi.CollectionConverters;
import synthesizer.LoopStrategy;
import synthesizer.SynthesizerSimple;

@SimulationFramework(framework=Framework.FMI2)
public class Sigver
extends BasicMaestroExpansionPlugin {
    public static final String MASTER_MODEL_FMU_INSTANCE_DELIMITER = "_";
    public static final String MULTI_MODEL_FMU_INSTANCE_DELIMITER = ".";
    public static final String EXECUTE_ALGORITHM_FUNCTION_NAME = "executeAlgorithm";
    static final Logger logger = LoggerFactory.getLogger(Sigver.class);
    private final AFunctionDeclaration func = MableAstFactory.newAFunctionDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)"executeAlgorithm"), Arrays.asList(MableAstFactory.newAFormalParameter((PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newANameType((String)"FMI2Component")), (LexIdentifier)MableAstFactory.newAIdentifier((String)"component")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newARealNumericPrimitiveType(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"stepSize")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newARealNumericPrimitiveType(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"startTime")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newARealNumericPrimitiveType(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"endTime"))), (PType)MableAstFactory.newAVoidType());
    private MathBuilderFmi2Api mathModule;
    private LoggerFmi2Api loggerModule;
    private BooleanBuilderFmi2Api booleanLogicModule;
    private DynamicActiveBuilderScope dynamicScope;
    private Double relTol;
    private Double absTol;
    private Integer convAtt;
    private AdaptiveModel adaptiveModel;

    public Set<AFunctionDeclaration> getDeclaredUnfoldFunctions() {
        return Stream.of(this.func).collect(Collectors.toSet());
    }

    public <R> IMaestroExpansionPlugin.RuntimeConfigAddition<R> expandWithRuntimeAddition(AFunctionDeclaration declaredFunction, Fmi2Builder<PStm, ASimulationSpecificationCompilationUnit, PExp, ?> providedBuilder, List<Fmi2Builder.Variable<PStm, ?>> formalArguments, IPluginConfiguration config, ISimulationEnvironment envIn, IErrorReporter errorReporter) throws ExpandException {
        logger.info("Unfolding with scenario verifier: {}", (Object)declaredFunction.toString());
        if (!this.getDeclaredUnfoldFunctions().contains(declaredFunction)) {
            throw new ExpandException("Unknown function declaration");
        }
        if (envIn == null) {
            throw new ExpandException("Simulation environment must not be null");
        }
        if (formalArguments == null || formalArguments.size() != this.func.getFormals().size()) {
            throw new ExpandException("Invalid args");
        }
        if (!(providedBuilder instanceof MablApiBuilder)) {
            throw new ExpandException("Not supporting the given builder type. Expecting " + MablApiBuilder.class.getSimpleName() + " got " + providedBuilder.getClass().getSimpleName());
        }
        DoubleVariableFmi2Api stepSize = (DoubleVariableFmi2Api)formalArguments.get(1);
        DoubleVariableFmi2Api startTime = (DoubleVariableFmi2Api)formalArguments.get(2);
        DoubleVariableFmi2Api endTime = (DoubleVariableFmi2Api)formalArguments.get(3);
        SigverConfig configuration = (SigverConfig)config;
        this.relTol = configuration.relTol;
        this.absTol = configuration.absTol;
        this.convAtt = configuration.convergenceAttempts;
        try {
            MasterModel masterModel = ScenarioLoader.load((InputStream)new ByteArrayInputStream(configuration.masterModel.getBytes()));
            ScenarioModel scenarioModel = masterModel.scenario();
            this.adaptiveModel = scenarioModel.config();
            MablApiBuilder builder = (MablApiBuilder)providedBuilder;
            this.dynamicScope = builder.getDynamicScope();
            this.mathModule = builder.getMathBuilder();
            this.loggerModule = builder.getLogger();
            this.booleanLogicModule = builder.getBooleanBuilder();
            DataWriter.DataWriterInstance dataWriterInstance = builder.getDataWriter().createDataWriterInstance();
            java.util.Map fmuInstances = ((Fmi2Builder.ArrayVariable)formalArguments.get(0)).items().stream().collect(Collectors.toMap(ComponentVariableFmi2Api::getEnvironmentName, Function.identity(), (u, v) -> u, LinkedHashMap::new));
            HashSet fmuKeys = new HashSet(fmuInstances.keySet());
            fmuKeys.forEach(key -> {
                ComponentVariableFmi2Api fmuInstance = (ComponentVariableFmi2Api)fmuInstances.get(key);
                String fmuIdentifier = fmuInstance.getOwner().getFmuIdentifier();
                String newKey = fmuIdentifier.substring(1, fmuIdentifier.length() - 1) + MASTER_MODEL_FMU_INSTANCE_DELIMITER + key;
                fmuInstances.remove(key);
                fmuInstances.put(newKey, fmuInstance);
            });
            if (masterModel.initialization().length() == 0) {
                SynthesizerSimple synthesizer = new SynthesizerSimple(scenarioModel, LoopStrategy.maximum());
                masterModel.initialization().concat((IterableOnce)synthesizer.synthesizeInitialization());
            }
            dataWriterInstance.initialize(fmuInstances.values().stream().flatMap(x -> x.getVariablesToLog().stream()).collect(Collectors.toList()));
            fmuInstances.values().forEach(instance -> instance.setupExperiment((Fmi2Builder.DoubleVariable)startTime, (Fmi2Builder.DoubleVariable)endTime, configuration.relTol));
            this.setSEA(fmuInstances, configuration.parameters);
            List<Map.Entry<PortFmi2Api, VariableFmi2Api<Object>>> sharedPortVars = this.mapInitializationActionsToMaBL(CollectionConverters.asJava((Seq)masterModel.initialization()), fmuInstances, CollectionConverters.asJava((Seq)scenarioModel.connections()));
            DoubleVariableFmi2Api currentCommunicationPoint = this.dynamicScope.store("current_communication_point", 0.0);
            currentCommunicationPoint.setValue((Fmi2Builder.Variable)startTime);
            DoubleVariableFmi2Api currentStepSize = this.dynamicScope.store("current_step_size", 0.0);
            fmuInstances.values().forEach(instance -> instance.getAndShare((String[])instance.getVariablesToLog().stream().filter(var -> var.getSharedAsVariable() == null).map(PortFmi2Api::getName).toArray(String[]::new)));
            dataWriterInstance.log(currentCommunicationPoint);
            WhileMaBLScope coSimStepLoop = this.dynamicScope.enterWhile((Fmi2Builder.Predicate)currentCommunicationPoint.toMath().addition((Fmi2Builder.NumericTypedReferenceExp)stepSize).lessThan((Fmi2Builder.NumericTypedReferenceExp)endTime));
            currentStepSize.setValue((Fmi2Builder.Variable)stepSize);
            java.util.Map<String, List<CosimStepInstruction>> coSimStepsMap = CollectionConverters.asJava((Map)masterModel.cosimStep()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> CollectionConverters.asJava((Seq)((Seq)e.getValue()))));
            this.mapCoSimStepInstructionsToMaBL(coSimStepsMap, fmuInstances, currentCommunicationPoint, new HashSet<Fmi2Builder.StateVariable<PStm>>(), CollectionConverters.asJava((Seq)scenarioModel.connections()), sharedPortVars, currentStepSize);
            fmuInstances.values().forEach(instance -> instance.getAndShare((String[])instance.getVariablesToLog().stream().filter(var -> var.getTargetPorts().size() < 1).map(PortFmi2Api::getName).toArray(String[]::new)));
            currentCommunicationPoint.setValue((Fmi2Builder.DoubleExpressionValue)currentCommunicationPoint.toMath().addition((Fmi2Builder.NumericTypedReferenceExp)currentStepSize));
            dataWriterInstance.log(currentCommunicationPoint);
            coSimStepLoop.leave();
            dataWriterInstance.close();
            return new IMaestroExpansionPlugin.EmptyRuntimeConfig();
        }
        catch (Exception e2) {
            throw new ExpandException("Error occurred during plugin expansion: " + e2);
        }
    }

    public boolean requireConfig() {
        return true;
    }

    public IPluginConfiguration parseConfig(InputStream is) throws IOException {
        return (IPluginConfiguration)new ObjectMapper().readValue(is, SigverConfig.class);
    }

    public AImportedModuleCompilationUnit getDeclaredImportUnit() {
        AImportedModuleCompilationUnit unit = new AImportedModuleCompilationUnit();
        unit.setImports(Stream.of("FMI2", "TypeConverter", "Math", "Logger", "DataWriter", "BooleanLogic").map(MableAstFactory::newAIdentifier).collect(Collectors.toList()));
        AModuleDeclaration module = new AModuleDeclaration();
        module.setName(MableAstFactory.newAIdentifier((String)this.getName()));
        module.setFunctions(new ArrayList<AFunctionDeclaration>(this.getDeclaredUnfoldFunctions()));
        unit.setModule(module);
        return unit;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getVersion() {
        return "0.0.1";
    }

    private void setSEA(java.util.Map<String, ComponentVariableFmi2Api> fmuInstances, java.util.Map<String, Object> parameters) {
        fmuInstances.forEach((instanceName, fmuInstance) -> {
            java.util.Map<String, Object> portNameToValueMap = parameters.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(this.masterMRepresentationToMultiMRepresentation((String)instanceName))).collect(Collectors.toMap(e -> {
                String[] instanceNameSplit = ((String)e.getKey()).split("\\.");
                return String.join((CharSequence)MULTI_MODEL_FMU_INSTANCE_DELIMITER, Arrays.copyOfRange(instanceNameSplit, 2, instanceNameSplit.length));
            }, Map.Entry::getValue));
            java.util.Map<PortFmi2Api, Fmi2Builder.ExpressionValue> PortToExpressionValue = portNameToValueMap.entrySet().stream().filter(e -> {
                PortFmi2Api port = fmuInstance.getPort((String)e.getKey());
                boolean isTunableParameter = port.scalarVariable.variability.equals((Object)ModelDescription.Variability.Tunable) && port.scalarVariable.causality.equals((Object)Fmi2ModelDescription.Causality.Parameter);
                boolean isEligibleVariable = port.scalarVariable.variability != ModelDescription.Variability.Constant && (port.scalarVariable.initial.equals((Object)ModelDescription.Initial.Exact) || port.scalarVariable.initial.equals((Object)ModelDescription.Initial.Approx));
                return isTunableParameter || isEligibleVariable;
            }).collect(Collectors.toMap(e -> fmuInstance.getPort((String)e.getKey()), e -> {
                if (e.getValue() instanceof Double) {
                    return DoubleExpressionValue.of((double)((Double)e.getValue()));
                }
                if (e.getValue() instanceof Integer) {
                    return IntExpressionValue.of((int)((Integer)e.getValue()));
                }
                if (e.getValue() instanceof Boolean) {
                    return BooleanExpressionValue.of((boolean)((Boolean)e.getValue()));
                }
                if (e.getValue() instanceof String) {
                    return StringExpressionValue.of((String)((String)e.getValue()));
                }
                throw new RuntimeException("Unable to set parameter of class: " + e.getValue().getClass().toString());
            }));
            fmuInstance.set((Fmi2Builder.Fmi2ComponentVariable.PortExpressionValueMap)new PortValueExpresssionMapImpl(PortToExpressionValue));
        });
    }

    private List<Map.Entry<PortFmi2Api, VariableFmi2Api<Object>>> mapInitializationActionsToMaBL(List<InitializationInstruction> initializationInstructions, java.util.Map<String, ComponentVariableFmi2Api> fmuInstances, List<ConnectionModel> connections) {
        ArrayList<Map.Entry<PortFmi2Api, VariableFmi2Api<Object>>> sharedPortVars = new ArrayList<Map.Entry<PortFmi2Api, VariableFmi2Api<Object>>>();
        initializationInstructions.forEach(instruction -> {
            if (instruction instanceof InitGet) {
                java.util.Map<PortFmi2Api, VariableFmi2Api<Object>> portsWithGets = this.mapGetInstruction(((InitGet)instruction).port(), fmuInstances);
                portsWithGets.forEach((key, value) -> sharedPortVars.stream().filter(entry -> ((PortFmi2Api)entry.getKey()).getMultiModelScalarVariableName().contains(key.getMultiModelScalarVariableName())).findAny().ifPresentOrElse(item -> {}, () -> sharedPortVars.add(java.util.Map.entry(key, value))));
            } else if (instruction instanceof InitSet) {
                this.mapSetInstruction(((InitSet)instruction).port(), sharedPortVars, fmuInstances, connections);
            } else if (instruction instanceof AlgebraicLoopInit) {
                this.mapAlgebraicLoopInitializationInstruction((AlgebraicLoopInit)instruction, fmuInstances, connections, sharedPortVars);
            } else if (instruction instanceof EnterInitMode) {
                ((ComponentVariableFmi2Api)fmuInstances.get(((EnterInitMode)instruction).fmu())).enterInitializationMode();
            } else if (instruction instanceof ExitInitMode) {
                ((ComponentVariableFmi2Api)fmuInstances.get(((ExitInitMode)instruction).fmu())).exitInitializationMode();
            } else {
                throw new RuntimeException("Unknown initialization instruction: " + instruction.toString());
            }
        });
        return sharedPortVars;
    }

    private java.util.Map<ComponentVariableFmi2Api, Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>>> mapCoSimStepInstructionsToMaBL(java.util.Map<String, List<CosimStepInstruction>> coSimStepInstructionsMap, java.util.Map<String, ComponentVariableFmi2Api> fmuInstances, DoubleVariableFmi2Api currentCommunicationPoint, Set<Fmi2Builder.StateVariable<PStm>> fmuStates, List<ConnectionModel> connections, List<Map.Entry<PortFmi2Api, VariableFmi2Api<Object>>> sharedPortVars, DoubleVariableFmi2Api currentStepSize) {
        HashMap<ComponentVariableFmi2Api, Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>>> fmuInstanceWithStepVar = new HashMap<ComponentVariableFmi2Api, Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>>>();
        ArrayList tentativePortVars = new ArrayList();
        if (!this.adaptiveModel.configurations().isEmpty() || coSimStepInstructionsMap.values().size() > 1) {
            throw new RuntimeException("Support for multiple algorithms is not yet supported in Maestro!");
        }
        String algorithmIdentifier = coSimStepInstructionsMap.keySet().iterator().next();
        List<CosimStepInstruction> coSimStepInstructions = coSimStepInstructionsMap.get(algorithmIdentifier);
        coSimStepInstructions.forEach(instruction -> {
            if (instruction instanceof core.Set) {
                this.mapSetInstruction(((core.Set)instruction).port(), sharedPortVars, fmuInstances, connections);
            } else if (instruction instanceof Get) {
                java.util.Map<PortFmi2Api, VariableFmi2Api<Object>> portsWithGets = this.mapGetInstruction(((Get)instruction).port(), fmuInstances);
                portsWithGets.forEach((key, value) -> sharedPortVars.stream().filter(entry -> ((PortFmi2Api)entry.getKey()).getMultiModelScalarVariableName().contains(key.getMultiModelScalarVariableName())).findAny().ifPresentOrElse(item -> {}, () -> sharedPortVars.add(java.util.Map.entry(key, value))));
            } else if (instruction instanceof Step) {
                Map.Entry<ComponentVariableFmi2Api, Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>>> instanceWithStep = this.mapStepInstruction((Step)instruction, fmuInstances, fmuInstanceWithStepVar, currentCommunicationPoint, currentStepSize);
                fmuInstanceWithStepVar.put(instanceWithStep.getKey(), instanceWithStep.getValue());
            } else if (instruction instanceof SaveState) {
                String MasterModelInstanceName = ((SaveState)instruction).fmu();
                try {
                    fmuStates.add(((ComponentVariableFmi2Api)fmuInstances.get(MasterModelInstanceName)).getState());
                }
                catch (XPathExpressionException e) {
                    throw new RuntimeException("Could not get state for fmu instance: " + MasterModelInstanceName);
                }
            } else if (instruction instanceof RestoreState) {
                fmuStates.stream().filter(state -> state.getName().contains(((RestoreState)instruction).fmu().toLowerCase(Locale.ROOT).split(MASTER_MODEL_FMU_INSTANCE_DELIMITER)[1])).findAny().ifPresent(Fmi2Builder.StateVariable::set);
            } else if (instruction instanceof AlgebraicLoop) {
                this.mapAlgebraicLoopCoSimStepInstruction(algorithmIdentifier, (AlgebraicLoop)instruction, fmuInstances, currentCommunicationPoint, fmuStates, connections, sharedPortVars, currentStepSize).forEach(fmuInstanceWithStepVar::putIfAbsent);
            } else if (instruction instanceof StepLoop) {
                this.mapStepLoopCoSimStepInstruction(algorithmIdentifier, (StepLoop)instruction, fmuInstances, currentCommunicationPoint, fmuStates, connections, sharedPortVars, currentStepSize);
            } else if (instruction instanceof GetTentative) {
                java.util.Map<PortFmi2Api, VariableFmi2Api<Object>> portsWithGets = this.mapGetTentativeInstruction(((GetTentative)instruction).port(), fmuInstances);
                portsWithGets.forEach((port, portValue) -> tentativePortVars.stream().filter(entry -> ((PortFmi2Api)entry.getKey()).getMultiModelScalarVariableName().contains(port.getMultiModelScalarVariableName())).findAny().ifPresentOrElse(item -> {}, () -> tentativePortVars.add(java.util.Map.entry(port, portValue))));
            } else if (instruction instanceof SetTentative) {
                this.mapSetTentativeInstruction(((SetTentative)instruction).port(), tentativePortVars, fmuInstances, connections);
            } else {
                throw new RuntimeException("Unknown CoSimStep instruction: " + instruction.toString());
            }
        });
        tentativePortVars.forEach(tentativePortMapEntry -> {
            ((ComponentVariableFmi2Api)fmuInstances.get(((PortFmi2Api)tentativePortMapEntry.getKey()).getMultiModelScalarVariableName().split("\\.")[1])).share(java.util.Map.ofEntries(tentativePortMapEntry));
            sharedPortVars.stream().filter(portMapVarEntry -> ((PortFmi2Api)portMapVarEntry.getKey()).getMultiModelScalarVariableName().contains(((PortFmi2Api)tentativePortMapEntry.getKey()).getMultiModelScalarVariableName())).findAny().ifPresentOrElse(item -> {}, () -> sharedPortVars.add(java.util.Map.entry((PortFmi2Api)tentativePortMapEntry.getKey(), (VariableFmi2Api)tentativePortMapEntry.getValue())));
        });
        return fmuInstanceWithStepVar;
    }

    private void mapStepLoopCoSimStepInstruction(String parentAlgorithmIdentifier, StepLoop instruction, java.util.Map<String, ComponentVariableFmi2Api> fmuInstances, DoubleVariableFmi2Api currentCommunicationPoint, Set<Fmi2Builder.StateVariable<PStm>> fmuStates, List<ConnectionModel> connections, List<Map.Entry<PortFmi2Api, VariableFmi2Api<Object>>> portsWithGet, DoubleVariableFmi2Api currentStepSize) {
        ArrayVariableFmi2Api fmuCommunicationPoints = this.dynamicScope.store("fmu_communication_points", (Object[])new Double[fmuInstances.entrySet().size()]);
        BooleanVariableFmi2Api stepAcceptedPredicate = this.dynamicScope.store("step_accepted_predicate", false);
        WhileMaBLScope stepAcceptedScope = this.dynamicScope.enterWhile((Fmi2Builder.Predicate)stepAcceptedPredicate.toPredicate().not());
        java.util.Map<ComponentVariableFmi2Api, Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>>> fmuInstanceWithStepVar = this.mapCoSimStepInstructionsToMaBL(java.util.Map.of(parentAlgorithmIdentifier, CollectionConverters.asJava((Seq)instruction.iterate())), fmuInstances, currentCommunicationPoint, fmuStates, connections, portsWithGet, currentStepSize);
        ArrayList acceptedStepVariables = new ArrayList();
        List acceptFmuRefs = CollectionConverters.asJava((Seq)instruction.untilStepAccept());
        fmuInstanceWithStepVar.forEach((fmuInstance, stepWithAccept) -> {
            if (acceptFmuRefs.stream().anyMatch(name -> name.toLowerCase(Locale.ROOT).contains(fmuInstance.getName()))) {
                acceptedStepVariables.add((Fmi2Builder.BoolVariable)stepWithAccept.getKey());
                this.dynamicScope.enterIf(((Fmi2Builder.BoolVariable)stepWithAccept.getKey()).toPredicate().not());
                this.loggerModule.trace("## FMU: '%s' DISCARDED step at sim-time: %f for step-size: %f and proposed sim-time: %.15f", new Object[]{fmuInstance.getName(), currentCommunicationPoint, currentStepSize, new VariableFmi2Api(null, ((Fmi2Builder.DoubleVariable)stepWithAccept.getValue()).getType(), (IMablScope)this.dynamicScope, (Fmi2Builder.DynamicActiveScope)this.dynamicScope, null, ((Fmi2Builder.DoubleVariable)stepWithAccept.getValue()).getExp())});
                this.dynamicScope.leave();
            }
        });
        stepAcceptedPredicate.setValue((Fmi2Builder.Variable)this.booleanLogicModule.allTrue("all_fmus_accepted_step_size", acceptedStepVariables));
        this.dynamicScope.enterIf((Fmi2Builder.Predicate)stepAcceptedPredicate.toPredicate().not());
        this.mapCoSimStepInstructionsToMaBL(java.util.Map.of(parentAlgorithmIdentifier, CollectionConverters.asJava((Seq)instruction.ifRetryNeeded())), fmuInstances, currentCommunicationPoint, fmuStates, connections, portsWithGet, currentStepSize);
        List stepSizes = fmuInstanceWithStepVar.values().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        for (int i = 0; i < stepSizes.size(); ++i) {
            ((VariableFmi2Api)fmuCommunicationPoints.items().get(i)).setValue((Fmi2Builder.ExpressionValue)new DoubleExpressionValue(((Fmi2Builder.DoubleVariable)stepSizes.get(i)).getExp()));
        }
        currentStepSize.setValue((Fmi2Builder.DoubleExpressionValue)this.mathModule.minRealFromArray(fmuCommunicationPoints).toMath().subtraction((Fmi2Builder.NumericTypedReferenceExp)currentCommunicationPoint));
        this.loggerModule.trace("## Step size was not accepted by every FMU! It has been changed to the smallest accepted step size of: %f", new Object[]{currentStepSize});
        this.dynamicScope.leave();
        stepAcceptedScope.leave();
    }

    private java.util.Map<ComponentVariableFmi2Api, Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>>> mapAlgebraicLoopCoSimStepInstruction(String parentAlgorithmIdentifier, AlgebraicLoop algebraicLoopInstruction, java.util.Map<String, ComponentVariableFmi2Api> fmuInstances, DoubleVariableFmi2Api currentCommunicationPoint, Set<Fmi2Builder.StateVariable<PStm>> fmuStates, List<ConnectionModel> connections, List<Map.Entry<PortFmi2Api, VariableFmi2Api<Object>>> portMapVars, DoubleVariableFmi2Api currentStepSize) {
        HashMap<ComponentVariableFmi2Api, Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>>> fmuWithStep = new HashMap<ComponentVariableFmi2Api, Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>>>();
        ArrayList<Map.Entry<PortFmi2Api, VariableFmi2Api<Object>>> tentativePortMapVars = new ArrayList<Map.Entry<PortFmi2Api, VariableFmi2Api<Object>>>();
        List convergedPortRefs = CollectionConverters.asJava((Seq)algebraicLoopInstruction.untilConverged());
        ArrayList convergedVariables = new ArrayList();
        BooleanVariableFmi2Api convergencePredicate = this.dynamicScope.store("coSimStep_convergence_predicate", false);
        IntVariableFmi2Api convergenceAttempts = this.dynamicScope.store("coSimStep_convergence_attempts", this.convAtt.intValue());
        DoubleVariableFmi2Api relTolVar = this.dynamicScope.store("coSimStep_relative_tolerance", this.relTol.doubleValue());
        DoubleVariableFmi2Api absTolVar = this.dynamicScope.store("coSimStep_absolute_tolerance", this.absTol.doubleValue());
        WhileMaBLScope convergenceScope = this.dynamicScope.enterWhile((Fmi2Builder.Predicate)convergencePredicate.toPredicate().not().and(convergenceAttempts.toMath().greaterThan((Fmi2Builder.NumericTypedReferenceExp)IntExpressionValue.of((int)0))));
        for (CosimStepInstruction instruction : CollectionConverters.asJava((Seq)algebraicLoopInstruction.iterate())) {
            if (instruction instanceof GetTentative) {
                java.util.Map<PortFmi2Api, VariableFmi2Api<Object>> portsWithGets = this.mapGetTentativeInstruction(((GetTentative)instruction).port(), fmuInstances);
                portsWithGets.forEach((port, portValue) -> {
                    tentativePortMapVars.stream().filter(entry -> ((PortFmi2Api)entry.getKey()).getMultiModelScalarVariableName().contains(port.getMultiModelScalarVariableName())).findAny().ifPresentOrElse(item -> {}, () -> tentativePortMapVars.add(java.util.Map.entry(port, portValue)));
                    convergedPortRefs.stream().filter(ref -> this.portRefMatch((PortRef)ref, port.aMablFmi2ComponentAPI.getEnvironmentName(), port.getName())).findAny().ifPresent(portRef -> convergedVariables.add(this.createCheckConvergenceSection(java.util.Map.entry(port, portValue), (PortRef)portRef, absTolVar, relTolVar)));
                });
                continue;
            }
            if (instruction instanceof SetTentative) {
                this.mapSetTentativeInstruction(((SetTentative)instruction).port(), tentativePortMapVars, fmuInstances, connections);
                continue;
            }
            this.mapCoSimStepInstructionsToMaBL(java.util.Map.of(parentAlgorithmIdentifier, List.of(instruction)), fmuInstances, currentCommunicationPoint, fmuStates, connections, portMapVars, currentStepSize).forEach(fmuWithStep::put);
        }
        tentativePortMapVars.forEach(tentativePortMapEntry -> {
            String fmuName = ((PortFmi2Api)tentativePortMapEntry.getKey()).aMablFmi2ComponentAPI.getOwner().getFmuIdentifier();
            String instanceName = fmuName.substring(1, fmuName.length() - 1) + MASTER_MODEL_FMU_INSTANCE_DELIMITER + ((PortFmi2Api)tentativePortMapEntry.getKey()).aMablFmi2ComponentAPI.getEnvironmentName();
            ((ComponentVariableFmi2Api)fmuInstances.get(instanceName)).share(java.util.Map.ofEntries(tentativePortMapEntry));
            portMapVars.stream().filter(portMapVarEntry -> ((PortFmi2Api)portMapVarEntry.getKey()).getMultiModelScalarVariableName().contains(((PortFmi2Api)tentativePortMapEntry.getKey()).getMultiModelScalarVariableName())).findAny().ifPresentOrElse(item -> {}, () -> portMapVars.add(java.util.Map.entry((PortFmi2Api)tentativePortMapEntry.getKey(), (VariableFmi2Api)tentativePortMapEntry.getValue())));
        });
        convergencePredicate.setValue((Fmi2Builder.Variable)this.booleanLogicModule.allTrue("converged", convergedVariables));
        this.dynamicScope.enterIf((Fmi2Builder.Predicate)convergencePredicate.toPredicate().not());
        this.mapCoSimStepInstructionsToMaBL(java.util.Map.of(parentAlgorithmIdentifier, CollectionConverters.asJava((Seq)algebraicLoopInstruction.ifRetryNeeded())), fmuInstances, currentCommunicationPoint, fmuStates, connections, portMapVars, currentStepSize);
        this.loggerModule.trace("## Convergence was not reached at sim-time: %f with step size: %f... %d convergence attempts remaining", new Object[]{currentCommunicationPoint, currentStepSize, convergenceAttempts});
        convergenceAttempts.decrement();
        this.dynamicScope.leave();
        convergenceScope.leave();
        return fmuWithStep;
    }

    private void mapAlgebraicLoopInitializationInstruction(AlgebraicLoopInit instruction, java.util.Map<String, ComponentVariableFmi2Api> fmuInstances, List<ConnectionModel> connections, List<Map.Entry<PortFmi2Api, VariableFmi2Api<Object>>> sharedPortVars) {
        BooleanVariableFmi2Api convergencePredicate = this.dynamicScope.store("initialization_convergence_predicate", false);
        IntVariableFmi2Api convergenceAttempts = this.dynamicScope.store("initialization_converge_attempts", this.convAtt.intValue());
        DoubleVariableFmi2Api relTolVar = this.dynamicScope.store("initialization_relative_tolerance", this.relTol.doubleValue());
        DoubleVariableFmi2Api absTolVar = this.dynamicScope.store("initialization_absolute_tolerance", this.absTol.doubleValue());
        WhileMaBLScope convergenceScope = this.dynamicScope.enterWhile((Fmi2Builder.Predicate)convergencePredicate.toPredicate().not().and(convergenceAttempts.toMath().greaterThan((Fmi2Builder.NumericTypedReferenceExp)IntExpressionValue.of((int)0))));
        this.mapInitializationActionsToMaBL(CollectionConverters.asJava((Seq)instruction.iterate()), fmuInstances, connections);
        ArrayList convergedVariables = new ArrayList();
        for (PortRef portRef : CollectionConverters.asJava((Seq)instruction.untilConverged())) {
            sharedPortVars.stream().filter(entry -> this.portRefMatch(portRef, ((PortFmi2Api)entry.getKey()).aMablFmi2ComponentAPI.getEnvironmentName(), ((PortFmi2Api)entry.getKey()).getName())).findAny().ifPresent(portMap -> convergedVariables.add(this.createCheckConvergenceSection((Map.Entry<PortFmi2Api, VariableFmi2Api<Object>>)portMap, portRef, absTolVar, relTolVar)));
        }
        convergencePredicate.setValue((Fmi2Builder.Variable)this.booleanLogicModule.allTrue("converged", convergedVariables));
        this.dynamicScope.enterIf((Fmi2Builder.Predicate)convergencePredicate.toPredicate().not());
        this.loggerModule.trace("## Convergence was not reached during initialization... %d convergence attempts remaining", new Object[]{convergenceAttempts});
        convergenceAttempts.decrement();
        convergenceScope.leave();
    }

    private BooleanVariableFmi2Api createCheckConvergenceSection(Map.Entry<PortFmi2Api, VariableFmi2Api<Object>> portMap, PortRef portRef, DoubleVariableFmi2Api absTolVar, DoubleVariableFmi2Api relTolVar) {
        VariableFmi2Api oldVariable = portMap.getKey().getSharedAsVariable();
        VariableFmi2Api<Object> newVariable = portMap.getValue();
        BooleanVariableFmi2Api isClose = this.dynamicScope.store("isClose", false);
        isClose.setValue((Fmi2Builder.Variable)this.mathModule.checkConvergence((Fmi2Builder.ProvidesTypedReferenceExp)oldVariable, newVariable, (Fmi2Builder.DoubleVariable)absTolVar, (Fmi2Builder.DoubleVariable)relTolVar));
        this.dynamicScope.enterIf((Fmi2Builder.Predicate)isClose.toPredicate().not());
        this.loggerModule.trace("Unstable signal %s = %.15E during algebraic loop", new Object[]{this.masterMRepresentationToMultiMRepresentation(portRef.fmu()) + MULTI_MODEL_FMU_INSTANCE_DELIMITER + portRef.port(), portMap.getValue()});
        this.dynamicScope.leave();
        return isClose;
    }

    private Map.Entry<ComponentVariableFmi2Api, Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>>> mapStepInstruction(Step instruction, java.util.Map<String, ComponentVariableFmi2Api> fmuInstances, java.util.Map<ComponentVariableFmi2Api, Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>>> fmuWithStep, DoubleVariableFmi2Api currentCommunicationPoint, DoubleVariableFmi2Api defaultCommunicationStepSize) {
        Map.Entry step;
        ComponentVariableFmi2Api instance = fmuInstances.get(instruction.fmu());
        if (instruction.by() instanceof AbsoluteStepSize) {
            step = instance.step((Fmi2Builder.DoubleVariable)currentCommunicationPoint, (Fmi2Builder.DoubleVariable)new DoubleVariableFmi2Api(null, null, null, null, DoubleExpressionValue.of((double)((AbsoluteStepSize)instruction.by()).H()).getExp()));
        } else if (instruction.by() instanceof RelativeStepSize) {
            ComponentVariableFmi2Api fmuInstance = fmuInstances.get(((RelativeStepSize)instruction.by()).fmu());
            step = instance.step((Fmi2Builder.DoubleVariable)currentCommunicationPoint, fmuWithStep.get(fmuInstance).getValue());
        } else {
            step = instance.step((Fmi2Builder.DoubleVariable)currentCommunicationPoint, (Fmi2Builder.DoubleVariable)defaultCommunicationStepSize);
        }
        return java.util.Map.entry(instance, step);
    }

    private void mapSetInstruction(PortRef portRef, List<Map.Entry<PortFmi2Api, VariableFmi2Api<Object>>> portMapVars, java.util.Map<String, ComponentVariableFmi2Api> fmuInstances, List<ConnectionModel> connections) {
        Map.Entry<PortFmi2Api, VariableFmi2Api<Object>> sourcePortWithValue = this.getSourcePortFromPortRef(portRef, portMapVars, connections);
        if (sourcePortWithValue != null) {
            Map.Entry<ComponentVariableFmi2Api, PortFmi2Api> instanceWithPort = this.getInstanceWithPortFromPortRef(portRef, fmuInstances);
            instanceWithPort.getKey().set((Fmi2Builder.Port)instanceWithPort.getValue(), (Fmi2Builder.Variable)sourcePortWithValue.getKey().getSharedAsVariable());
        }
    }

    private void mapSetTentativeInstruction(PortRef portRef, List<Map.Entry<PortFmi2Api, VariableFmi2Api<Object>>> portsWithGet, java.util.Map<String, ComponentVariableFmi2Api> fmuInstances, List<ConnectionModel> connections) {
        Map.Entry<PortFmi2Api, VariableFmi2Api<Object>> sourcePortWithValue = this.getSourcePortFromPortRef(portRef, portsWithGet, connections);
        if (sourcePortWithValue != null) {
            Map.Entry<ComponentVariableFmi2Api, PortFmi2Api> instanceWithPort = this.getInstanceWithPortFromPortRef(portRef, fmuInstances);
            instanceWithPort.getKey().set((Fmi2Builder.Port)instanceWithPort.getValue(), (Fmi2Builder.Variable)sourcePortWithValue.getValue());
        }
    }

    private Map.Entry<ComponentVariableFmi2Api, PortFmi2Api> getInstanceWithPortFromPortRef(PortRef portRef, java.util.Map<String, ComponentVariableFmi2Api> fmuInstances) {
        ComponentVariableFmi2Api instance = fmuInstances.get(portRef.fmu());
        PortFmi2Api port = instance.getPort(portRef.port());
        return java.util.Map.entry(instance, port);
    }

    private Map.Entry<PortFmi2Api, VariableFmi2Api<Object>> getSourcePortFromPortRef(PortRef portRef, List<Map.Entry<PortFmi2Api, VariableFmi2Api<Object>>> portMapVars, List<ConnectionModel> connections) {
        Optional<Map.Entry> portWithValue;
        Optional<ConnectionModel> connectionModel = connections.stream().filter(connection -> connection.trgPort().port().equals(portRef.port()) && connection.trgPort().fmu().equals(portRef.fmu())).findAny();
        if (connectionModel.isPresent() && (portWithValue = portMapVars.stream().filter(entry -> this.portRefMatch(((ConnectionModel)connectionModel.get()).srcPort(), ((PortFmi2Api)entry.getKey()).aMablFmi2ComponentAPI.getEnvironmentName(), ((PortFmi2Api)entry.getKey()).getName())).findAny()).isPresent()) {
            return portWithValue.get();
        }
        return null;
    }

    private java.util.Map<PortFmi2Api, VariableFmi2Api<Object>> mapGetTentativeInstruction(PortRef portRef, java.util.Map<String, ComponentVariableFmi2Api> fmuInstances) {
        return fmuInstances.get(portRef.fmu()).getTentative((IMablScope)this.dynamicScope, new String[]{portRef.port()});
    }

    private java.util.Map<PortFmi2Api, VariableFmi2Api<Object>> mapGetInstruction(PortRef portRef, java.util.Map<String, ComponentVariableFmi2Api> fmuInstances) {
        ComponentVariableFmi2Api instance = fmuInstances.get(portRef.fmu());
        java.util.Map portMapVar = instance.get(new String[]{portRef.port()});
        instance.share(portMapVar);
        return portMapVar;
    }

    private boolean portRefMatch(PortRef portRef, String multiModelInstanceName, String multiModelPortName) {
        return portRef.fmu().toLowerCase(Locale.ROOT).contains(multiModelInstanceName.toLowerCase(Locale.ROOT)) && portRef.port().toLowerCase(Locale.ROOT).contains(multiModelPortName.toLowerCase(Locale.ROOT));
    }

    private String masterMRepresentationToMultiMRepresentation(String masterModelRepresentation) {
        String[] interMediateRepresentation = masterModelRepresentation.split(MASTER_MODEL_FMU_INSTANCE_DELIMITER);
        return "{" + interMediateRepresentation[0] + "}." + String.join((CharSequence)MULTI_MODEL_FMU_INSTANCE_DELIMITER, Arrays.copyOfRange(interMediateRepresentation, 1, interMediateRepresentation.length));
    }
}

