/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin.verificationsuite.PrologVerifier;

import com.ugos.jiprolog.engine.JIPEngine;
import com.ugos.jiprolog.engine.JIPQuery;
import com.ugos.jiprolog.engine.JIPRuntimeException;
import com.ugos.jiprolog.engine.JIPSyntaxErrorException;
import com.ugos.jiprolog.engine.JIPTerm;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.plugin.verificationsuite.PrologVerifier.PrologGenerator;

public class InitializationPrologQuery {
    private final PrologGenerator prologGenerator;

    public InitializationPrologQuery(PrologGenerator prologGenerator) {
        this.prologGenerator = prologGenerator;
    }

    public InitializationPrologQuery() {
        this.prologGenerator = new PrologGenerator();
    }

    public boolean initializationOrderIsValid(List<Fmi2SimulationEnvironment.Variable> instantiationOrder, Set<Fmi2SimulationEnvironment.Relation> relations) {
        JIPEngine jip = new JIPEngine();
        JIPTerm queryTerm = null;
        Boolean isCorrectInitializationOrder = false;
        Path path = this.getPathToProlog();
        try {
            jip.consultFile(path + "/initialization.pl");
            String init = this.prologGenerator.CreateInitOperationOrder(instantiationOrder);
            String connections = this.prologGenerator.CreateConnections(relations.stream().filter(o -> o.getOrigin() == Fmi2SimulationEnvironment.Relation.InternalOrExternal.External).collect(Collectors.toList()));
            String fmus = this.prologGenerator.CreateFMUs(relations);
            queryTerm = jip.getTermParser().parseTerm(String.format("?- isInitSchedule(%s,%s, %s).", init, fmus, connections));
        }
        catch (JIPSyntaxErrorException ex) {
            ex.printStackTrace();
        }
        JIPQuery jipQuery = jip.openSynchronousQuery(queryTerm);
        try {
            isCorrectInitializationOrder = jipQuery.nextSolution() != null;
        }
        catch (JIPRuntimeException ex) {
            System.out.println(ex.getMessage());
        }
        jip.reset();
        return isCorrectInitializationOrder;
    }

    private Path getPathToProlog() {
        String currentPath = Paths.get("", new String[0]).toAbsolutePath().getParent().normalize().toString();
        String pluginString = "plugins";
        if (currentPath.contains("plugins")) {
            pluginString = "";
        }
        return Paths.get(currentPath, pluginString, "verificationsuite", "src", "main", "resources", "prologCode");
    }
}

