/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin.verificationsuite.graph;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.attribute.Style;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;

public class GraphDrawer {
    private String getInstanceName(Fmi2SimulationEnvironment.Variable o) {
        return o.scalarVariable.instance.getText() + "." + o.scalarVariable.scalarVariable.getName();
    }

    public void plotGraph(Set<? extends Fmi2SimulationEnvironment.Relation> relations, String name) throws IOException {
        MutableGraph g = Factory.mutGraph((String)name).setDirected(true);
        List connections = relations.stream().filter(o -> o.getDirection() == Fmi2SimulationEnvironment.Relation.Direction.OutputToInput).collect(Collectors.toList());
        for (Fmi2SimulationEnvironment.Relation rel : connections) {
            List<MutableNode> targets = rel.getTargets().values().stream().map(o -> Factory.mutNode((String)this.getInstanceName((Fmi2SimulationEnvironment.Variable)o)).add((Attributes)Color.BLACK)).collect(Collectors.toList());
            MutableNode source = Factory.mutNode((String)this.getInstanceName(rel.getSource())).add((Attributes)Color.BLACK);
            if (rel.getOrigin() == Fmi2SimulationEnvironment.Relation.InternalOrExternal.Internal) {
                targets.forEach(t -> {
                    g.add((LinkSource)t.addLink((LinkTarget)source));
                    g.nodes().stream().filter(o -> o == t).forEach(o -> o.links().forEach(r -> r.attrs().add((Attributes)Style.DASHED)));
                });
                continue;
            }
            targets.forEach(t -> g.add((LinkSource)source.addLink((LinkTarget)t)));
        }
        Graphviz.fromGraph((MutableGraph)g).height(500).render(Format.PNG).toFile(new File(String.format("example/%s.png", name)));
    }
}

