/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin.verificationsuite.prologverifier;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.fmi.Fmi2ModelDescription;
import org.intocps.maestro.framework.core.IRelation;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.plugin.ExpandException;

public class PrologGenerator {
    public String createInitOperationOrder(List<Fmi2SimulationEnvironment.Variable> instantiationOrder) {
        StringBuilder initOrder = new StringBuilder();
        instantiationOrder.forEach(o -> {
            try {
                initOrder.append(String.format("%s(%s, %s),", this.getMethod((Fmi2SimulationEnvironment.Variable)o), o.scalarVariable.getInstance().getText().toLowerCase(), o.scalarVariable.getScalarVariable().getName().toLowerCase()));
            }
            catch (ExpandException e) {
                e.printStackTrace();
            }
        });
        return this.fixListFormat(initOrder).toString();
    }

    public String createFMUs(Set<Fmi2SimulationEnvironment.Relation> relations) {
        StringBuilder fmuString = new StringBuilder();
        Set<LexIdentifier> fmuList = relations.stream().map(o -> o.getSource().scalarVariable.getInstance()).collect(Collectors.toSet());
        fmuList.forEach(fmu -> fmuString.append(String.format("fmu(%s, %s, %s),", fmu.getText().toLowerCase(), this.getInPorts(relations, (LexIdentifier)fmu), this.getOutPorts(relations, (LexIdentifier)fmu))));
        return this.fixListFormat(fmuString).toString();
    }

    public String createConnections(List<Fmi2SimulationEnvironment.Relation> relations) {
        StringBuilder connections = new StringBuilder();
        relations.forEach(relation -> relation.getTargets().values().forEach(target -> connections.append(String.format("connect(%s,%s, %s, %s),", relation.getSource().scalarVariable.getInstance().getText().toLowerCase(), relation.getSource().scalarVariable.getScalarVariable().getName().toLowerCase(), target.scalarVariable.getInstance().getText().toLowerCase(), target.scalarVariable.getScalarVariable().getName().toLowerCase()))));
        return this.fixListFormat(connections).toString();
    }

    private StringBuilder fixListFormat(StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        stringBuilder.insert(0, "[");
        stringBuilder.append("]");
        return stringBuilder;
    }

    private String getInPorts(Set<Fmi2SimulationEnvironment.Relation> relations, LexIdentifier fmu) {
        StringBuilder inPorts = new StringBuilder();
        Set<Fmi2SimulationEnvironment.Variable> inputPorts = relations.stream().map(p -> p.getTargets().values()).collect(Collectors.toList()).stream().flatMap(Collection::stream).collect(Collectors.toSet()).stream().filter(o -> o.scalarVariable.getInstance().getText().equals(fmu.getText())).collect(Collectors.toSet());
        inputPorts.forEach(port -> inPorts.append(String.format("port(%s, delayed),", port.scalarVariable.getScalarVariable().getName().toLowerCase())));
        return this.fixListFormat(inPorts).toString();
    }

    private String getOutPorts(Set<Fmi2SimulationEnvironment.Relation> relations, LexIdentifier fmu) {
        StringBuilder outPorts = new StringBuilder();
        Set externalRelations = relations.stream().filter(o -> o.getOrigin() == IRelation.InternalOrExternal.External).collect(Collectors.toSet());
        Set internalRelations = relations.stream().filter(o -> o.getOrigin() == IRelation.InternalOrExternal.Internal).collect(Collectors.toSet());
        Set<Fmi2SimulationEnvironment.Relation> outputPorts = externalRelations.stream().filter(p -> p.getSource().scalarVariable.getInstance() == fmu).collect(Collectors.toSet());
        outputPorts.forEach(port -> outPorts.append(String.format("port(%s, %s),", port.getSource().scalarVariable.getScalarVariable().getName().toLowerCase(), this.getInternalDependencies(port.getSource(), internalRelations))));
        return this.fixListFormat(outPorts).toString();
    }

    private String getInternalDependencies(Fmi2SimulationEnvironment.Variable source, Set<Fmi2SimulationEnvironment.Relation> internalRelations) {
        Set<Fmi2SimulationEnvironment.Variable> sources = internalRelations.stream().filter(rel -> rel.getSource() == source).map(o -> o.getTargets().values()).collect(Collectors.toSet()).stream().flatMap(Collection::stream).collect(Collectors.toSet());
        StringBuilder internalConnections = new StringBuilder();
        sources.forEach(s -> internalConnections.append(String.format("%s,", s.scalarVariable.getScalarVariable().getName().toLowerCase())));
        return this.fixListFormat(internalConnections).toString();
    }

    private String getMethod(Fmi2SimulationEnvironment.Variable variable) throws ExpandException {
        if (variable.scalarVariable.getScalarVariable().causality == Fmi2ModelDescription.Causality.Output) {
            return "getOut";
        }
        if (variable.scalarVariable.getScalarVariable().causality == Fmi2ModelDescription.Causality.Input) {
            return "setIn";
        }
        throw new ExpandException("Unknown causality of port");
    }
}

