use("iopt")

ISpec do(
  Options = Origin mimic do(

    create = method(err, out,
      self with(errorStream: err, outStream: out,
        formatters: [], files: [], directories: [],
        loadPatterns: [], onlyMatching: [], onlyLines: [],
        imports: [], uses: [],
        missingFiles: [], useColour: true, hasHelp?: false))

    shouldRun? = method(
      !hasHelp? && missingFiles empty?)

    order = method(
      ;; check if any pattern was set or use a default
      if(loadPatterns empty?,
        loadPatterns << "**/*_spec.ik")

      ;; check if any formatter was set, or use a default.
      if(formatters empty?,
        formatters << ISpec Formatter ProgressBarFormatter mimic)

      unless(useColour,
        formatters each(colour = method(text, +rest, text)))

      self)

    specsToRun = dict() do(
      values = list()
      cell("[]=") = method(key, value,
        super(key, value)
        values << value
        value)
    )

    exampleAdded = method(example,
      context = example context
      if(!onlyLines empty? && example code kind?("Message"),
        lines = (example code first line .. example code last line)
        if(onlyLines any?(o, lines include?(o)),
          specsToRun[context fullName] ||= context with(specs: list())
          specsToRun[context fullName] specs << example)
      )
      unless(onlyMatching empty?,
        if(onlyMatching any?(o, o === example fullDescription),
          specsToRun[context fullName] ||= context with(specs: list())
          specsToRun[context fullName] specs << example)
      )
    )

    runExamples = method(
      imports each(i, System loadPath << i)
      uses each(u, use(u))

      files each(f, use(f))
      directories each(d,
        FileSystem["#{d}/{#{loadPatterns join(",")}}"] each(f, use(f)))

      reporter = ISpec Reporter create(self)

      reporter start(0)
      success = true

      specifications = if(specsToRun empty?,  ISpec DescribeContext specs, specsToRun values)
      specifications each(spec,
        insideSuccess = spec run(reporter)
        if(success, success = insideSuccess))

      reporter end
      reporter dump
      success
    )
  )

  Runner = Origin mimic do(
    registerAtExitHook = method(
      System atExit(
        unless((ISpec didRun?) || !(ISpec ispec_options shouldRun?),
          success = ISpec run
          if(ISpec shouldExit?,
            System exit(success))))
      ISpec Runner registerAtExitHook = nil
    )

    CommandLine = Origin mimic do(
      run = method(instance_ispec_options,
        result = instance_ispec_options runExamples
        ISpec didRun? = true
        result
      )
    )

    OptionParser = IOpt mimic do(
      create = method(err, out,
        newOP = self mimic
        newOP errorStream = err
        newOP outStream = out
        newOP options = ISpec Options create(newOP errorStream, newOP outStream)
        newOP)

      formatters = dict(
        specdoc: ISpec Formatter SpecDocFormatter,
        progress: ISpec Formatter ProgressBarFormatter,
        html: ISpec Formatter HtmlFormatter)
      formatters[:s] = formatters[:specdoc]
      formatters[:p] = formatters[:progress]
      formatters[:h] = formatters[:html]

      banner = "Usage: ispec (FILE|DIRECTORY|GLOB)* [options]"

      on("-h", "--help", "Display usage.", @options hasHelp? = true)

      on("-f", "--format", format, to: System out,
        fkind = formatters[:(format)]
        unless(fkind,
          fkind = Message fromText(format) sendTo(Ground)
          unless(fkind mimics?(ISpec Formatter),
            error!("Expected #{format} to mimic ISpec Formatter")))
        formatter = fkind mimic
        case(to,
          or("-", System out), nil,
          if(System feature?(:java),
            formatter output = java:io:PrintStream new(to)))
        @options formatters << formatter
      ) do(
        cell(:documentation) = method(
          doc = list("Specify the output format to use.")
          doc << "Use the to: keyword argument to tell where to write output,"
          doc << "if given \"-\" will write to standard output."
          doc << "e.g."
          doc << "     --format specdoc to: specOut.txt"
          doc << " "
          formats = dict()
          receiver formatters each(pair,
            if(formats key?(pair value),
              formats[pair value] << pair key,
              formats[pair value] = list(pair key)))
          doc << "Builtin formats:"
          formats each(pair,
            doc << "%-20s %s" format(pair value sort join("|"),
              pair key documentation || pair key kind))

          doc << " "
          doc << "When not given a builtin format, ISpec will try to evaluate"
          doc << "the given argument to an ISpec Formatter kind"
          doc join("\n"))
      ); --format

      on("-p", "--pattern", "Limit files loaded to those matching pattern.",
        "Defaults to **/*_spec.ik.", pattern,
        @options loadPatterns << pattern)

      on("-c", "--color", "--colour", "Use colored output (default: true).", boolean true,
        @options useColour = boolean)

      on("-e", "--example", "Only execute examples matching name",
        "or if given a file, those listed in it", name_or_file,
        if(FileSystem file?(name_or_file),
          @options onlyMatching += FileSystem readFully(name_or_file) split("\n"),
          @options onlyMatching << name_or_file))

      on("-l", "--line", "Only execute examples defined at line_number", line_number,
        @options onlyLines << line_number)

      on("-I", "Add the specified directory to the load path before running anything", import,
        @options imports << import)

      on("-u", "Use the specified file before doing testing", ufile,
        @options uses << ufile)

      order = method(argv,
        parse!(argv)

        ;; process non option arguments
        programArguments each(arg,
          if(FileSystem directory?(arg),
            options directories << arg,
            if(FileSystem file?(arg),
              options files << arg,
              options missingFiles << arg)))

        options do( order ))

      order! = method(argv,
        order(argv)
        if(options hasHelp?, outStream println(self). System exit(0))
        unless(options missingFiles empty?,
          error!("Missing files: #{options missingFiles join(", ")}"))
        options)
    )
  )

  didRun? = false
  shouldExit? = true

  run = method(
    "runs all the defined descriptions and specs",

    if(didRun?, return(true))
    if(ispec_options shouldRun?,
      result = ispec_options runExamples
      self didRun? = true
      result,
      ispec_options banner println))

)
