/*
 * Decompiled with CFR 0.152.
 */
package org.ionspring.as400.autoconfigure;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.SecureAS400;
import com.ibm.as400.access.User;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.ionspring.as400.autoconfigure.NotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class AS400AuthenticationProvider
implements AuthenticationProvider {
    private final AS400 as400;
    Logger logger = LoggerFactory.getLogger(AS400AuthenticationProvider.class);

    public AS400AuthenticationProvider(AS400 as400) {
        this.as400 = as400;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            this.as400.validateSignon(authentication.getPrincipal().toString(), authentication.getCredentials().toString().toCharArray());
        }
        catch (AS400SecurityException e) {
            throw new BadCredentialsException("Invalid user/password");
        }
        catch (IOException e) {
            throw new AuthenticationServiceException("Authentication error", (Throwable)e);
        }
        if (!this.isAuthorized(authentication.getPrincipal().toString())) {
            throw new NotAuthorizedException("User " + authentication.getPrincipal().toString() + " not authorized.");
        }
        return new UsernamePasswordAuthenticationToken(authentication.getPrincipal(), authentication.getCredentials(), this.getGrantedAuthorities(authentication.getPrincipal().toString(), this.getSpecialAuthorities(authentication.getPrincipal().toString(), authentication.getCredentials().toString().toCharArray())));
    }

    public boolean isAuthorized(String username) {
        return true;
    }

    public List<GrantedAuthority> getSpecialAuthorities(String username, char[] password) {
        ArrayList<GrantedAuthority> retVal = new ArrayList<GrantedAuthority>();
        Object userAs400 = this.as400 instanceof SecureAS400 ? new SecureAS400(this.as400.getSystemName(), username, password) : new AS400(this.as400.getSystemName(), username, password);
        try (SecureAS400 secureAS400 = userAs400;){
            User user = new User((AS400)userAs400, username);
            if (user.hasSpecialAuthority(User.SPECIAL_AUTHORITY_AUDIT)) {
                retVal.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_SPECIAL_AUTHORITY_AUDIT"));
            }
            if (user.hasSpecialAuthority(User.SPECIAL_AUTHORITY_SERVICE)) {
                retVal.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_SPECIAL_AUTHORITY_SERVICE"));
            }
            if (user.hasSpecialAuthority(User.SPECIAL_AUTHORITY_ALL_OBJECT)) {
                retVal.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_SPECIAL_AUTHORITY_ALL_OBJECT"));
            }
            if (user.hasSpecialAuthority(User.SPECIAL_AUTHORITY_IO_SYSTEM_CONFIGURATION)) {
                retVal.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_SPECIAL_AUTHORITY_IO_SYSTEM_CONFIGURATION"));
            }
            if (user.hasSpecialAuthority(User.SPECIAL_AUTHORITY_JOB_CONTROL)) {
                retVal.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_SPECIAL_AUTHORITY_JOB_CONTROL"));
            }
            if (user.hasSpecialAuthority(User.SPECIAL_AUTHORITY_SAVE_SYSTEM)) {
                retVal.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_SPECIAL_AUTHORITY_SAVE_SYSTEM"));
            }
            if (user.hasSpecialAuthority(User.SPECIAL_AUTHORITY_SECURITY_ADMINISTRATOR)) {
                retVal.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_SPECIAL_AUTHORITY_SECURITY_ADMINISTRATOR"));
            }
            if (user.hasSpecialAuthority(User.SPECIAL_AUTHORITY_SPOOL_CONTROL)) {
                retVal.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_SPECIAL_AUTHORITY_SPOOL_CONTROL"));
            }
        }
        catch (AS400SecurityException | ErrorCompletingRequestException | ObjectDoesNotExistException | IOException | InterruptedException e) {
            this.logger.error("Exception while getting special authorities for user {}", (Object)username, (Object)e);
        }
        return retVal;
    }

    public List<GrantedAuthority> getGrantedAuthorities(String username, List<GrantedAuthority> specialAuthorities) {
        return specialAuthorities;
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }
}

