/*
 * Decompiled with CFR 0.152.
 */
package org.ionspring.as400.autoconfigure;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JDBCDataSource;
import com.ibm.as400.access.SecureAS400;
import java.util.Properties;
import javax.sql.DataSource;
import org.ionspring.as400.autoconfigure.AS400AuthenticationProvider;
import org.ionspring.as400.autoconfigure.IonSpringProperties;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.security.authentication.AuthenticationProvider;

@AutoConfiguration
@ConditionalOnClass(value={AS400.class})
@EnableConfigurationProperties(value={IonSpringProperties.class})
public class AS400AutoConfiguration {
    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public AS400 as400(IonSpringProperties properties) {
        if (!System.getProperty("os.name").equals("OS/400")) {
            if (properties.getAs400().getSystem().equals("localhost")) {
                throw new BeanCreationException("ionspring.as400.system can't be set to \"localhost\" when not running on OS400");
            }
            if (properties.getAs400().getUser().equals("*CURRENT")) {
                throw new BeanCreationException("ionspring.as400.user can't be set to \"*CURRENT\" when not running on OS400");
            }
            if (properties.getAs400().getPassword().equals("*CURRENT")) {
                throw new BeanCreationException("ionspring.as400.passord can't be set to \"*CURRENT\" when not running on OS400");
            }
        }
        if (properties.getAs400().isSecured()) {
            return new SecureAS400(properties.getAs400().getSystem(), properties.getAs400().getUser(), properties.getAs400().getPassword().toCharArray());
        }
        return new AS400(properties.getAs400().getSystem(), properties.getAs400().getUser(), properties.getAs400().getPassword().toCharArray());
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={AS400.class})
    public DataSource as400JDBCDataSource(IonSpringProperties properties, ConfigurableEnvironment configurableEnvironment, AS400 as400) {
        Properties props = new Properties();
        props.put("spring.jpa.properties.hibernate.dialect", "org.hibernate.dialect.DB2iDialect");
        configurableEnvironment.getPropertySources().addLast((PropertySource)new PropertiesPropertySource("ionspring", props));
        return new AS400JDBCDataSource(as400);
    }

    @ConditionalOnClass(value={AuthenticationProvider.class})
    @Lazy
    static class AS400AuthenticationManager {
        AS400AuthenticationManager() {
        }

        @Bean
        @ConditionalOnMissingBean
        public AuthenticationProvider as400AuthenticationManager(AS400 as400) {
            return new AS400AuthenticationProvider(as400);
        }
    }
}

