/*
 * Decompiled with CFR 0.152.
 */
package org.ionspring.vaadin;

import com.vaadin.flow.component.login.LoginI18n;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.internal.LocaleUtil;
import java.util.Optional;

public class LoginViewI18n
extends LoginI18n {
    private final I18NProvider i18NProvider;

    public static String getTranslation(String key, Object ... params) {
        Optional i18NProvider = LocaleUtil.getI18NProvider();
        return i18NProvider.map(i18n -> i18n.getTranslation(key, LocaleUtil.getLocale(() -> i18NProvider), params)).orElseGet(() -> "!{" + key + "}!");
    }

    public LoginViewI18n(I18NProvider i18NProvider) {
        this.i18NProvider = i18NProvider;
        this.setHeader(new HeaderI18n());
        this.setForm(new FormI18n());
        this.setErrorMessage(new ErrorMessageI18n());
    }

    public static class HeaderI18n
    extends LoginI18n.Header {
        public String getTitle() {
            return LoginViewI18n.getTranslation("ionspring.login.header.title", new Object[0]);
        }

        public String getDescription() {
            return LoginViewI18n.getTranslation("ionspring.login.header.description", new Object[0]);
        }
    }

    public static class FormI18n
    extends LoginI18n.Form {
        public String getTitle() {
            return LoginViewI18n.getTranslation("ionspring.login.form.title", new Object[0]);
        }

        public String getUsername() {
            return LoginViewI18n.getTranslation("ionspring.login.form.username", new Object[0]);
        }

        public String getPassword() {
            return LoginViewI18n.getTranslation("ionspring.login.form.password", new Object[0]);
        }

        public String getSubmit() {
            return LoginViewI18n.getTranslation("ionspring.login.form.submit", new Object[0]);
        }

        public String getForgotPassword() {
            return LoginViewI18n.getTranslation("ionspring.login.form.forgotPassword", new Object[0]);
        }
    }

    public static class ErrorMessageI18n
    extends LoginI18n.ErrorMessage {
        public String getTitle() {
            return LoginViewI18n.getTranslation("ionspring.login.errorMessage.title", new Object[0]);
        }

        public String getMessage() {
            return LoginViewI18n.getTranslation("ionspring.login.errorMessage.message", new Object[0]);
        }

        public String getUsername() {
            return LoginViewI18n.getTranslation("ionspring.login.errorMessage.username", new Object[0]);
        }

        public String getPassword() {
            return LoginViewI18n.getTranslation("ionspring.login.errorMessage.password", new Object[0]);
        }
    }
}

