/*
 * Decompiled with CFR 0.152.
 */
package org.ionspring.vaadin.autoconfigure;

import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.spring.SpringBootAutoConfiguration;
import org.ionspring.vaadin.SpringI18nProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;

@AutoConfiguration(before={SpringBootAutoConfiguration.class})
public class I18nAutoconfiguration {

    @Configuration
    @ConditionalOnClass(value={ResourceBundleMessageSource.class, I18NProvider.class})
    public static class I18nConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public MessageSource messageSource() {
            ResourceBundleMessageSource parentRBMS = new ResourceBundleMessageSource();
            parentRBMS.setBasename("ionspring-i18n/translations");
            parentRBMS.setDefaultEncoding("UTF-8");
            ResourceBundleMessageSource resourceBundleMessageSource = new ResourceBundleMessageSource();
            resourceBundleMessageSource.setBasename("vaadin-i18n/translations");
            resourceBundleMessageSource.setParentMessageSource((MessageSource)parentRBMS);
            resourceBundleMessageSource.setDefaultEncoding("UTF-8");
            return resourceBundleMessageSource;
        }

        @Bean
        @ConditionalOnMissingBean
        public I18NProvider i18NProvider() {
            return new SpringI18nProvider(this.messageSource());
        }
    }
}

