/*
 * Decompiled with CFR 0.152.
 */
package org.ionspring.vaadin;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.i18n.I18NProvider;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;

@Configuration
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/ionspring/vaadin/I18nUtils;", "Lorg/springframework/context/ApplicationListener;", "Lorg/springframework/context/event/ContextRefreshedEvent;", "<init>", "()V", "onApplicationEvent", "", "event", "Companion", "ionspring-vaadin-autoconfigure"})
public class I18nUtils
implements ApplicationListener<ContextRefreshedEvent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static I18NProvider i18nProvider;

    public void onApplicationEvent(@NotNull ContextRefreshedEvent event) {
        I18NProvider i18NProvider;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        try {
            Object object = event.getApplicationContext().getBean(I18NProvider.class);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.vaadin.flow.i18n.I18NProvider");
            i18NProvider = (I18NProvider)object;
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            i18NProvider = null;
        }
        i18nProvider = i18NProvider;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J9\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0010\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0011R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/ionspring/vaadin/I18nUtils$Companion;", "", "<init>", "()V", "i18nProvider", "Lcom/vaadin/flow/i18n/I18NProvider;", "getI18nProvider", "()Lcom/vaadin/flow/i18n/I18NProvider;", "setI18nProvider", "(Lcom/vaadin/flow/i18n/I18NProvider;)V", "getTranslation", "", "key", "override", "fallBack", "params", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "ionspring-vaadin-autoconfigure"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final I18NProvider getI18nProvider() {
            return i18nProvider;
        }

        public final void setI18nProvider(@Nullable I18NProvider i18NProvider) {
            i18nProvider = i18NProvider;
        }

        @NotNull
        public final String getTranslation(@NotNull String key, @Nullable String override, @NotNull String fallBack, Object ... params) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)fallBack, (String)"fallBack");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            String string = override;
            if (string == null) {
                I18NProvider i18NProvider = this.getI18nProvider();
                string = i18NProvider != null ? i18NProvider.getTranslation(key, UI.getCurrent().getLocale(), Arrays.copyOf(params, params.length)) : null;
                if (string == null) {
                    string = fallBack;
                }
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

