/*
 * Decompiled with CFR 0.152.
 */
package org.ionspring.vaadin;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.applayout.AppLayout;
import com.vaadin.flow.component.applayout.DrawerToggle;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.spring.security.AuthenticationContext;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class MainLayout
extends AppLayout {
    protected final transient AuthenticationContext authenticationContext;

    public MainLayout(@Autowired(required=false) AuthenticationContext authenticationContext, @Autowired(required=false) @Qualifier(value="navigation") Component navigation) {
        this.authenticationContext = authenticationContext;
        H3 logo = new H3(this.getTranslation("ionspring.layout.title", new Object[0]));
        logo.addClassNames(new String[]{"text-l", "my-auto", "ml-s"});
        HorizontalLayout header = new HorizontalLayout();
        if (authenticationContext != null && authenticationContext.isAuthenticated()) {
            Span spacer = new Span();
            spacer.addClassNames(new String[]{"ml-auto"});
            Span loggedAs = new Span(this.getTranslation("ionspring.layout.loggedInAs", new Object[]{authenticationContext.getPrincipalName().get()}));
            loggedAs.addClassNames(new String[]{"text-m", "my-auto", "hidden", "md:flex"});
            Button logout = new Button(this.getTranslation("ionspring.layout.logout", new Object[0]), (ComponentEventListener & Serializable)click -> authenticationContext.logout());
            logout.addClassNames(new String[]{"mr-s"});
            if (navigation != null) {
                DrawerToggle toggle = new DrawerToggle();
                header.add(new Component[]{toggle});
                this.addToDrawer(new Component[]{navigation});
            }
            header.add(new Component[]{logo, spacer, loggedAs, logout});
        } else {
            header.add(new Component[]{logo});
        }
        header.setWidth("100%");
        this.addToNavbar(new Component[]{header});
    }
}

