/*
 * Copyright 2016 Panagiotis Minos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ioperm.morphology.el;

/**
 * Helper class
 *
 * @author Panagiotis Minos
 * @since 1.0.0
 */
class CharUtils {

    static char toLower(char upper, boolean last) {
        switch (upper) {
            case 'Α':
                return 'α';
            case 'Ά':
                return 'ά';
            case 'Β':
                return 'β';
            case 'Γ':
                return 'γ';
            case 'Δ':
                return 'δ';
            case 'Ε':
                return 'ε';
            case 'Έ':
                return 'έ';
            case 'Ζ':
                return 'ζ';
            case 'Η':
                return 'η';
            case 'Ή':
                return 'ή';
            case 'Θ':
                return 'θ';
            case 'Ι':
                return 'ι';
            case 'Ί':
                return 'ί';
            case 'Ϊ':
                return 'ϊ';
            case 'Κ':
                return 'κ';
            case 'Λ':
                return 'λ';
            case 'Μ':
                return 'μ';
            case 'Ν':
                return 'ν';
            case 'Ξ':
                return 'ξ';
            case 'Ο':
                return 'ο';
            case 'Ό':
                return 'ό';
            case 'Π':
                return 'π';
            case 'Ρ':
                return 'ρ';
            case 'Σ':
                if (last) {
                    return 'ς';
                }
                return 'σ';
            case 'Τ':
                return 'τ';
            case 'Υ':
                return 'υ';
            case 'Ύ':
                return 'ύ';
            case 'Ϋ':
                return 'ϋ';
            case 'Φ':
                return 'φ';
            case 'Χ':
                return 'χ';
            case 'Ψ':
                return 'ψ';
            case 'Ω':
                return 'ω';
            case 'Ώ':
                return 'ώ';
            default:
                return upper;
        }
    }
}
