/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.auth.login.rememberme;

import java.sql.Timestamp;
import org.iplass.mtp.auth.token.AuthTokenInfo;
import org.iplass.mtp.util.DateUtil;

public class RememberMeTokenInfo
implements AuthTokenInfo {
    private String type;
    private String key;
    private boolean expired;
    private Timestamp expiryDate;

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Remember Me Token, ");
        if (this.expired) {
            sb.append("Expired");
        } else {
            sb.append("Expires: ");
            if (this.expiryDate != null) {
                sb.append(DateUtil.getDateTimeInstance(3, 3, true).format(this.expiryDate));
            } else {
                sb.append("Never");
            }
        }
        return sb.toString();
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public Timestamp getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Timestamp expiryDate) {
        this.expiryDate = expiryDate;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

