/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.command.async;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.iplass.mtp.command.IllegalParameterException;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.command.UploadFileHandle;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;

public class AsyncRequestContext
implements RequestContext,
Serializable {
    private static final long serialVersionUID = 1878806170353316070L;
    private Map<String, Object> attributeMap;

    public AsyncRequestContext() {
        this.attributeMap = new HashMap<String, Object>();
    }

    public AsyncRequestContext(Map<String, Object> attributeMap) {
        this.attributeMap = attributeMap == null ? new HashMap<String, Object>() : new HashMap<String, Object>(attributeMap);
    }

    @Override
    public String getParam(String name) {
        return this.getParam(name, String.class);
    }

    @Override
    public String[] getParams(String name) {
        return this.getParams(name, String.class);
    }

    @Override
    public <T> T getParam(String name, Class<T> type) {
        Map param = (Map)this.attributeMap.get("param");
        if (param == null) {
            return null;
        }
        try {
            return ConvertUtil.convert(type, param.get(name));
        }
        catch (RuntimeException e) {
            throw new IllegalParameterException(AsyncRequestContext.resourceString("impl.web.WebRequestContext.canNotConv", name), e);
        }
    }

    @Override
    public <T> T[] getParams(String name, Class<T> type) {
        Map param = (Map)this.attributeMap.get("param");
        if (param == null) {
            return null;
        }
        Object[] vals = (Object[])param.get(name);
        if (vals == null) {
            return null;
        }
        if (vals.getClass().getComponentType() == type) {
            return vals;
        }
        try {
            Object[] ret = (Object[])Array.newInstance(type, vals.length);
            for (int i = 0; i < vals.length; ++i) {
                ret[i] = ConvertUtil.convert(type, vals[i]);
            }
            return ret;
        }
        catch (RuntimeException e) {
            throw new IllegalParameterException(AsyncRequestContext.resourceString("impl.web.WebRequestContext.canNotConv", name), e);
        }
    }

    @Override
    public Boolean getParamAsBoolean(String name) {
        return this.getParam(name, Boolean.class);
    }

    @Override
    public Boolean[] getParamsAsBoolean(String name) {
        return this.getParams(name, Boolean.class);
    }

    @Override
    public Long getParamAsLong(String name) {
        return this.getParam(name, Long.class);
    }

    @Override
    public Long[] getParamsAsLong(String name) {
        return this.getParams(name, Long.class);
    }

    @Override
    public Integer getParamAsInt(String name) {
        return this.getParam(name, Integer.class);
    }

    @Override
    public Integer[] getParamsAsInt(String name) {
        return this.getParams(name, Integer.class);
    }

    @Override
    public Double getParamAsDouble(String name) {
        return this.getParam(name, Double.class);
    }

    @Override
    public Double[] getParamsAsDouble(String name) {
        return this.getParams(name, Double.class);
    }

    private <T extends java.util.Date> T getParamAsDate(String name, String format, Class<T> type) {
        Map param = (Map)this.attributeMap.get("param");
        if (param == null) {
            return null;
        }
        try {
            return ConvertUtil.convertToDate(type, param.get(name), format, false);
        }
        catch (RuntimeException e) {
            throw new IllegalParameterException(AsyncRequestContext.resourceString("impl.web.WebRequestContext.canNotConv", name), e);
        }
    }

    private <T extends java.util.Date> T[] getParamsAsDate(String name, String format, Class<T> type) {
        Map param = (Map)this.attributeMap.get("param");
        if (param == null) {
            return null;
        }
        Object[] vals = (Object[])param.get(name);
        if (vals == null) {
            return null;
        }
        if (vals.getClass().getComponentType() == type) {
            return (java.util.Date[])vals;
        }
        try {
            java.util.Date[] ret = (java.util.Date[])Array.newInstance(type, vals.length);
            for (int i = 0; i < vals.length; ++i) {
                ret[i] = ConvertUtil.convertToDate(type, vals[i], format, false);
            }
            return ret;
        }
        catch (RuntimeException e) {
            throw new IllegalParameterException(AsyncRequestContext.resourceString("impl.web.WebRequestContext.canNotConv", name), e);
        }
    }

    @Override
    public Date getParamAsDate(String name, String format) {
        return this.getParamAsDate(name, format, Date.class);
    }

    @Override
    public Date[] getParamsAsDate(String name, String format) {
        return (Date[])this.getParamsAsDate(name, format, Date.class);
    }

    @Override
    public Timestamp getParamAsTimestamp(String name, String format) {
        return this.getParamAsDate(name, format, Timestamp.class);
    }

    @Override
    public Timestamp[] getParamsAsTimestamp(String name, String format) {
        return (Timestamp[])this.getParamsAsDate(name, format, Timestamp.class);
    }

    @Override
    public Time getParamAsTime(String name, String format) {
        return this.getParamAsDate(name, format, Time.class);
    }

    @Override
    public Time[] getParamsAsTime(String name, String format) {
        return (Time[])this.getParamsAsDate(name, format, Time.class);
    }

    @Override
    public BigDecimal getParamAsBigDecimal(String name) {
        return this.getParam(name, BigDecimal.class);
    }

    @Override
    public BigDecimal[] getParamsAsBigDecimal(String name) {
        return this.getParams(name, BigDecimal.class);
    }

    @Override
    public UploadFileHandle getParamAsFile(String name) {
        throw new UnsupportedOperationException("getParamsAsFile not supported on AysncRequestContext");
    }

    @Override
    public UploadFileHandle[] getParamsAsFile(String name) {
        throw new UnsupportedOperationException("getParamsAsFile not supported on AysncRequestContext");
    }

    @Override
    public Map<String, Object> getParamMap() {
        return (Map)this.attributeMap.get("param");
    }

    @Override
    public Iterator<String> getParamNames() {
        Map<String, Object> param = this.getParamMap();
        if (param == null) {
            return Collections.emptyListIterator();
        }
        return param.keySet().iterator();
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.attributeMap.remove(name);
        } else {
            this.attributeMap.put(name, value);
        }
    }

    @Override
    public void removeAttribute(String name) {
        this.attributeMap.remove(name);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        return this.attributeMap.keySet().iterator();
    }

    @Override
    public SessionContext getSession() {
        throw new UnsupportedOperationException("getSession not supported on AysncRequestContext");
    }

    @Override
    public SessionContext getSession(boolean create) {
        throw new UnsupportedOperationException("getSession not supported on AysncRequestContext");
    }

    private static String resourceString(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }
}

