/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.iplass.mtp.entity.EntityApplicationException;
import org.iplass.mtp.entity.ValidateError;

public class EntityValidationException
extends EntityApplicationException {
    private static final long serialVersionUID = 742734525985667059L;
    private List<ValidateError> validateResults;

    public EntityValidationException() {
    }

    public EntityValidationException(String message) {
        super(message);
    }

    public EntityValidationException(String message, List<ValidateError> validateResults) {
        super(message + EntityValidationException.makeDetailMessage(validateResults));
        this.setValidateResults(validateResults);
    }

    @Deprecated
    public EntityValidationException(String message, ValidateError[] validateResult) {
        super(message + EntityValidationException.makeDetailMessage(new ArrayList<ValidateError>(Arrays.asList(validateResult))));
        this.setValidateResult(validateResult);
    }

    private static String makeDetailMessage(List<ValidateError> validateResults) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (ValidateError v : validateResults) {
            sb.append("\"");
            sb.append(v.getPropertyName());
            sb.append("=");
            sb.append(v.getErrorMessages());
            sb.append("\",");
        }
        sb.append("}");
        return sb.toString();
    }

    public List<ValidateError> getValidateResults() {
        return this.validateResults;
    }

    public void setValidateResults(List<ValidateError> validateResults) {
        this.validateResults = validateResults;
    }

    @Deprecated
    public ValidateError[] getValidateResult() {
        if (this.validateResults == null) {
            return null;
        }
        return this.validateResults.toArray(new ValidateError[this.validateResults.size()]);
    }

    @Deprecated
    public void setValidateResult(ValidateError[] validateResult) {
        this.validateResults = validateResult == null ? null : new ArrayList<ValidateError>(Arrays.asList(validateResult));
    }
}

