/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.bulkupdate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.iplass.mtp.entity.bulkupdate.BulkUpdatable;
import org.iplass.mtp.entity.bulkupdate.BulkUpdateEntity;

public class FunctionalEntityStream
implements BulkUpdatable {
    private String definitionName;
    private List<String> updateProperties;
    private Supplier<BulkUpdateEntity> onNext;
    private Runnable onClose;
    private Consumer<BulkUpdateEntity> onUpdated;

    public FunctionalEntityStream onNext(Supplier<BulkUpdateEntity> onNext) {
        this.onNext = onNext;
        return this;
    }

    public FunctionalEntityStream definitionName(String definitionName) {
        this.definitionName = definitionName;
        return this;
    }

    public FunctionalEntityStream updateProperties(String ... propName) {
        if (propName != null) {
            if (this.updateProperties == null) {
                this.updateProperties = new ArrayList<String>();
            }
            for (String pn : propName) {
                if (this.updateProperties.contains(pn)) continue;
                this.updateProperties.add(pn);
            }
        }
        return this;
    }

    public FunctionalEntityStream onClose(Runnable onClose) {
        this.onClose = onClose;
        return this;
    }

    public FunctionalEntityStream onUpdated(Consumer<BulkUpdateEntity> onUpdated) {
        this.onUpdated = onUpdated;
        return this;
    }

    @Override
    public Iterator<BulkUpdateEntity> iterator() {
        if (this.onNext == null) {
            throw new IllegalStateException("onNext function not specified");
        }
        return new Iterator<BulkUpdateEntity>(){
            private boolean peeked = false;
            private BulkUpdateEntity next;

            @Override
            public boolean hasNext() {
                this.peek();
                return this.next != null;
            }

            private void peek() {
                if (!this.peeked) {
                    this.next = (BulkUpdateEntity)FunctionalEntityStream.this.onNext.get();
                    this.peeked = true;
                }
            }

            @Override
            public BulkUpdateEntity next() {
                this.peek();
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.peeked = false;
                BulkUpdateEntity ret = this.next;
                this.next = null;
                return ret;
            }
        };
    }

    @Override
    public String getDefinitionName() {
        return this.definitionName;
    }

    @Override
    public void updated(BulkUpdateEntity updatedEntity) {
        if (this.onUpdated != null) {
            this.onUpdated.accept(updatedEntity);
        }
    }

    @Override
    public void close() {
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    @Override
    public List<String> getUpdateProperties() {
        return this.updateProperties;
    }
}

