/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.QueryVisitor;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;

public class GroupBy
implements ASTNode {
    private static final long serialVersionUID = 6843313143662604447L;
    private List<ValueExpression> groupingFieldList = new ArrayList<ValueExpression>();
    private RollType rollType;

    public List<ValueExpression> getGroupingFieldList() {
        return this.groupingFieldList;
    }

    public void setGroupingFieldList(List<ValueExpression> groupingFieldList) {
        this.groupingFieldList = groupingFieldList;
    }

    public void setRollType(RollType rollType) {
        this.rollType = rollType;
    }

    public RollType getRollType() {
        return this.rollType;
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    public void accept(QueryVisitor visitor) {
        if (visitor.visit(this) && this.groupingFieldList != null) {
            for (ValueExpression s : this.groupingFieldList) {
                s.accept(visitor);
            }
        }
    }

    public GroupBy add(ValueExpression groupingField) {
        if (groupingField == null) {
            throw new NullPointerException("groupingField is null");
        }
        if (this.groupingFieldList == null) {
            this.groupingFieldList = new ArrayList<ValueExpression>();
        }
        this.groupingFieldList.add(groupingField);
        return this;
    }

    public GroupBy add(Object groupingField) {
        if (groupingField == null) {
            throw new NullPointerException("groupingField is null");
        }
        if (this.groupingFieldList == null) {
            this.groupingFieldList = new ArrayList<ValueExpression>();
        }
        ValueExpression v = null;
        if (groupingField instanceof ValueExpression) {
            v = (ValueExpression)groupingField;
        } else if (groupingField instanceof String) {
            v = new EntityField((String)groupingField);
        } else {
            throw new QueryException("groupingField is ValueExpression or String type required.");
        }
        return this.add(v);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("group by ");
        if (this.groupingFieldList != null) {
            for (int i = 0; i < this.groupingFieldList.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.groupingFieldList.get(i));
            }
        }
        if (this.rollType != null) {
            switch (this.rollType) {
                case ROLLUP: {
                    sb.append(" rollup");
                    break;
                }
                case CUBE: {
                    sb.append(" cube");
                }
            }
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupingFieldList == null ? 0 : this.groupingFieldList.hashCode());
        result = 31 * result + (this.rollType == null ? 0 : this.rollType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupBy other = (GroupBy)obj;
        if (this.groupingFieldList == null ? other.groupingFieldList != null : !this.groupingFieldList.equals(other.groupingFieldList)) {
            return false;
        }
        return this.rollType == other.rollType;
    }

    public static enum RollType {
        ROLLUP,
        CUBE;

    }
}

