/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.AsOf;
import org.iplass.mtp.entity.query.From;
import org.iplass.mtp.entity.query.GroupBy;
import org.iplass.mtp.entity.query.Having;
import org.iplass.mtp.entity.query.Limit;
import org.iplass.mtp.entity.query.OrderBy;
import org.iplass.mtp.entity.query.PreparedQuery;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.QueryVisitor;
import org.iplass.mtp.entity.query.Refer;
import org.iplass.mtp.entity.query.Select;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.hint.Hint;
import org.iplass.mtp.entity.query.hint.HintComment;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.query.HavingSyntax;
import org.iplass.mtp.impl.query.QueryServiceHolder;
import org.iplass.mtp.impl.query.QuerySyntax;
import org.iplass.mtp.impl.query.WhereSyntax;
import org.iplass.mtp.util.StringUtil;

public class Query
implements ASTNode {
    private static final long serialVersionUID = -1325433515844859791L;
    private Select select;
    private From from;
    private List<Refer> refer;
    private Where where;
    private GroupBy groupBy;
    private Having having;
    private OrderBy orderBy;
    private Limit limit;
    private boolean versiond = false;
    private boolean localized = false;

    public static Query newQuery(String query) {
        try {
            return (Query)QueryServiceHolder.getInstance().getQueryParser().parse(query, QuerySyntax.class);
        }
        catch (ParseException e) {
            throw new QueryException(e.getMessage(), e);
        }
    }

    public static PreparedQuery newPreparedQuery(String query) {
        return new PreparedQuery(query);
    }

    public Query() {
    }

    public Query(Select select, From from, Where where) {
        this.select = select;
        this.from = from;
        this.where = where;
    }

    public Query(String query) throws QueryException {
        Query q = Query.newQuery(query);
        this.from = q.from;
        this.groupBy = q.groupBy;
        this.having = q.having;
        this.limit = q.limit;
        this.localized = q.localized;
        this.orderBy = q.orderBy;
        this.refer = q.refer;
        this.select = q.select;
        this.versiond = q.versiond;
        this.where = q.where;
    }

    @Override
    public Query copy() {
        return (Query)ASTNode.super.copy();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.groupBy == null ? 0 : this.groupBy.hashCode());
        result = 31 * result + (this.having == null ? 0 : this.having.hashCode());
        result = 31 * result + (this.limit == null ? 0 : this.limit.hashCode());
        result = 31 * result + (this.localized ? 1231 : 1237);
        result = 31 * result + (this.orderBy == null ? 0 : this.orderBy.hashCode());
        result = 31 * result + (this.refer == null ? 0 : this.refer.hashCode());
        result = 31 * result + (this.select == null ? 0 : this.select.hashCode());
        result = 31 * result + (this.versiond ? 1231 : 1237);
        result = 31 * result + (this.where == null ? 0 : this.where.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Query other = (Query)obj;
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        if (this.groupBy == null ? other.groupBy != null : !this.groupBy.equals(other.groupBy)) {
            return false;
        }
        if (this.having == null ? other.having != null : !this.having.equals(other.having)) {
            return false;
        }
        if (this.limit == null ? other.limit != null : !this.limit.equals(other.limit)) {
            return false;
        }
        if (this.localized != other.localized) {
            return false;
        }
        if (this.orderBy == null ? other.orderBy != null : !this.orderBy.equals(other.orderBy)) {
            return false;
        }
        if (this.refer == null ? other.refer != null : !this.refer.equals(other.refer)) {
            return false;
        }
        if (this.select == null ? other.select != null : !this.select.equals(other.select)) {
            return false;
        }
        if (this.versiond != other.versiond) {
            return false;
        }
        return !(this.where == null ? other.where != null : !this.where.equals(other.where));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.select != null) {
            sb.append(this.select.toString());
            sb.append(" ");
        }
        if (this.from != null) {
            sb.append(this.from.toString());
            sb.append(" ");
        }
        if (this.refer != null) {
            for (Refer r : this.refer) {
                sb.append(r.toString());
                sb.append(" ");
            }
        }
        if (this.where != null) {
            sb.append(this.where.toString());
        }
        if (this.groupBy != null) {
            sb.append(" ");
            sb.append(this.groupBy.toString());
        }
        if (this.having != null) {
            sb.append(" ");
            sb.append(this.having.toString());
        }
        if (this.orderBy != null) {
            sb.append(" ");
            sb.append(this.orderBy.toString());
        }
        if (this.limit != null) {
            sb.append(" ");
            sb.append(this.limit.toString());
        }
        if (this.versiond) {
            sb.append(" versioned");
        }
        if (this.localized) {
            sb.append(" localized");
        }
        return sb.toString();
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public From getFrom() {
        return this.from;
    }

    public void setFrom(From from) {
        this.from = from;
    }

    public List<Refer> getRefer() {
        return this.refer;
    }

    public void setRefer(List<Refer> refer) {
        this.refer = refer;
    }

    public Where getWhere() {
        return this.where;
    }

    public void setWhere(Where where) {
        this.where = where;
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(GroupBy groupBy) {
        this.groupBy = groupBy;
    }

    public Having getHaving() {
        return this.having;
    }

    public void setHaving(Having having) {
        this.having = having;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public boolean isVersiond() {
        return this.versiond;
    }

    public void setVersiond(boolean versiond) {
        this.versiond = versiond;
    }

    public boolean isLocalized() {
        return this.localized;
    }

    public void setLocalized(boolean localized) {
        this.localized = localized;
    }

    public void accept(QueryVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.select != null) {
                this.select.accept(visitor);
            }
            if (this.from != null) {
                this.from.accept(visitor);
            }
            if (this.refer != null) {
                for (Refer r : this.refer) {
                    r.accept(visitor);
                }
            }
            if (this.where != null) {
                this.where.accept(visitor);
            }
            if (this.groupBy != null) {
                this.groupBy.accept(visitor);
            }
            if (this.having != null) {
                this.having.accept(visitor);
            }
            if (this.orderBy != null) {
                this.orderBy.accept(visitor);
            }
            if (this.limit != null) {
                this.limit.accept(visitor);
            }
        }
    }

    public Select select() {
        if (this.select == null) {
            this.select = new Select();
        }
        return this.select;
    }

    public Query selectDistinct(Object ... value) {
        Select clause = this.select();
        clause.setDistinct(true);
        clause.add(value);
        return this;
    }

    public Query selectDistinct(HintComment hint, Object ... value) {
        Select clause = this.select();
        clause.setDistinct(true);
        clause.setHintComment(hint);
        clause.add(value);
        return this;
    }

    public Query select(Object ... value) {
        Select clause = this.select();
        clause.add(value);
        return this;
    }

    public Query select(HintComment hint, Object ... value) {
        Select clause = this.select();
        clause.setHintComment(hint);
        clause.add(value);
        return this;
    }

    public Query selectAll(String definitionName, boolean distinct, boolean withReferenceOidAndName) {
        return this.selectAll(definitionName, distinct, withReferenceOidAndName, false);
    }

    public Query selectAll(String definitionName, boolean distinct, boolean withReferenceOidAndName, boolean withReferenceVersion) {
        return this.selectAll(definitionName, distinct, withReferenceOidAndName, withReferenceVersion, true);
    }

    public Query selectAll(String definitionName, boolean distinct, boolean withReferenceOidAndName, boolean withReferenceVersion, boolean withMappedByReference) {
        return this.selectAll(definitionName, null, distinct, withReferenceOidAndName, withReferenceVersion, withMappedByReference);
    }

    public Query selectAll(String definitionName, HintComment hint, boolean distinct, boolean withReferenceOidAndName, boolean withReferenceVersion, boolean withMappedByReference) {
        Select clause = new Select();
        clause.setHintComment(hint);
        clause.setDistinct(distinct);
        EntityDefinition ed = ManagerLocator.getInstance().getManager(EntityDefinitionManager.class).get(definitionName);
        if (ed == null) {
            throw new EntityRuntimeException(definitionName + " not found.");
        }
        for (PropertyDefinition pd : ed.getPropertyList()) {
            if (pd instanceof ReferenceProperty) {
                ReferenceProperty rp = (ReferenceProperty)pd;
                if (StringUtil.isNotEmpty(rp.getMappedBy()) && !withMappedByReference) continue;
                if (withReferenceOidAndName) {
                    clause.add((Object)new EntityField(pd.getName() + "." + "oid"));
                    clause.add((Object)new EntityField(pd.getName() + "." + "name"));
                }
                if (!withReferenceVersion) continue;
                clause.add((Object)new EntityField(pd.getName() + "." + "version"));
                continue;
            }
            clause.add((Object)pd.getName());
        }
        this.setSelect(clause);
        this.from(definitionName);
        return this;
    }

    public Query hint(Hint hint) {
        this.select().addHint(hint);
        return this;
    }

    public Query hint(List<Hint> hintList) {
        this.select().addHint(hintList);
        return this;
    }

    private From from() {
        if (this.from == null) {
            this.from = new From();
        }
        return this.from;
    }

    public Query from(String entityName) {
        this.from().setEntityName(entityName);
        return this;
    }

    public Query from(String entityName, AsOf asOf) {
        this.from().setEntityName(entityName);
        this.from().setAsOf(asOf);
        return this;
    }

    public Query refer(String referenceName, Condition onCondition) {
        return this.refer(referenceName, null, onCondition);
    }

    public Query refer(String referenceName, AsOf asOf) {
        return this.refer(referenceName, asOf, null);
    }

    public Query refer(String referenceName, AsOf asOf, Condition onCondition) {
        if (this.refer == null) {
            this.refer = new ArrayList<Refer>();
        }
        if (this.refer.size() > 0) {
            Iterator<Refer> it = this.refer.iterator();
            while (it.hasNext()) {
                Refer r = it.next();
                if (!r.getReferenceName().getPropertyName().equals(referenceName)) continue;
                it.remove();
                break;
            }
        }
        this.refer.add(new Refer(new EntityField(referenceName), asOf, onCondition));
        return this;
    }

    public Refer refer(String referenceName) {
        if (this.refer == null) {
            this.refer = new ArrayList<Refer>();
        }
        if (this.refer.size() > 0) {
            for (Refer r : this.refer) {
                if (!r.getReferenceName().getPropertyName().equals(referenceName)) continue;
                return r;
            }
        }
        Refer newR = new Refer(new EntityField(referenceName), null);
        this.refer.add(newR);
        return newR;
    }

    public Where where() {
        if (this.where == null) {
            this.where = new Where();
        }
        return this.where;
    }

    public Query where(String whereClause) {
        String whereStr = "WHERE " + whereClause;
        try {
            this.where = (Where)QueryServiceHolder.getInstance().getQueryParser().parse(whereStr, WhereSyntax.class);
        }
        catch (ParseException e) {
            throw new QueryException(e.getMessage(), e);
        }
        return this;
    }

    public Query where(Condition whereCondition) {
        this.where = new Where(whereCondition);
        return this;
    }

    public Query groupBy(Object ... groupingField) {
        if (this.groupBy == null) {
            this.groupBy = new GroupBy();
        }
        for (Object v : groupingField) {
            this.groupBy.add(v);
        }
        return this;
    }

    public Query having(Condition havingCondition) {
        this.having = new Having(havingCondition);
        return this;
    }

    public Query having(String havingClause) {
        String havingStr = "HAVING " + havingClause;
        try {
            this.having = (Having)QueryServiceHolder.getInstance().getQueryParser().parse(havingStr, HavingSyntax.class);
        }
        catch (ParseException e) {
            throw new QueryException(e.getMessage(), e);
        }
        return this;
    }

    public Query order(SortSpec ... sortSpec) {
        if (this.orderBy == null) {
            this.orderBy = new OrderBy();
        }
        for (SortSpec o : sortSpec) {
            this.orderBy.add(o);
        }
        return this;
    }

    public Query limit(int limit) {
        this.limit = new Limit(limit);
        return this;
    }

    public Query limit(int limit, int offset) {
        this.limit = new Limit(limit, offset);
        return this;
    }

    public Query versioned(boolean versioned) {
        this.versiond = versioned;
        return this;
    }

    public Query versioned() {
        return this.versioned(true);
    }

    public Query localized(boolean localized) {
        this.localized = localized;
        return this;
    }

    public Query localized() {
        return this.localized(true);
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }
}

