/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.hint;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.hint.Hint;
import org.iplass.mtp.entity.query.hint.HintVisitor;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.query.QueryServiceHolder;
import org.iplass.mtp.impl.query.hint.HintCommentSyntax;

public class HintComment
implements ASTNode {
    private static final long serialVersionUID = -3352104778089451781L;
    private List<Hint> hintList;

    public HintComment() {
    }

    public HintComment(List<Hint> hintList) {
        this.hintList = hintList;
    }

    public HintComment(Hint ... hint) {
        if (hint != null) {
            this.hintList = new ArrayList<Hint>(hint.length);
            for (Hint h : hint) {
                this.hintList.add(h);
            }
        }
    }

    public HintComment(String hint) {
        try {
            HintComment hintComment = (HintComment)QueryServiceHolder.getInstance().getQueryParser().parse("/*+ " + hint + " */", HintCommentSyntax.class);
            this.hintList = hintComment.hintList;
        }
        catch (ParseException e) {
            throw new QueryException(e.getMessage(), e);
        }
    }

    public List<Hint> getHintList() {
        return this.hintList;
    }

    public void setHintList(List<Hint> hintList) {
        this.hintList = hintList;
    }

    public HintComment add(Hint hint) {
        if (this.hintList == null) {
            this.hintList = new ArrayList<Hint>();
        }
        this.hintList.add(hint);
        return this;
    }

    public HintComment add(List<Hint> hintList) {
        if (this.hintList == null) {
            this.hintList = new ArrayList<Hint>();
        }
        this.hintList.addAll(hintList);
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hintList == null ? 0 : this.hintList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HintComment other = (HintComment)obj;
        return !(this.hintList == null ? other.hintList != null : !this.hintList.equals(other.hintList));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("/*+ ");
        if (this.hintList != null) {
            for (Hint h : this.hintList) {
                sb.append(h).append(" ");
            }
        }
        sb.append("*/");
        return sb.toString();
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    public void accept(HintVisitor visitor) {
        if (visitor.visit(this) && this.hintList != null) {
            for (Hint h : this.hintList) {
                h.accept(visitor);
            }
        }
    }
}

