/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.value.controlflow;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.ValueExpressionVisitor;
import org.iplass.mtp.entity.query.value.controlflow.Else;
import org.iplass.mtp.entity.query.value.controlflow.When;
import org.iplass.mtp.entity.query.value.primary.PrimaryValue;

public class Case
extends PrimaryValue {
    private static final long serialVersionUID = 7079355836108192160L;
    private List<When> when;
    private Else elseClause;

    public Case() {
    }

    public Case(List<When> when, Else elseClause) {
        this.when = when;
        this.elseClause = elseClause;
    }

    public Case(Else elseClause, When ... when) {
        this.elseClause = elseClause;
        if (when != null) {
            ArrayList<When> whenList = new ArrayList<When>();
            for (When w : when) {
                whenList.add(w);
            }
            this.when = whenList;
        }
    }

    public List<When> getWhen() {
        return this.when;
    }

    public void setWhen(List<When> when) {
        this.when = when;
    }

    public Else getElseClause() {
        return this.elseClause;
    }

    public void setElseClause(Else elseClause) {
        this.elseClause = elseClause;
    }

    public Case when(Condition condition, ValueExpression result) {
        if (this.when == null) {
            this.when = new ArrayList<When>();
        }
        this.when.add(new When(condition, result));
        return this;
    }

    public Case elseClause(ValueExpression result) {
        this.elseClause = new Else(result);
        return this;
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    @Override
    public void accept(ValueExpressionVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.when != null) {
                for (When w : this.when) {
                    w.accept(visitor);
                }
            }
            if (this.elseClause != null) {
                this.elseClause.accept(visitor);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("case");
        if (this.when != null) {
            for (When w : this.when) {
                sb.append(" ");
                sb.append(w);
            }
        }
        if (this.elseClause != null) {
            sb.append(" ");
            sb.append(this.elseClause);
        }
        sb.append(" end");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elseClause == null ? 0 : this.elseClause.hashCode());
        result = 31 * result + (this.when == null ? 0 : this.when.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Case other = (Case)obj;
        if (this.elseClause == null ? other.elseClause != null : !this.elseClause.equals(other.elseClause)) {
            return false;
        }
        return !(this.when == null ? other.when != null : !this.when.equals(other.when));
    }
}

