/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.value.expr;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.ValueExpressionVisitor;

public class Polynomial
extends ValueExpression {
    private static final long serialVersionUID = 819825303377880827L;
    private List<ValueExpression> addValues;
    private List<ValueExpression> subValues;

    public Polynomial() {
    }

    public Polynomial(ValueExpression baseValue) {
        this.add(baseValue);
    }

    public Polynomial(List<ValueExpression> addValues, List<ValueExpression> subValues) {
        this.addValues = addValues;
        this.subValues = subValues;
    }

    public List<ValueExpression> getAddValues() {
        return this.addValues;
    }

    public void setAddValues(List<ValueExpression> addValues) {
        this.addValues = addValues;
    }

    public List<ValueExpression> getSubValues() {
        return this.subValues;
    }

    public void setSubValues(List<ValueExpression> subValues) {
        this.subValues = subValues;
    }

    public Polynomial add(ValueExpression value) {
        if (this.addValues == null) {
            this.addValues = new ArrayList<ValueExpression>();
        }
        this.addValues.add(value);
        return this;
    }

    public Polynomial sub(ValueExpression value) {
        if (this.subValues == null) {
            this.subValues = new ArrayList<ValueExpression>();
        }
        this.subValues.add(value);
        return this;
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        if (this.addValues != null) {
            for (i = 0; i < this.addValues.size(); ++i) {
                if (i != 0) {
                    sb.append("+");
                }
                sb.append(this.addValues.get(i));
            }
        }
        if (this.subValues != null) {
            for (i = 0; i < this.subValues.size(); ++i) {
                sb.append("-");
                sb.append(this.subValues.get(i));
            }
        }
        return sb.toString();
    }

    @Override
    public void accept(ValueExpressionVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.addValues != null) {
                for (ValueExpression v : this.addValues) {
                    v.accept(visitor);
                }
            }
            if (this.subValues != null) {
                for (ValueExpression v : this.subValues) {
                    v.accept(visitor);
                }
            }
        }
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addValues == null ? 0 : this.addValues.hashCode());
        result = 31 * result + (this.subValues == null ? 0 : this.subValues.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Polynomial other = (Polynomial)obj;
        if (this.addValues == null ? other.addValues != null : !this.addValues.equals(other.addValues)) {
            return false;
        }
        return !(this.subValues == null ? other.subValues != null : !this.subValues.equals(other.subValues));
    }
}

