/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.value.primary;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.ValueExpressionVisitor;
import org.iplass.mtp.entity.query.value.primary.PrimaryValue;

public class Function
extends PrimaryValue {
    private static final long serialVersionUID = -5685250677990276754L;
    private String name;
    private List<ValueExpression> arguments;

    public Function() {
    }

    public Function(String name, List<ValueExpression> arguments) {
        this.name = name;
        this.arguments = arguments;
    }

    public Function(String name, ValueExpression ... arguments) {
        this.name = name;
        if (arguments != null) {
            this.arguments = new ArrayList<ValueExpression>();
            for (ValueExpression ve : arguments) {
                this.arguments.add(ve);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ValueExpression> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<ValueExpression> arguments) {
        this.arguments = arguments;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append("(");
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.arguments.get(i));
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void accept(ValueExpressionVisitor visitor) {
        if (visitor.visit(this) && this.getArguments() != null) {
            for (ValueExpression v : this.getArguments()) {
                v.accept(visitor);
            }
        }
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arguments == null ? 0 : this.arguments.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Function other = (Function)obj;
        if (this.arguments == null ? other.arguments != null : !this.arguments.equals(other.arguments)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

