/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.value.primary;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.ValueExpressionVisitor;
import org.iplass.mtp.entity.query.value.primary.PrimaryValue;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.util.StringUtil;

public class Literal
extends PrimaryValue {
    private static final long serialVersionUID = 468081182204820851L;
    public static final String DATE_FROMAT = "yyyy-MM-dd";
    public static final String TIME_FROMAT = "HH:mm:ss";
    public static final String DATE_TIME_FROMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATE_TIME_WITH_TZ_FROMAT = "yyyy-MM-dd HH:mm:ss.SSSXXX";
    public static final String NO_BIND_HINT = "/*+no_bind*/";
    private Object value;
    private boolean bindable = true;

    public Literal() {
    }

    public Literal(Object value) {
        this.value = value;
        this.checkValidLiteral();
    }

    public Literal(Object value, boolean bindable) {
        this.value = value;
        this.bindable = bindable;
        this.checkValidLiteral();
    }

    private void checkValidLiteral() {
        if (this.value instanceof ASTNode) {
            throw new QueryException(this.value + " is not valid Literal.");
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        this.checkValidLiteral();
    }

    public boolean isBindable() {
        return this.bindable;
    }

    public void setBindable(boolean bindable) {
        this.bindable = bindable;
    }

    @Override
    public void accept(ValueExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        if (this.bindable) {
            if (this.value == null) {
                return "null";
            }
            if (this.value instanceof String) {
                return "'" + StringUtil.escapeEql((String)this.value) + "'";
            }
            if (this.value instanceof Date) {
                return "'" + ConvertUtil.formatDate((Date)this.value, DATE_FROMAT, false) + "'D";
            }
            if (this.value instanceof Timestamp) {
                return "'" + ConvertUtil.formatDate((Timestamp)this.value, DATE_TIME_FROMAT, true) + "'M";
            }
            if (this.value instanceof Time) {
                return "'" + ConvertUtil.formatDate((Time)this.value, TIME_FROMAT, false) + "'T";
            }
            if (this.value instanceof SelectValue) {
                return "'" + ((SelectValue)this.value).getValue() + "'S";
            }
            if (this.value instanceof BigDecimal) {
                return ((BigDecimal)this.value).toPlainString() + "G";
            }
            return this.value.toString();
        }
        if (this.value == null) {
            return "/*+no_bind*/null";
        }
        if (this.value instanceof String) {
            return "/*+no_bind*/'" + StringUtil.escapeEql((String)this.value) + "'";
        }
        if (this.value instanceof Date) {
            return "/*+no_bind*/'" + ConvertUtil.formatDate((Date)this.value, DATE_FROMAT, false) + "'D";
        }
        if (this.value instanceof Timestamp) {
            return "/*+no_bind*/'" + ConvertUtil.formatDate((Timestamp)this.value, DATE_TIME_FROMAT, true) + "'M";
        }
        if (this.value instanceof Time) {
            return "/*+no_bind*/'" + ConvertUtil.formatDate((Time)this.value, TIME_FROMAT, false) + "'T";
        }
        if (this.value instanceof SelectValue) {
            return "/*+no_bind*/'" + ((SelectValue)this.value).getValue() + "'S";
        }
        if (this.value instanceof BigDecimal) {
            return NO_BIND_HINT + ((BigDecimal)this.value).toPlainString() + "G";
        }
        return NO_BIND_HINT + this.value.toString();
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bindable ? 1231 : 1237);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Literal other = (Literal)obj;
        if (this.bindable != other.bindable) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

