/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.value.window;

import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.ValueExpressionVisitor;
import org.iplass.mtp.entity.query.value.primary.EntityField;

public class WindowSortSpec
implements ASTNode {
    private static final long serialVersionUID = 5226124289545051191L;
    private ValueExpression sortKey;
    private SortSpec.SortType type;
    private SortSpec.NullOrderingSpec nullOrderingSpec;

    public WindowSortSpec() {
    }

    public WindowSortSpec(String sortKeyField, SortSpec.SortType type) {
        this.sortKey = new EntityField(sortKeyField);
        this.type = type;
    }

    public WindowSortSpec(ValueExpression sortKey, SortSpec.SortType type) {
        this.sortKey = sortKey;
        this.type = type;
    }

    public WindowSortSpec(ValueExpression sortKey, SortSpec.SortType type, SortSpec.NullOrderingSpec nullOrderingSpec) {
        this.sortKey = sortKey;
        this.type = type;
        this.nullOrderingSpec = nullOrderingSpec;
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    public void accept(ValueExpressionVisitor visitor) {
        if (visitor.visit(this)) {
            this.sortKey.accept(visitor);
        }
    }

    public ValueExpression getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(ValueExpression sortKey) {
        this.sortKey = sortKey;
    }

    public SortSpec.SortType getType() {
        return this.type;
    }

    public void setType(SortSpec.SortType type) {
        this.type = type;
    }

    public SortSpec.NullOrderingSpec getNullOrderingSpec() {
        return this.nullOrderingSpec;
    }

    public void setNullOrderingSpec(SortSpec.NullOrderingSpec nullOrderingSpec) {
        this.nullOrderingSpec = nullOrderingSpec;
    }

    public WindowSortSpec nulls(SortSpec.NullOrderingSpec nullOrderingSpec) {
        this.nullOrderingSpec = nullOrderingSpec;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.sortKey);
        if (this.type != null) {
            sb.append(" ");
            sb.append((Object)this.type);
        }
        if (this.nullOrderingSpec != null) {
            sb.append(" NULLS ");
            sb.append((Object)this.nullOrderingSpec);
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nullOrderingSpec == null ? 0 : this.nullOrderingSpec.hashCode());
        result = 31 * result + (this.sortKey == null ? 0 : this.sortKey.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WindowSortSpec other = (WindowSortSpec)obj;
        if (this.nullOrderingSpec != other.nullOrderingSpec) {
            return false;
        }
        if (this.sortKey == null ? other.sortKey != null : !this.sortKey.equals(other.sortKey)) {
            return false;
        }
        return this.type == other.type;
    }
}

