/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.async.rdb.sql;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.iplass.mtp.async.ExceptionHandlingMode;
import org.iplass.mtp.async.TaskStatus;
import org.iplass.mtp.impl.async.rdb.CallableInput;
import org.iplass.mtp.impl.async.rdb.Task;
import org.iplass.mtp.impl.async.rdb.TaskSearchCondition;
import org.iplass.mtp.impl.async.rdb.sql.TaskQueueInsertSql;
import org.iplass.mtp.impl.core.Executable;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.rdb.adapter.QuerySqlHandler;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.script.GroovyObjectInputStream;
import org.iplass.mtp.spi.ServiceRegistry;

public class TaskQueueSearchSql
extends QuerySqlHandler {
    private TenantContextService tcs = ServiceRegistry.getRegistry().getService(TenantContextService.class);

    private void appendLoadSql(StringBuilder sb, int tenantId, int queueId, long taskId, boolean withBinary, String tableName, RdbAdapter rdb) {
        sb.append("SELECT TENANT_ID,Q_ID,TASK_ID,V_TIME,STATUS,G_KEY,VW_ID,VER,UP_DATE,SERVER_ID,RE_CNT,EXP_MODE,RES_FLG");
        if (withBinary) {
            sb.append(",CALLABLE,RES");
        }
        sb.append(" FROM " + tableName + " WHERE ");
        sb.append("TENANT_ID=").append(tenantId);
        sb.append(" AND Q_ID=").append(queueId);
        sb.append(" AND TASK_ID=").append(taskId);
    }

    public String toLoadSql(int tenantId, int queueId, long taskId, boolean withBinary, boolean withHistory, boolean withLock, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        this.appendLoadSql(sb, tenantId, queueId, taskId, withBinary, "TASK_QUEUE", rdb);
        if (withHistory) {
            sb.append(" UNION ALL ");
            this.appendLoadSql(sb, tenantId, queueId, taskId, withBinary, "TASK_QUEUE_HI", rdb);
        }
        return withLock ? rdb.createRowLockSql(sb.toString()) : sb.toString();
    }

    public String toForPollSql(int queueId, int[] workerIds, long currentTimeMillis, String serverId, int maxRetryCount, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT TENANT_ID,Q_ID,TASK_ID,V_TIME,STATUS,G_KEY,VW_ID,VER,UP_DATE,SERVER_ID,RE_CNT,EXP_MODE,RES_FLG");
        sb.append(" FROM TASK_QUEUE WHERE ");
        sb.append("Q_ID=").append(queueId);
        sb.append(" AND V_TIME<=").append(currentTimeMillis);
        sb.append(" AND STATUS IN('S','E')");
        sb.append(" AND VW_ID IN(-1,");
        for (int i = 0; i < workerIds.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(workerIds[i]);
        }
        sb.append(")");
        if (serverId != null) {
            sb.append(" AND SERVER_ID='").append(rdb.sanitize(serverId)).append("'");
        }
        sb.append(" AND RE_CNT<=" + maxRetryCount);
        sb.append(" ORDER BY V_TIME");
        return rdb.toLimitSql(sb.toString(), 100, 0);
    }

    private void appendSearchSql(StringBuilder sb, TaskSearchCondition cond, String tableName, RdbAdapter rdb) {
        sb.append("SELECT TENANT_ID,Q_ID,TASK_ID,V_TIME,STATUS,G_KEY,VW_ID,VER,UP_DATE,SERVER_ID,RE_CNT,EXP_MODE,RES_FLG");
        sb.append(" FROM " + tableName);
        if (cond.hasCond()) {
            sb.append(" WHERE ");
            boolean needAnd = false;
            if (cond.getTenantId() != null) {
                sb.append("TENANT_ID=").append(cond.getTenantId());
                needAnd = true;
            }
            if (cond.getQueueId() != null) {
                if (needAnd) {
                    sb.append(" AND ");
                }
                sb.append("Q_ID=").append(cond.getQueueId());
                needAnd = true;
            }
            if (cond.getTaskId() != null) {
                if (needAnd) {
                    sb.append(" AND ");
                }
                sb.append("TASK_ID=").append(cond.getTaskId());
                needAnd = true;
            }
            if (cond.getStatus() != null) {
                if (needAnd) {
                    sb.append(" AND ");
                }
                sb.append("STATUS='").append(TaskQueueInsertSql.toStatusStr(cond.getStatus())).append("'");
                needAnd = true;
            }
            if (cond.getGroupingKey() != null) {
                if (needAnd) {
                    sb.append(" AND ");
                }
                sb.append("G_KEY='").append(rdb.sanitize(cond.getGroupingKey())).append("'");
                needAnd = true;
            }
            if (cond.getRetryCount() != null) {
                if (needAnd) {
                    sb.append(" AND ");
                }
                sb.append("RE_CNT>=").append(cond.getRetryCount());
                needAnd = true;
            }
            if (cond.getReturnResult() != null) {
                if (needAnd) {
                    sb.append(" AND ");
                }
                sb.append("RES_FLG='").append(TaskQueueInsertSql.toFlagStr(cond.getReturnResult())).append("'");
                needAnd = true;
            }
            if (cond.getUpdateDate() != null) {
                if (needAnd) {
                    sb.append(" AND ");
                }
                sb.append("UP_DATE<=").append(rdb.toTimeStampExpression(cond.getUpdateDate()));
                needAnd = true;
            }
        }
    }

    public String toSearchSql(TaskSearchCondition cond, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        this.appendSearchSql(sb, cond, "TASK_QUEUE", rdb);
        if (cond.isWithHistory()) {
            sb.append(" UNION ALL ");
            this.appendSearchSql(sb, cond, "TASK_QUEUE_HI", rdb);
        }
        if (cond.isWithHistory()) {
            sb.append(" ORDER BY V_TIME DESC");
        } else {
            sb.append(" ORDER BY V_TIME");
        }
        if (cond.getLimit() != null) {
            int offset = 0;
            if (cond.getOffset() != null) {
                offset = cond.getOffset();
            }
            return rdb.toLimitSql(sb.toString(), cond.getLimit(), offset);
        }
        return sb.toString();
    }

    public String toCountPreExecutingSql(int tenantId, int queueId, String groupingKey, long taskId, String serverId, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT COUNT(*)");
        sb.append(" FROM TASK_QUEUE WHERE ");
        sb.append("TENANT_ID=").append(tenantId);
        sb.append(" AND Q_ID=").append(queueId);
        sb.append(" AND G_KEY='").append(rdb.sanitize(groupingKey)).append("'");
        sb.append(" AND TASK_ID<").append(taskId);
        sb.append(" AND STATUS IN('S','E')");
        if (serverId != null) {
            sb.append(" AND SERVER_ID='").append(rdb.sanitize(serverId)).append("'");
        }
        return sb.toString();
    }

    private TaskStatus toStatus(String taskName) {
        if (taskName == null || taskName.length() == 0) {
            return null;
        }
        if (taskName.equals("S")) {
            return TaskStatus.SUBMITTED;
        }
        if (taskName.equals("E")) {
            return TaskStatus.EXECUTING;
        }
        if (taskName.equals("A")) {
            return TaskStatus.ABORTED;
        }
        if (taskName.equals("R")) {
            return TaskStatus.RETURNED;
        }
        if (taskName.equals("C")) {
            return TaskStatus.COMPLETED;
        }
        if (taskName.equals("U")) {
            return TaskStatus.UNKNOWN;
        }
        return null;
    }

    private ExceptionHandlingMode toExpMode(String expMode) {
        if (expMode == null || expMode.length() == 0) {
            return null;
        }
        if (expMode.equals("A")) {
            return ExceptionHandlingMode.ABORT;
        }
        if (expMode.equals("F")) {
            return ExceptionHandlingMode.ABORT_LOG_FATAL;
        }
        if (expMode.equals("R")) {
            return ExceptionHandlingMode.RESTART;
        }
        return null;
    }

    private boolean toFlag(String flg) {
        if (flg == null || flg.length() == 0) {
            return false;
        }
        return "1".equals(flg);
    }

    private Object deserial(final Blob lob, TenantContext tc) {
        if (lob == null) {
            return null;
        }
        return ExecuteContext.executeAs(tc, new Executable<Object>(){

            /*
             * Exception decompiling
             */
            @Override
            public Object execute() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object deserial(InputStream is, TenantContext tc) {
        if (is == null) {
            return null;
        }
        try (final InputStream tis = is;){
            Object object = ExecuteContext.executeAs(tc, new Executable<Object>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Object execute() {
                    try (GroovyObjectInputStream ois = new GroovyObjectInputStream(new BufferedInputStream(tis));){
                        Object object = ois.readObject();
                        return object;
                    }
                    catch (IOException | ClassNotFoundException e) {
                        throw new IllegalStateException(e);
                    }
                }
            });
            return object;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Task toTask(RdbAdapter rdb, ResultSet rs, boolean withBinary) throws SQLException {
        Task task = new Task();
        task.setTenantId(rs.getInt("TENANT_ID"));
        task.setQueueId(rs.getInt("Q_ID"));
        task.setTaskId(rs.getLong("TASK_ID"));
        task.setVisibleTime(rs.getLong("V_TIME"));
        task.setStatus(this.toStatus(rs.getString("STATUS")));
        task.setGroupingKey(rs.getString("G_KEY"));
        task.setVirtualWorkerId(rs.getInt("VW_ID"));
        task.setVersion(rs.getLong("VER"));
        task.setUpdateTime(rs.getTimestamp("UP_DATE"));
        task.setExceptionHandlingMode(this.toExpMode(rs.getString("EXP_MODE")));
        task.setReturnResult(this.toFlag(rs.getString("RES_FLG")));
        task.setServerId(rs.getString("SERVER_ID"));
        task.setRetryCount(rs.getInt("RE_CNT"));
        if (withBinary) {
            TenantContext tc = this.tcs.getTenantContext(task.getTenantId());
            if (rdb.isSupportBlobType()) {
                task.setCallable((CallableInput)this.deserial(rs.getBlob("CALLABLE"), tc));
                task.setResult(this.deserial(rs.getBlob("RES"), tc));
            } else {
                task.setCallable((CallableInput)this.deserial(rs.getBinaryStream("CALLABLE"), tc));
                task.setResult(this.deserial(rs.getBinaryStream("RES"), tc));
            }
        }
        return task;
    }
}

