/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth;

import java.sql.Timestamp;
import java.util.List;
import java.util.function.Supplier;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.CredentialExpiredException;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.auth.login.LoginException;
import org.iplass.mtp.auth.login.LoginFailedException;
import org.iplass.mtp.auth.policy.AccountNotificationListener;
import org.iplass.mtp.auth.policy.LoginNotification;
import org.iplass.mtp.auth.policy.definition.NotificationType;
import org.iplass.mtp.impl.auth.AccountManagementModuleWrapper;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.LoggingAccountManagementModule;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.auth.UserContextImpl;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.AccountManagementModule;
import org.iplass.mtp.impl.auth.authenticate.AnonymousUserContext;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProvider;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProviderBase;
import org.iplass.mtp.impl.auth.authenticate.DefaultUserSessionStore;
import org.iplass.mtp.impl.auth.authenticate.TemporaryUserContext;
import org.iplass.mtp.impl.auth.authenticate.UserSessionStore;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.AuthenticationPolicyService;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaAuthenticationPolicy;
import org.iplass.mtp.impl.auth.authenticate.internal.InternalAuthenticationProvider;
import org.iplass.mtp.impl.auth.authenticate.trust.TrustedAuthValidateResult;
import org.iplass.mtp.impl.auth.authenticate.trust.TrustedAuthValidator;
import org.iplass.mtp.impl.auth.authorize.AuthorizationContext;
import org.iplass.mtp.impl.auth.authorize.AuthorizationProvider;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.impl.util.InternalDateUtil;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AuthService
implements Service {
    private static Logger logger = LoggerFactory.getLogger(AuthService.class);
    public static final String USER_HANDLE_NAME = "mtp.auth.UserHandle";
    static final String HOLDER_NAME = "mtp.auth.authCotnextHolder";
    private static final int DEFAULT_AUTH_PROVIDER = 0;
    private static final String PROVIDER_NAME = "providerName";
    private AuthenticationProvider[] authenticationProviders;
    private AuthorizationProvider authorizationProvider;
    private UserSessionStore userSessionStore;
    private AuthenticationPolicyService authPolicyService;
    private AccountManagementModule allAmm;

    public AuthenticationProvider getAuthenticationProvider() {
        if (this.authenticationProviders.length == 1) {
            return this.authenticationProviders[0];
        }
        UserContext user = this.userSessionStore.getUserContext();
        if (user == null) {
            return this.authenticationProviders[0];
        }
        return this.authenticationProviders[user.getAccount().getAuthenticationProviderIndex()];
    }

    public AuthenticationProvider[] getAuthenticationProviders() {
        return this.authenticationProviders;
    }

    public AuthorizationProvider getAuthorizationProvider() {
        return this.authorizationProvider;
    }

    public UserSessionStore getUserSessionStore() {
        return this.userSessionStore;
    }

    public UserContext getCurrentSessionUserContext() {
        UserContext userContext = this.userSessionStore.getUserContext();
        return userContext;
    }

    public boolean isAuthenticate() {
        return this.getCurrentSessionUserContext() != null;
    }

    public final <T> T doSecuredAction(UserContext userContext, Supplier<T> action) {
        AuthContextHolder userAuthContext = null;
        if (userContext != null) {
            userAuthContext = this.newAuthContextHolder(userContext);
        }
        return this.doSecuredAction(userAuthContext, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T doSecuredAction(AuthContextHolder userAuthContext, Supplier<T> action) {
        ExecuteContext exec = ExecuteContext.getCurrentContext();
        if (userAuthContext == null) {
            userAuthContext = this.newAuthContextHolder(new AnonymousUserContext());
        }
        boolean prevSecuredAction = userAuthContext.isSecuredAction();
        AuthContextHolder prev = null;
        try {
            prev = this.doSecuredActionPre(userAuthContext, exec);
            T t = action.get();
            return t;
        }
        finally {
            this.doSecuredActionPost(userAuthContext, prevSecuredAction, prev, exec);
        }
    }

    public AuthContextHolder doSecuredActionPre(AuthContextHolder doAuthContext, ExecuteContext ec) {
        AuthContextHolder prev = (AuthContextHolder)ec.getAttribute(HOLDER_NAME);
        ec.setAttribute(HOLDER_NAME, doAuthContext, false);
        ec.setClientId(doAuthContext.getUserContext().getIdForLog());
        MDC.put((String)"user", (String)ec.getClientId());
        doAuthContext.setSecuredAction(true);
        return prev;
    }

    public void doSecuredActionPost(AuthContextHolder doAuthContext, boolean prevSecuredAction, AuthContextHolder prev, ExecuteContext ec) {
        if (doAuthContext != null) {
            doAuthContext.setSecuredAction(prevSecuredAction);
        }
        ec.setAttribute(HOLDER_NAME, prev, false);
        if (prev != null) {
            ec.setClientId(prev.getUserContext().getIdForLog());
        } else {
            ec.setClientId(null);
        }
        MDC.put((String)"user", (String)ec.getClientId());
    }

    public final void reloadUserEntity() {
        UserContext current = this.getCurrentSessionUserContext();
        if (current != null && current.getUser() != null) {
            User userEntity = this.authenticationProviders[current.getAccount().getAuthenticationProviderIndex()].getUserEntityResolver().searchUser(current.getAccount());
            if (userEntity == null) {
                throw new LoginFailedException(CoreResourceBundleUtil.resourceString("impl.auth.AuthService.removed", new Object[0]));
            }
            current.resetUserEntity(userEntity);
            this.userSessionStore.setUserContext(current, false);
        }
    }

    public UserContext authenticate(Credential credential) throws LoginFailedException, CredentialExpiredException {
        long time = 0L;
        if (logger.isDebugEnabled()) {
            time = System.currentTimeMillis();
        }
        AccountHandle account = null;
        User userEntity = null;
        int providerIndex = 0;
        while (userEntity == null) {
            account = this.searchAccount(credential, providerIndex);
            userEntity = this.authenticationProviders[providerIndex = account.getAuthenticationProviderIndex()].getUserEntityResolver().searchUser(account);
            if (userEntity != null && !this.isValidAuthProviderOnAuthPolicy(userEntity, providerIndex)) {
                userEntity = null;
            }
            if (userEntity == null && providerIndex + 1 == this.authenticationProviders.length) break;
            ++providerIndex;
        }
        UserContextImpl user = (userEntity = this.validateUser(account.getCredential(), account, userEntity)).isTemporary() ? new TemporaryUserContext(account, userEntity) : new UserContextImpl(account, userEntity);
        this.authenticationProviders[account.getAuthenticationProviderIndex()].afterLoginSuccess(account);
        this.authenticationProviders[account.getAuthenticationProviderIndex()].getAuthLogger().loginSuccess(user);
        if (logger.isDebugEnabled()) {
            logger.debug("login process time:" + (System.currentTimeMillis() - time) + "ms.");
        }
        return user;
    }

    private boolean isValidAuthProviderOnAuthPolicy(User userEntity, int providerIndex) {
        String authPolicyName = userEntity.getAccountPolicy();
        MetaAuthenticationPolicy.AuthenticationPolicyRuntime apr = this.authPolicyService.getOrDefault(authPolicyName);
        if (apr == null) {
            return true;
        }
        if (apr.getMetaData().getAuthenticationProvider() == null || apr.getMetaData().getAuthenticationProvider().size() == 0) {
            return true;
        }
        for (String pn : apr.getMetaData().getAuthenticationProvider()) {
            if (!pn.equals(this.authenticationProviders[providerIndex].getProviderName())) continue;
            return true;
        }
        return false;
    }

    public void login(Credential credential) throws LoginFailedException, CredentialExpiredException {
        try {
            UserContext user = this.authenticate(credential);
            this.initializeSession(user, true);
            MetaAuthenticationPolicy.AuthenticationPolicyRuntime policy = AuthContextHolder.getAuthContext().getPolicy();
            if (policy != null && policy.getListeners() != null) {
                LoginNotification notification = new LoginNotification(NotificationType.LOGIN_SUCCESS, user.getUser().getOid(), credential, null);
                for (AccountNotificationListener l : policy.getListeners()) {
                    l.loginSuccess(notification);
                }
            }
        }
        catch (LoginFailedException e) {
            MetaAuthenticationPolicy.AuthenticationPolicyRuntime policy = this.authPolicyService.getOrDefault(null);
            if (policy != null && policy != null && policy.getListeners() != null) {
                LoginNotification notification = new LoginNotification(NotificationType.LOGIN_FAILED, null, credential, e);
                for (AccountNotificationListener l : policy.getListeners()) {
                    l.loginFailed(notification);
                }
            }
            throw e;
        }
    }

    public TrustedAuthValidateResult checkCurrentSessionTrusted() {
        TrustedAuthValidator tav;
        UserContext user = this.getCurrentSessionUserContext();
        if (user == null) {
            user = new AnonymousUserContext();
        }
        if ((tav = this.getAuthenticationProvider().getTrustedAuthValidator()) == null) {
            if (user instanceof AnonymousUserContext) {
                return new TrustedAuthValidateResult(false, IdPasswordCredential.class);
            }
            return new TrustedAuthValidateResult(true, null);
        }
        return tav.checkTrusted(user);
    }

    public void reAuth(Credential credential) throws LoginFailedException, CredentialExpiredException {
        UserContext pre = this.getCurrentSessionUserContext();
        if (pre == null || pre instanceof AnonymousUserContext) {
            throw new LoginFailedException(CoreResourceBundleUtil.resourceString("impl.auth.AuthService.checkIdPass", new Object[0]));
        }
        UserContext user = this.authenticate(credential);
        if (!pre.getAccount().getUnmodifiableUniqueKey().equals(user.getAccount().getUnmodifiableUniqueKey())) {
            this.authenticationProviders[pre.getAccount().getAuthenticationProviderIndex()].getAuthLogger().loginFail(credential, null);
            throw new LoginFailedException(CoreResourceBundleUtil.resourceString("impl.auth.AuthService.checkIdPass", new Object[0]));
        }
        this.initializeSession(user, false);
    }

    private AccountHandle searchAccount(Credential credential, int startIndex) throws LoginFailedException, CredentialExpiredException {
        AccountHandle account = null;
        try {
            for (int i = startIndex; i < this.authenticationProviders.length; ++i) {
                account = this.authenticationProviders[i].login(credential);
                if (account == null) continue;
                account.setAuthenticationProviderIndex(i);
                account.getAttributeMap().put(PROVIDER_NAME, this.authenticationProviders[i].getProviderName());
                break;
            }
        }
        catch (LoginException e) {
            this.getAuthenticationProvider().getAuthLogger().loginFail(credential, e);
            throw e;
        }
        if (account == null) {
            this.getAuthenticationProvider().getAuthLogger().loginFail(credential, null);
            throw new LoginFailedException(CoreResourceBundleUtil.resourceString("impl.auth.AuthService.checkIdPass", new Object[0]));
        }
        if (account.isAccountLocked()) {
            this.authenticationProviders[account.getAuthenticationProviderIndex()].getAuthLogger().loginLocked(credential);
            throw new LoginFailedException(CoreResourceBundleUtil.resourceString("impl.auth.AuthService.checkIdPass", new Object[0]));
        }
        return account;
    }

    private User validateUser(Credential credential, AccountHandle account, User userEntity) {
        if (userEntity == null) {
            this.authenticationProviders[account.getAuthenticationProviderIndex()].getAuthLogger().loginFail(credential, null);
            throw new LoginFailedException(CoreResourceBundleUtil.resourceString("impl.auth.AuthService.checkIdPass", new Object[0]));
        }
        Timestamp now = new Timestamp(InternalDateUtil.getNow().getTime());
        if (userEntity.getStartDate() != null && now.compareTo(userEntity.getStartDate()) < 0) {
            this.authenticationProviders[account.getAuthenticationProviderIndex()].getAuthLogger().loginLocked(credential);
            throw new LoginFailedException(CoreResourceBundleUtil.resourceString("impl.auth.AuthService.checkIdPass", new Object[0]));
        }
        if (userEntity.getEndDate() != null && now.compareTo(userEntity.getEndDate()) >= 0) {
            this.authenticationProviders[account.getAuthenticationProviderIndex()].getAuthLogger().loginLocked(credential);
            throw new LoginFailedException(CoreResourceBundleUtil.resourceString("impl.auth.AuthService.checkIdPass", new Object[0]));
        }
        if (account.isExpired()) {
            this.authenticationProviders[account.getAuthenticationProviderIndex()].getAuthLogger().loginPasswordExpired(credential);
            CredentialExpiredException cee = new CredentialExpiredException(CoreResourceBundleUtil.resourceString("impl.auth.AuthService.expired", new Object[0]));
            if (account.isInitialLogin()) {
                cee.setInitialLogin(true);
            }
            cee.setPolicyName(userEntity.getAccountPolicy());
            throw cee;
        }
        return userEntity;
    }

    void initializeSession(UserContext user, boolean withSessionInit) {
        this.userSessionStore.setUserContext(user, withSessionInit);
        AuthContextHolder.reflesh();
        ExecuteContext exec = ExecuteContext.getCurrentContext();
        UserContext uc = AuthContextHolder.getAuthContext().getUserContext();
        exec.setClientId(uc.getIdForLog());
        MDC.put((String)"user", (String)exec.getClientId());
    }

    public void resetCredential(Credential credential) {
        this.getAccountManagementModule().resetCredential(credential);
    }

    public void resetCredential(Credential credential, String policyName) {
        this.getAccountManagementModule(policyName).resetCredential(credential);
    }

    public void updateCredential(Credential oldCredential, Credential newCredential) {
        this.getAccountManagementModule().updateCredential(oldCredential, newCredential);
    }

    public void updateCredential(Credential oldCredential, Credential newCredential, String policyName) {
        this.getAccountManagementModule(policyName).updateCredential(oldCredential, newCredential);
    }

    public AccountManagementModule getAccountManagementModule(String policyName) {
        MetaAuthenticationPolicy.AuthenticationPolicyRuntime apr = this.authPolicyService.getOrDefault(policyName);
        if (apr == null) {
            return AuthenticationProviderBase.NO_UPDATABLE_AMM;
        }
        AccountManagementModule ret = apr.getAccountManagementModule();
        if (ret == null) {
            ret = this.allAmm;
        }
        return ret;
    }

    public AccountManagementModule getAccountManagementModule() {
        return this.allAmm;
    }

    public void logout() {
        UserContext user = this.getCurrentSessionUserContext();
        if (user != null) {
            for (AuthenticationProvider ap : this.authenticationProviders) {
                ap.logout(user.getAccount());
            }
        }
        this.userSessionStore.invalidateUserSession();
        if (user != null) {
            for (AuthenticationProvider ap : this.authenticationProviders) {
                ap.afterLogout(user.getAccount());
            }
        }
    }

    public AuthorizationContext getAuthorizationContext(Permission permission) {
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        int tenantId = ec.getClientTenantId();
        if (this.authorizationProvider.useSharedPermission(permission)) {
            TenantContextService tcService = ServiceRegistry.getRegistry().getService(TenantContextService.class);
            tenantId = tcService.getSharedTenantId();
        }
        return this.authorizationProvider.getAuthorizationContext(tenantId, permission);
    }

    AuthContextHolder newAuthContextHolder(UserContext userContext) {
        return new AuthContextHolder(userContext, this);
    }

    AuthContextHolder newAuthContextHolder() {
        UserContext account = this.getCurrentSessionUserContext();
        if (account != null) {
            return this.newAuthContextHolder(account);
        }
        return this.newAuthContextHolder(new AnonymousUserContext());
    }

    @Override
    public void init(Config config) {
        List<?> authenticationProviderList;
        this.userSessionStore = (UserSessionStore)config.getBean("userSessionStore");
        if (this.userSessionStore == null) {
            this.userSessionStore = new DefaultUserSessionStore();
            this.userSessionStore.inited(this, config);
        }
        if ((authenticationProviderList = config.getBeans("authenticationProvider")) != null) {
            this.authenticationProviders = authenticationProviderList.toArray(new AuthenticationProvider[authenticationProviderList.size() + 1]);
            InternalAuthenticationProvider internal = new InternalAuthenticationProvider();
            internal.inited(this, config);
            this.authenticationProviders[this.authenticationProviders.length - 1] = internal;
        }
        AccountManagementModuleWrapper ammr = new AccountManagementModuleWrapper();
        for (int i = 0; i < this.authenticationProviders.length; ++i) {
            ammr.add(this.authenticationProviders[i].getAccountManagementModule());
        }
        this.allAmm = new LoggingAccountManagementModule(ammr.stripOrThis());
        this.authorizationProvider = (AuthorizationProvider)config.getBean("authorizationProvider");
        this.authPolicyService = ServiceRegistry.getRegistry().getService(AuthenticationPolicyService.class);
    }

    @Override
    public void destroy() {
    }
}

