/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.builtin;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.NoPermissionException;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.UserExistsException;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.CredentialUpdateException;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.auth.policy.AccountNotification;
import org.iplass.mtp.auth.policy.PasswordNotification;
import org.iplass.mtp.auth.policy.PropertyNotification;
import org.iplass.mtp.auth.policy.definition.NotificationType;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.value.aggregate.Count;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.AccountManagementModule;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProviderBase;
import org.iplass.mtp.impl.auth.authenticate.builtin.AccountStore;
import org.iplass.mtp.impl.auth.authenticate.builtin.BuiltinAccount;
import org.iplass.mtp.impl.auth.authenticate.builtin.BuiltinAccountHandle;
import org.iplass.mtp.impl.auth.authenticate.builtin.Password;
import org.iplass.mtp.impl.auth.authenticate.builtin.PasswordHashSetting;
import org.iplass.mtp.impl.auth.authenticate.builtin.RdbAccountStore;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.AuthenticationPolicyService;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaAuthenticationPolicy;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.definition.DefinitionService;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.impl.util.random.SecureRandomGenerator;
import org.iplass.mtp.impl.util.random.SecureRandomService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.TenantAuthInfo;
import org.iplass.mtp.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuiltinAuthenticationProvider
extends AuthenticationProviderBase {
    private static Logger logger = LoggerFactory.getLogger(BuiltinAuthenticationProvider.class);
    private TenantContextService tenantContextService;
    private AuthenticationPolicyService authPolicyService;
    private boolean updatable;
    private BuiltinAccountManagementModule amm = new BuiltinAccountManagementModule();
    private AccountStore accountDao;
    private List<PasswordHashSetting> passwordHashSettings;

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public List<PasswordHashSetting> getPasswordHashSettings() {
        return this.passwordHashSettings;
    }

    public void setPasswordHashSettings(List<PasswordHashSetting> passwordHashSettings) {
        this.passwordHashSettings = passwordHashSettings;
    }

    public boolean isSharedLoginUser() {
        TenantContext shareTenantContext = this.tenantContextService.getSharedTenantContext();
        MetaDataEntry mde = shareTenantContext.getMetaDataContext().getMetaDataEntry(DefinitionService.getInstance().getPath(EntityDefinition.class, "mtp.auth.User"));
        return mde.isDataSharable();
    }

    private PasswordHashSetting selectSetting(String ver) {
        if (ver == null || ver.length() == 0 || this.passwordHashSettings == null) {
            return null;
        }
        for (int i = this.passwordHashSettings.size() - 1; i >= 0; --i) {
            PasswordHashSetting set = this.passwordHashSettings.get(i);
            if (!ver.equals(set.getVersion())) continue;
            return set;
        }
        return null;
    }

    private String[] divVerAndSalt(String saltString) {
        if (saltString != null && saltString.length() != 0 && saltString.charAt(0) == '$') {
            int index = saltString.indexOf(36, 1);
            String ver = saltString.substring(1, index);
            String salt = saltString.substring(index + 1);
            return new String[]{ver, salt};
        }
        return new String[]{null, saltString};
    }

    private MetaAuthenticationPolicy.AuthenticationPolicyRuntime getPolicy(String policyName) {
        MetaAuthenticationPolicy.AuthenticationPolicyRuntime pol = this.authPolicyService.getOrDefault(policyName);
        if (pol == null) {
            throw new SystemException("policy:" + policyName + " not found.");
        }
        return pol;
    }

    @Override
    public AccountHandle login(Credential credential) {
        if (!(credential instanceof IdPasswordCredential)) {
            return null;
        }
        String accountId = ((IdPasswordCredential)credential).getId();
        String password = ((IdPasswordCredential)credential).getPassword();
        int tenantId = this.getTenantId();
        BuiltinAccount account = this.accountDao.getAccount(tenantId, accountId);
        if (account == null) {
            return null;
        }
        Timestamp lastLoginOn = account.getLastLoginOn();
        MetaAuthenticationPolicy.AuthenticationPolicyRuntime policy = this.getPolicy(account.getPolicyName());
        AuthContextHolder.getAuthContext().setPolicy(policy);
        boolean needAccountUpdate = policy.initLoginStatus(account);
        String[] verAndSalt = this.divVerAndSalt(account.getSalt());
        if (!account.getPassword().equals(this.convertPassword(password, verAndSalt[1], this.selectSetting(verAndSalt[0])))) {
            this.loginFail(account, policy);
            return null;
        }
        account.setPassword(null);
        account.setSalt(null);
        BuiltinAccountHandle user = new BuiltinAccountHandle(account, policy.getMetaData().getName());
        if (needAccountUpdate |= policy.checkLoginPolicy(user, account)) {
            this.accountDao.updateAccountLoginStatus(account);
        }
        account.setLastLoginOn(lastLoginOn);
        return user;
    }

    private void loginFail(BuiltinAccount account, MetaAuthenticationPolicy.AuthenticationPolicyRuntime policy) {
        if (policy.isCheckLockout()) {
            account.loginFail();
            Transaction.requiresNew(t -> this.accountDao.updateAccountLoginStatus(account));
            if (policy.isJustLockedout(account)) {
                policy.notify(new AccountNotification(NotificationType.ROCKEDOUT, account.getOid()));
            }
        }
    }

    @Override
    public void logout(AccountHandle user) {
    }

    @Override
    public Class<? extends Credential> getCredentialType() {
        return IdPasswordCredential.class;
    }

    @Override
    protected Class<? extends AccountHandle> getAccountHandleClassForTrust() {
        return BuiltinAccountHandle.class;
    }

    @Override
    public void destroyed() {
        super.destroyed();
    }

    @Override
    public void inited(AuthService s, Config config) {
        super.inited(s, config);
        this.tenantContextService = ServiceRegistry.getRegistry().getService(TenantContextService.class);
        this.authPolicyService = ServiceRegistry.getRegistry().getService(AuthenticationPolicyService.class);
        this.accountDao = new RdbAccountStore();
        this.accountDao.inited(this, config);
        if (this.passwordHashSettings == null) {
            throw new ServiceConfigrationException("passwordHashSettings must specified.");
        }
    }

    @Override
    public AccountManagementModule getAccountManagementModule() {
        return this.amm;
    }

    private String convertPassword(String password, String salt, PasswordHashSetting setting) {
        return setting.hash(password, salt);
    }

    private static String makeSalt() {
        return RandomHolder.random.secureRandomToken();
    }

    private int getTenantId() {
        int tenantId = this.isSharedLoginUser() ? this.tenantContextService.getSharedTenantId() : ExecuteContext.getCurrentContext().getCurrentTenant().getId();
        return tenantId;
    }

    private boolean isUserAdminRole(Tenant tenant, AuthContext auth) {
        if (auth.getUser().isAdmin()) {
            return true;
        }
        List<String> userAdminRoles = tenant.getTenantConfig(TenantAuthInfo.class).getUserAdminRoles();
        if (userAdminRoles != null) {
            for (String role : userAdminRoles) {
                if (!auth.userInRole(role)) continue;
                return true;
            }
        }
        return false;
    }

    private static String resourceString(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }

    private class BuiltinAccountManagementModule
    implements AccountManagementModule {
        private BuiltinAccountManagementModule() {
        }

        @Override
        public void create(User user) {
            if (this.canCreate()) {
                User userEntity;
                AuthContext authContext = AuthContext.getCurrentContext();
                Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
                MetaAuthenticationPolicy.AuthenticationPolicyRuntime policy = BuiltinAuthenticationProvider.this.getPolicy(user.getAccountPolicy());
                if (!authContext.isPrivileged()) {
                    if (user.isAdmin() && !authContext.getUser().isAdmin()) {
                        throw new NoPermissionException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.builtin.BuiltinAuthenticationProvider.registerAdmin", new Object[0]));
                    }
                    if (user.getAccountPolicy() != null && !user.getAccountPolicy().equals("DEFAULT") && !BuiltinAuthenticationProvider.this.isUserAdminRole(tenant, authContext)) {
                        throw new NoPermissionException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.builtin.BuiltinAuthenticationProvider.canNotSetSecuredProperty", new Object[0]));
                    }
                }
                if (policy.getMetaData().getPasswordPolicy().isCreateAccountWithSpecificPassword() && user.getPassword() != null) {
                    policy.checkPasswordPattern(user.getPassword());
                }
                if ((userEntity = this.getUserEntity(user.getAccountId(), false)) != null) {
                    throw new UserExistsException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.builtin.BuiltinAuthenticationProvider.alreadyRegistered", new Object[0]));
                }
            }
        }

        @Override
        public void afterCreate(User user) {
            if (this.canCreate()) {
                MetaAuthenticationPolicy.AuthenticationPolicyRuntime policy = BuiltinAuthenticationProvider.this.getPolicy(user.getAccountPolicy());
                int tenantId = BuiltinAuthenticationProvider.this.getTenantId();
                String registId = ExecuteContext.getCurrentContext().getClientId();
                BuiltinAccount account = BuiltinAuthenticationProvider.this.accountDao.getAccount(tenantId, user.getAccountId());
                if (account == null) {
                    String newPassword;
                    account = new BuiltinAccount();
                    account.setTenantId(tenantId);
                    account.setAccountId(user.getAccountId());
                    account.setOid(user.getOid());
                    account.setPolicyName(policy.getMetaData().getName());
                    boolean isGenPasswoed = true;
                    if (policy.getMetaData().getPasswordPolicy().isCreateAccountWithSpecificPassword()) {
                        if (user.getPassword() != null) {
                            newPassword = user.getPassword();
                            isGenPasswoed = false;
                            account.setLastPasswordChange(new Date(System.currentTimeMillis()));
                        } else {
                            newPassword = policy.makePassword();
                            isGenPasswoed = true;
                        }
                    } else {
                        newPassword = policy.makePassword();
                        isGenPasswoed = true;
                    }
                    String salt = BuiltinAuthenticationProvider.makeSalt();
                    if (BuiltinAuthenticationProvider.this.passwordHashSettings == null) {
                        account.setPassword(BuiltinAuthenticationProvider.this.convertPassword(newPassword, salt, null));
                        account.setSalt(salt);
                    } else {
                        PasswordHashSetting newest = (PasswordHashSetting)BuiltinAuthenticationProvider.this.passwordHashSettings.get(BuiltinAuthenticationProvider.this.passwordHashSettings.size() - 1);
                        account.setPassword(BuiltinAuthenticationProvider.this.convertPassword(newPassword, salt, newest));
                        account.setSalt("$" + newest.getVersion() + "$" + salt);
                    }
                    user.setPassword(null);
                    BuiltinAuthenticationProvider.this.accountDao.registAccount(account, registId);
                    policy.notify(new PasswordNotification(NotificationType.CREATED, user.getOid(), newPassword, isGenPasswoed));
                } else {
                    throw new UserExistsException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.builtin.BuiltinAuthenticationProvider.userRemainTrash", new Object[0]));
                }
            }
        }

        @Override
        public void update(User user, List<String> updateProperties) {
            AuthContext authContext = AuthContext.getCurrentContext();
            Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
            String updateId = ExecuteContext.getCurrentContext().getClientId();
            MetaAuthenticationPolicy.AuthenticationPolicyRuntime policy = null;
            boolean updateAdminFlag = updateProperties.contains("admin");
            if (!authContext.isPrivileged()) {
                if (updateAdminFlag && !authContext.getUser().isAdmin()) {
                    throw new NoPermissionException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.builtin.BuiltinAuthenticationProvider.canNotSetSecuredProperty", new Object[0]));
                }
                if (updateProperties.contains("accountPolicy") && !BuiltinAuthenticationProvider.this.isUserAdminRole(tenant, authContext)) {
                    throw new NoPermissionException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.builtin.BuiltinAuthenticationProvider.canNotSetSecuredProperty", new Object[0]));
                }
            }
            if (this.canUpdate()) {
                int tenantId = BuiltinAuthenticationProvider.this.getTenantId();
                BuiltinAccount account = BuiltinAuthenticationProvider.this.accountDao.getAccountFromOid(tenantId, user.getOid());
                if (account == null) {
                    throw new SystemException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.builtin.BuiltinAuthenticationProvider.incorrectUser", new Object[0]));
                }
                if (updateAdminFlag && !user.isAdmin()) {
                    User beforeUser = this.getUserEntityFromOid(user.getOid());
                    if (beforeUser != null) {
                        if (beforeUser.isAdmin() && this.getAdministratorCount() == 1L) {
                            throw new ApplicationException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.builtin.BuiltinAuthenticationProvider.adminLast", new Object[]{user.getName()}));
                        }
                    } else {
                        throw new SystemException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.builtin.BuiltinAuthenticationProvider.notExist", new Object[0]));
                    }
                }
                boolean updateFlg = false;
                if (updateProperties.contains("accountId")) {
                    User userEntity = this.getUserEntity(user.getAccountId(), false);
                    if (userEntity != null && !userEntity.getOid().equals(user.getOid())) {
                        throw new UserExistsException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.builtin.BuiltinAuthenticationProvider.alreadyRegistered", new Object[0]));
                    }
                    BuiltinAuthenticationProvider.this.accountDao.updatePasswordHistoryAccountId(tenantId, account.getAccountId(), user.getAccountId());
                    account.setAccountId(user.getAccountId());
                    updateFlg = true;
                }
                if (updateProperties.contains("accountPolicy")) {
                    policy = BuiltinAuthenticationProvider.this.getPolicy(user.getAccountPolicy());
                    account.setPolicyName(policy.getMetaData().getName());
                    updateFlg = true;
                }
                if (updateFlg) {
                    BuiltinAuthenticationProvider.this.accountDao.updateAccount(account, updateId);
                }
                if (policy == null) {
                    policy = BuiltinAuthenticationProvider.this.getPolicy(account.getPolicyName());
                }
                policy.notify(new PropertyNotification(NotificationType.PROPERTY_UPDATED, account.getOid(), new ArrayList<String>(updateProperties)));
            }
        }

        @Override
        public void remove(User user) {
            if (this.canRemove()) {
                AuthContext authContext = AuthContext.getCurrentContext();
                User loginUser = authContext.getUser();
                if (loginUser.getValue("accountId").equals(user.getValue("accountId"))) {
                    throw new ApplicationException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.builtin.BuiltinAuthenticationProvider.deleteOwnData", new Object[0]));
                }
                if (user.isAdmin() && !authContext.getUser().isAdmin() && !authContext.isPrivileged()) {
                    throw new NoPermissionException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.builtin.BuiltinAuthenticationProvider.canNotDeleteAdmin", new Object[0]));
                }
                if (user.isAdmin() && this.getAdministratorCount() == 1L) {
                    throw new ApplicationException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.builtin.BuiltinAuthenticationProvider.canNotdeleted", new Object[]{user.getName()}));
                }
                int tenantId = BuiltinAuthenticationProvider.this.getTenantId();
                BuiltinAccount ac = BuiltinAuthenticationProvider.this.accountDao.getAccountFromOid(tenantId, user.getOid());
                if (ac != null) {
                    MetaAuthenticationPolicy.AuthenticationPolicyRuntime policy = BuiltinAuthenticationProvider.this.getPolicy(ac.getPolicyName());
                    policy.notify(new AccountNotification(NotificationType.REMOVE, user.getOid()));
                }
            }
        }

        @Override
        public void restore(User user) {
        }

        @Override
        public void purge(User user) {
            if (this.canPurge()) {
                int tenantId = BuiltinAuthenticationProvider.this.getTenantId();
                BuiltinAccount ac = BuiltinAuthenticationProvider.this.accountDao.getAccountFromOid(tenantId, user.getOid());
                if (ac != null) {
                    BuiltinAuthenticationProvider.this.accountDao.removeAccount(tenantId, ac.getAccountId());
                    BuiltinAuthenticationProvider.this.accountDao.deletePasswordHistory(tenantId, ac.getAccountId());
                }
            }
        }

        @Override
        public void updateCredential(Credential oldCredential, Credential newCredential) {
            if (this.canUpdateCredential()) {
                IdPasswordCredential oldIdPass = (IdPasswordCredential)oldCredential;
                IdPasswordCredential newIdPass = (IdPasswordCredential)newCredential;
                if (oldIdPass.getPassword().equals(newIdPass.getPassword())) {
                    throw new CredentialUpdateException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.updateCredential.sameErr", new Object[0]));
                }
                int tenantId = BuiltinAuthenticationProvider.this.getTenantId();
                BuiltinAccount account = BuiltinAuthenticationProvider.this.accountDao.getAccount(tenantId, oldCredential.getId());
                if (account == null) {
                    throw new CredentialUpdateException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.updateCredential.noAccountErr", new Object[0]));
                }
                MetaAuthenticationPolicy.AuthenticationPolicyRuntime policy = BuiltinAuthenticationProvider.this.getPolicy(account.getPolicyName());
                try {
                    String[] verAndSalt = BuiltinAuthenticationProvider.this.divVerAndSalt(account.getSalt());
                    if (!account.getPassword().equals(BuiltinAuthenticationProvider.this.convertPassword(oldIdPass.getPassword(), verAndSalt[1], BuiltinAuthenticationProvider.this.selectSetting(verAndSalt[0])))) {
                        throw new CredentialUpdateException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.updateCredential.unmatchPasswordErr", new Object[0]));
                    }
                }
                catch (CredentialUpdateException e) {
                    if (account != null) {
                        BuiltinAuthenticationProvider.this.loginFail(account, policy);
                    }
                    throw e;
                }
                policy.checkPasswordUpdatePolicy(newIdPass, account);
                List<Password> passList = null;
                int passwordHistoryCount = policy.getMetaData().getPasswordPolicy().getPasswordHistoryCount();
                if (passwordHistoryCount > 0 && (passList = BuiltinAuthenticationProvider.this.accountDao.getPasswordHistory(account.getTenantId(), account.getAccountId())) != null) {
                    for (int i = 0; i < passList.size() && i < passwordHistoryCount; ++i) {
                        Password pwd = passList.get(i);
                        String[] verAndSalt = BuiltinAuthenticationProvider.this.divVerAndSalt(pwd.getSalt());
                        if (!pwd.getConvertedPassword().equals(BuiltinAuthenticationProvider.this.convertPassword(newIdPass.getPassword(), verAndSalt[1], BuiltinAuthenticationProvider.this.selectSetting(verAndSalt[0])))) continue;
                        throw new CredentialUpdateException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.updateCredential.passHistoryExists", new Object[0]));
                    }
                }
                String newSalt = BuiltinAuthenticationProvider.makeSalt();
                Timestamp currentTime = new Timestamp(System.currentTimeMillis());
                Password pass = null;
                if (BuiltinAuthenticationProvider.this.passwordHashSettings == null) {
                    pass = new Password(tenantId, oldCredential.getId(), BuiltinAuthenticationProvider.this.convertPassword(newIdPass.getPassword(), newSalt, null), newSalt, currentTime);
                } else {
                    PasswordHashSetting newest = (PasswordHashSetting)BuiltinAuthenticationProvider.this.passwordHashSettings.get(BuiltinAuthenticationProvider.this.passwordHashSettings.size() - 1);
                    pass = new Password(tenantId, oldCredential.getId(), BuiltinAuthenticationProvider.this.convertPassword(newIdPass.getPassword(), newSalt, newest), "$" + newest.getVersion() + "$" + newSalt, currentTime);
                }
                BuiltinAuthenticationProvider.this.accountDao.updatePassword(pass, ExecuteContext.getCurrentContext().getClientId());
                if (policy.getMetaData().getPasswordPolicy().getPasswordHistoryCount() > 0) {
                    BuiltinAuthenticationProvider.this.accountDao.addPasswordHistory(new Password(tenantId, account.getAccountId(), account.getPassword(), account.getSalt(), currentTime));
                }
                if (passList != null && passList.size() >= passwordHistoryCount) {
                    Password pwd = passList.get(passwordHistoryCount - 1);
                    BuiltinAuthenticationProvider.this.accountDao.deletePasswordHistory(pwd.getTenantId(), pwd.getUid(), pwd.getUpdateDate());
                }
                policy.notify(new PasswordNotification(NotificationType.CREDENTIAL_UPDATED, account.getOid(), newIdPass.getPassword(), false));
            }
        }

        @Override
        public boolean canCreate() {
            return BuiltinAuthenticationProvider.this.isUpdatable();
        }

        @Override
        public boolean canUpdate() {
            return BuiltinAuthenticationProvider.this.isUpdatable();
        }

        @Override
        public boolean canRemove() {
            return BuiltinAuthenticationProvider.this.isUpdatable();
        }

        @Override
        public boolean canRestore() {
            return BuiltinAuthenticationProvider.this.isUpdatable();
        }

        @Override
        public boolean canPurge() {
            return BuiltinAuthenticationProvider.this.isUpdatable();
        }

        @Override
        public boolean canUpdateCredential() {
            return BuiltinAuthenticationProvider.this.isUpdatable();
        }

        @Override
        public boolean canResetCredential() {
            return BuiltinAuthenticationProvider.this.isUpdatable();
        }

        @Override
        public void resetCredential(Credential credential) throws CredentialUpdateException {
            if (this.canResetCredential()) {
                String newPassword;
                int tenantId = BuiltinAuthenticationProvider.this.getTenantId();
                BuiltinAccount account = BuiltinAuthenticationProvider.this.accountDao.getAccount(tenantId, credential.getId());
                if (account == null) {
                    throw new CredentialUpdateException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.updateCredential.noAccountErr", new Object[0]));
                }
                MetaAuthenticationPolicy.AuthenticationPolicyRuntime policy = BuiltinAuthenticationProvider.this.getPolicy(account.getPolicyName());
                boolean isGenPassword = true;
                if (policy.getMetaData().getPasswordPolicy().isResetPasswordWithSpecificPassword() && ((IdPasswordCredential)credential).getPassword() != null) {
                    AuthContext authContext = AuthContext.getCurrentContext();
                    Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
                    if (!BuiltinAuthenticationProvider.this.isUserAdminRole(tenant, authContext) && !authContext.isPrivileged()) {
                        throw new NoPermissionException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.builtin.BuiltinAuthenticationProvider.canNotSetSecuredProperty", new Object[0]));
                    }
                    newPassword = ((IdPasswordCredential)credential).getPassword();
                    isGenPassword = false;
                    policy.checkPasswordPattern(newPassword);
                    List<Password> passList = null;
                    int passwordHistoryCount = policy.getMetaData().getPasswordPolicy().getPasswordHistoryCount();
                    if (passwordHistoryCount > 0 && (passList = BuiltinAuthenticationProvider.this.accountDao.getPasswordHistory(account.getTenantId(), account.getAccountId())) != null) {
                        for (int i = 0; i < passList.size() && i < passwordHistoryCount; ++i) {
                            Password pwd = passList.get(i);
                            String[] verAndSalt = BuiltinAuthenticationProvider.this.divVerAndSalt(pwd.getSalt());
                            if (!pwd.getConvertedPassword().equals(BuiltinAuthenticationProvider.this.convertPassword(newPassword, verAndSalt[1], BuiltinAuthenticationProvider.this.selectSetting(verAndSalt[0])))) continue;
                            throw new CredentialUpdateException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.updateCredential.passHistoryExists", new Object[0]));
                        }
                    }
                } else {
                    if (((IdPasswordCredential)credential).getPassword() != null) {
                        logger.warn("resetCredential() was called with specific password, but authPolicy not allow specific password...");
                    }
                    newPassword = policy.makePassword();
                }
                String newSalt = BuiltinAuthenticationProvider.makeSalt();
                Password pass = null;
                Timestamp updateTime = null;
                if (!isGenPassword) {
                    updateTime = new Timestamp(System.currentTimeMillis());
                }
                if (BuiltinAuthenticationProvider.this.passwordHashSettings == null) {
                    pass = new Password(tenantId, credential.getId(), BuiltinAuthenticationProvider.this.convertPassword(newPassword, newSalt, null), newSalt, updateTime);
                } else {
                    PasswordHashSetting newest = (PasswordHashSetting)BuiltinAuthenticationProvider.this.passwordHashSettings.get(BuiltinAuthenticationProvider.this.passwordHashSettings.size() - 1);
                    pass = new Password(tenantId, credential.getId(), BuiltinAuthenticationProvider.this.convertPassword(newPassword, newSalt, newest), "$" + newest.getVersion() + "$" + newSalt, updateTime);
                }
                BuiltinAuthenticationProvider.this.accountDao.updatePassword(pass, ExecuteContext.getCurrentContext().getClientId());
                policy.notify(new PasswordNotification(NotificationType.CREDENTIAL_RESET, account.getOid(), newPassword, isGenPassword));
            }
        }

        private long getAdministratorCount() {
            return AuthContext.doPrivileged(() -> {
                Query q = new Query().select(new Count()).from("mtp.auth.User").where(new Equals("admin", true));
                final Long[] adminCnt = new Long[1];
                EntityManager em = ManagerLocator.getInstance().getManager(EntityManager.class);
                em.search(q, new Predicate<Object[]>(){

                    @Override
                    public boolean test(Object[] data) {
                        adminCnt[0] = (Long)data[0];
                        return false;
                    }
                });
                return adminCnt[0];
            });
        }

        private User getUserEntity(String accountId, boolean withAllProp) {
            return AuthContext.doPrivileged(() -> {
                if (withAllProp) {
                    Query query = new Query().selectAll("mtp.auth.User", true, false).where(new Equals("accountId", accountId));
                    SearchResult user = ManagerLocator.getInstance().getManager(EntityManager.class).searchEntity(query);
                    if (user.getList().size() > 0) {
                        return (User)user.getList().get(0);
                    }
                } else {
                    Query query = new Query().select("oid", "accountId").from("mtp.auth.User").where(new Equals("accountId", accountId));
                    SearchResult user = ManagerLocator.getInstance().getManager(EntityManager.class).searchEntity(query);
                    if (user.getList().size() > 0) {
                        return (User)user.getList().get(0);
                    }
                }
                return null;
            });
        }

        private User getUserEntityFromOid(String oid) {
            return AuthContext.doPrivileged(() -> {
                Query query = new Query().selectAll("mtp.auth.User", true, false).where(new Equals("oid", oid));
                SearchResult user = ManagerLocator.getInstance().getManager(EntityManager.class).searchEntity(query);
                if (user.getList().size() > 0) {
                    return (User)user.getList().get(0);
                }
                return null;
            });
        }

        @Override
        public boolean canResetLockoutStatus() {
            return BuiltinAuthenticationProvider.this.isUpdatable();
        }

        @Override
        public void resetLockoutStatus(String accountId) {
            if (this.canResetLockoutStatus()) {
                AuthContext authContext = AuthContext.getCurrentContext();
                Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
                if (!BuiltinAuthenticationProvider.this.isUserAdminRole(tenant, authContext) && !authContext.isPrivileged()) {
                    throw new NoPermissionException(BuiltinAuthenticationProvider.resourceString("impl.auth.authenticate.builtin.BuiltinAuthenticationProvider.canNotSetSecuredProperty", new Object[0]));
                }
                int tenantId = BuiltinAuthenticationProvider.this.getTenantId();
                BuiltinAccount account = BuiltinAuthenticationProvider.this.accountDao.getAccount(tenantId, accountId);
                if (account == null) {
                    logger.warn("resetLockoutStatus() was called with accountId:" + accountId + ", but not exists.");
                    return;
                }
                if (account.getLoginErrorCnt() > 0) {
                    BuiltinAuthenticationProvider.this.accountDao.resetLoginErrorCnt(account);
                }
            }
        }
    }

    private static class RandomHolder {
        static final SecureRandomGenerator random = ServiceRegistry.getRegistry().getService(SecureRandomService.class).createGenerator("saltGenerator");

        private RandomHolder() {
        }
    }
}

