/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.builtin;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.auth.login.CredentialUpdateException;
import org.iplass.mtp.impl.auth.authenticate.builtin.AccountStore;
import org.iplass.mtp.impl.auth.authenticate.builtin.BuiltinAccount;
import org.iplass.mtp.impl.auth.authenticate.builtin.BuiltinAuthenticationProvider;
import org.iplass.mtp.impl.auth.authenticate.builtin.Password;
import org.iplass.mtp.impl.auth.authenticate.builtin.sql.AccountControlSQL;
import org.iplass.mtp.impl.auth.authenticate.builtin.sql.AccountSelectSQL;
import org.iplass.mtp.impl.auth.authenticate.builtin.sql.PasswordHistorySelectSQL;
import org.iplass.mtp.impl.auth.authenticate.builtin.sql.PasswordHistoryUpdateSQL;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.spi.Config;

public class RdbAccountStore
implements AccountStore {
    private AccountSelectSQL accountSelect;
    private AccountControlSQL accountControl;
    private PasswordHistorySelectSQL passSelect;
    private PasswordHistoryUpdateSQL passUpdate;
    private RdbAdapter rdb;

    @Override
    public void inited(BuiltinAuthenticationProvider provider, Config config) {
        this.rdb = config.getDependentService(RdbAdapterService.class).getRdbAdapter();
        this.accountSelect = this.rdb.getQuerySqlCreator(AccountSelectSQL.class);
        this.accountControl = this.rdb.getUpdateSqlCreator(AccountControlSQL.class);
        this.passSelect = this.rdb.getQuerySqlCreator(PasswordHistorySelectSQL.class);
        this.passUpdate = this.rdb.getUpdateSqlCreator(PasswordHistoryUpdateSQL.class);
    }

    @Override
    public void updateAccountLoginStatus(final BuiltinAccount account) {
        SqlExecuter<Void> executer = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAccountStore.this.accountControl.createLoginStatUpdateSQL());
                RdbAccountStore.this.accountControl.setLoginStatUpdateParameter(RdbAccountStore.this.rdb, ps, account);
                int cnt = ps.executeUpdate();
                if (cnt != 1) {
                    throw new RuntimeException("fail to update login status:" + account.getAccountId());
                }
                return null;
            }
        };
        executer.execute(this.rdb, true);
    }

    @Override
    public void updatePassword(final Password pass, final String updateUser) {
        SqlExecuter<Void> executer = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAccountStore.this.accountControl.createUpdatePasswordSQL(RdbAccountStore.this.rdb));
                Date date = null;
                if (pass.getUpdateDate() != null) {
                    date = new Date(pass.getUpdateDate().getTime());
                }
                RdbAccountStore.this.accountControl.setUpdatePasswordParameter(RdbAccountStore.this.rdb, ps, pass.getTenantId(), pass.getUid(), pass.getConvertedPassword(), pass.getSalt(), date, updateUser);
                int cnt = ps.executeUpdate();
                if (cnt != 1) {
                    throw new CredentialUpdateException(RdbAccountStore.resourceString("impl.auth.authenticate.updateCredential.updateErr", new Object[0]));
                }
                return null;
            }
        };
        executer.execute(this.rdb, true);
    }

    @Override
    public void registAccount(final BuiltinAccount account, final String registId) {
        SqlExecuter<Void> executer = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAccountStore.this.accountControl.createRegistSQL(RdbAccountStore.this.rdb));
                RdbAccountStore.this.accountControl.setRegistParameter(RdbAccountStore.this.rdb, ps, account, registId);
                ps.executeUpdate();
                return null;
            }
        };
        executer.execute(this.rdb, true);
    }

    @Override
    public void updateAccount(final BuiltinAccount account, final String updateUser) {
        SqlExecuter<Void> executer = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAccountStore.this.accountControl.createUpdateSQL(RdbAccountStore.this.rdb));
                RdbAccountStore.this.accountControl.setUpdateParameter(RdbAccountStore.this.rdb, ps, account, updateUser);
                int cnt = ps.executeUpdate();
                if (cnt == 0) {
                    throw new RuntimeException("Update Fail. Maybe concurrent modification occured:accountId=" + account.getAccountId());
                }
                return null;
            }
        };
        executer.execute(this.rdb, true);
    }

    @Override
    public void removeAccount(final int tenantId, final String accountId) {
        SqlExecuter<Void> executer = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAccountStore.this.accountControl.createDeleteSQL(RdbAccountStore.this.rdb));
                RdbAccountStore.this.accountControl.setDeleteParameter(RdbAccountStore.this.rdb, ps, tenantId, accountId);
                int cnt = ps.executeUpdate();
                if (cnt == 0) {
                    throw new RuntimeException("Delete Fail. Maybe concurrent modification occured:accountId=" + accountId);
                }
                return null;
            }
        };
        executer.execute(this.rdb, true);
    }

    @Override
    public BuiltinAccount getAccount(final int tenantId, final String accountId) {
        SqlExecuter<BuiltinAccount> executer = new SqlExecuter<BuiltinAccount>(){

            @Override
            public BuiltinAccount logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAccountStore.this.accountSelect.createAccountSQL());
                RdbAccountStore.this.accountSelect.setAccountParameter(RdbAccountStore.this.rdb, ps, tenantId, accountId);
                try (ResultSet rs = ps.executeQuery();){
                    BuiltinAccount builtinAccount = RdbAccountStore.this.accountSelect.getAccount(rs);
                    return builtinAccount;
                }
            }
        };
        return (BuiltinAccount)executer.execute(this.rdb, true);
    }

    @Override
    public BuiltinAccount getAccountFromOid(final int tenantId, final String oid) {
        SqlExecuter<BuiltinAccount> executer = new SqlExecuter<BuiltinAccount>(){

            @Override
            public BuiltinAccount logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAccountStore.this.accountSelect.createAccountFromOidSQL());
                RdbAccountStore.this.accountSelect.setAccountFromOidParameter(RdbAccountStore.this.rdb, ps, tenantId, oid);
                try (ResultSet rs = ps.executeQuery();){
                    BuiltinAccount builtinAccount = RdbAccountStore.this.accountSelect.getAccount(rs);
                    return builtinAccount;
                }
            }
        };
        return (BuiltinAccount)executer.execute(this.rdb, true);
    }

    @Override
    public void addPasswordHistory(final Password hi) {
        SqlExecuter<Void> executer = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAccountStore.this.passUpdate.createInsertSQL(RdbAccountStore.this.rdb));
                RdbAccountStore.this.passUpdate.setInsertParameter(RdbAccountStore.this.rdb, ps, hi);
                ps.executeUpdate();
                return null;
            }
        };
        executer.execute(this.rdb, true);
    }

    @Override
    public List<Password> getPasswordHistory(final int tenantId, final String accountId) {
        SqlExecuter<List<Password>> executer = new SqlExecuter<List<Password>>(){

            @Override
            public List<Password> logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAccountStore.this.passSelect.createSelectSQL());
                RdbAccountStore.this.passSelect.setSelectParameter(RdbAccountStore.this.rdb, ps, tenantId, accountId);
                ArrayList<Password> res = new ArrayList<Password>();
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        res.add(RdbAccountStore.this.passSelect.toPassword(rs));
                    }
                }
                return res;
            }
        };
        return (List)executer.execute(this.rdb, true);
    }

    @Override
    public void deletePasswordHistory(final int tenantId, final String accountId) {
        SqlExecuter<Void> executer = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAccountStore.this.passUpdate.createDeleteSQL(RdbAccountStore.this.rdb));
                RdbAccountStore.this.passUpdate.setDeleteParameter(RdbAccountStore.this.rdb, ps, tenantId, accountId);
                ps.executeUpdate();
                return null;
            }
        };
        executer.execute(this.rdb, true);
    }

    @Override
    public void deletePasswordHistory(final int tenantId, final String accountId, final Timestamp dateBefore) {
        SqlExecuter<Void> executer = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAccountStore.this.passUpdate.createDeleteByDateSQL(RdbAccountStore.this.rdb));
                RdbAccountStore.this.passUpdate.setDeleteByDateParameter(RdbAccountStore.this.rdb, ps, tenantId, accountId, dateBefore);
                ps.executeUpdate();
                return null;
            }
        };
        executer.execute(this.rdb, true);
    }

    @Override
    public void updatePasswordHistoryAccountId(final int tenantId, final String oldAccountId, final String newAccountId) {
        SqlExecuter<Void> executer = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAccountStore.this.passUpdate.createUpdateAccountIdSQL(RdbAccountStore.this.rdb));
                RdbAccountStore.this.passUpdate.setUpdateAccountIdSQL(RdbAccountStore.this.rdb, ps, tenantId, oldAccountId, newAccountId);
                ps.executeUpdate();
                return null;
            }
        };
        executer.execute(this.rdb, true);
    }

    @Override
    public void resetLoginErrorCnt(final BuiltinAccount account) {
        SqlExecuter<BuiltinAccount> executer = new SqlExecuter<BuiltinAccount>(){

            @Override
            public BuiltinAccount logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAccountStore.this.accountControl.createResetLoginErrorCntSQL(RdbAccountStore.this.rdb));
                RdbAccountStore.this.accountControl.setResetLoginErrorCntParameter(RdbAccountStore.this.rdb, ps, account);
                int cnt = ps.executeUpdate();
                if (cnt == 0) {
                    throw new RuntimeException("Update Fail. Maybe concurrent modification occured:accountId=" + account.getAccountId());
                }
                return null;
            }
        };
        executer.execute(this.rdb, true);
    }

    private static String resourceString(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }
}

