/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.configfile;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.configfile.AccountConfig;
import org.iplass.mtp.impl.util.ObjectUtil;

public class ConfigFileAccountHandle
implements AccountHandle {
    private static final long serialVersionUID = 4360033341629716946L;
    private String accountId;
    private int authenticationProviderIndex;
    private Map<String, Object> attributeMap;

    ConfigFileAccountHandle(AccountConfig accountConfig) {
        this.accountId = accountConfig.getId();
        this.attributeMap = new HashMap<String, Object>();
        if (accountConfig.getAttributeMap() != null) {
            for (Map.Entry<String, Object> e : accountConfig.getAttributeMap().entrySet()) {
                Serializable val = ObjectUtil.deepCopy((Serializable)e.getValue());
                this.attributeMap.put(e.getKey(), val);
            }
        }
        if (accountConfig.isAdmin()) {
            this.attributeMap.put("admin", true);
        }
    }

    @Override
    public boolean isAccountLocked() {
        return false;
    }

    @Override
    public boolean isExpired() {
        return false;
    }

    @Override
    public boolean isInitialLogin() {
        return false;
    }

    @Override
    public Credential getCredential() {
        return new IdPasswordCredential(this.accountId, null);
    }

    @Override
    public String getUnmodifiableUniqueKey() {
        return this.accountId;
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        return this.attributeMap;
    }

    @Override
    public void setAuthenticationProviderIndex(int authenticationProviderIndex) {
        this.authenticationProviderIndex = authenticationProviderIndex;
    }

    @Override
    public int getAuthenticationProviderIndex() {
        return this.authenticationProviderIndex;
    }
}

