/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.internal;

import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.AccountManagementModule;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProvider;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProviderBase;
import org.iplass.mtp.impl.auth.authenticate.DefaultUserEntityResolver;
import org.iplass.mtp.impl.auth.authenticate.UserEntityResolver;
import org.iplass.mtp.impl.auth.authenticate.internal.InternalCreatedAccountHandle;
import org.iplass.mtp.impl.auth.authenticate.internal.InternalCredential;
import org.iplass.mtp.impl.auth.authenticate.trust.DefaultTrustedAuthValidator;
import org.iplass.mtp.impl.auth.authenticate.trust.TrustedAuthValidator;
import org.iplass.mtp.impl.auth.log.AuthLogger;
import org.iplass.mtp.impl.auth.log.AuthLoggerService;
import org.iplass.mtp.spi.Config;

public class InternalAuthenticationProvider
implements AuthenticationProvider {
    public static final String PROVIDER_NAME = "_internal";
    private AuthLogger authLogger;
    private String authLoggerName;
    private UserEntityResolver userEntityResolver;
    private TrustedAuthValidator trustedAuthValidator;

    @Override
    public UserEntityResolver getUserEntityResolver() {
        return this.userEntityResolver;
    }

    public String getAuthLoggerName() {
        return this.authLoggerName;
    }

    public void setAuthLoggerName(String authLoggerName) {
        this.authLoggerName = authLoggerName;
    }

    @Override
    public String getProviderName() {
        return PROVIDER_NAME;
    }

    @Override
    public AuthLogger getAuthLogger() {
        return this.authLogger;
    }

    @Override
    public void inited(AuthService service, Config config) {
        this.authLogger = config.getDependentService(AuthLoggerService.class).getAuthLogger(this.authLoggerName);
        DefaultUserEntityResolver er = new DefaultUserEntityResolver();
        er.setEagerLoadReferenceProperty(DefaultUserEntityResolver.DEFAULT_EAGER_LOAD_REFERENCE_PROPERTY);
        er.setUnmodifiableUniqueKeyProperty("accountId");
        er.inited(service, this);
        this.userEntityResolver = er;
        this.userEntityResolver.inited(service, this);
        this.trustedAuthValidator = new DefaultTrustedAuthValidator(InternalCreatedAccountHandle.class.getName(), InternalCredential.class.getName());
        this.trustedAuthValidator.inited(service, this);
    }

    @Override
    public void destroyed() {
    }

    @Override
    public AccountHandle login(Credential credential) {
        if (credential instanceof InternalCredential) {
            return new InternalCreatedAccountHandle(credential.getId());
        }
        return null;
    }

    @Override
    public void logout(AccountHandle user) {
    }

    @Override
    public AccountManagementModule getAccountManagementModule() {
        return AuthenticationProviderBase.NO_UPDATABLE_AMM;
    }

    @Override
    public TrustedAuthValidator getTrustedAuthValidator() {
        return this.trustedAuthValidator;
    }

    @Override
    public void cleanupData() {
    }

    @Override
    public Class<? extends Credential> getCredentialType() {
        return InternalCredential.class;
    }

    @Override
    public boolean isSelectableOnAuthPolicy() {
        return false;
    }
}

