/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin;

import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.impl.auth.authorize.AuthorizationContext;
import org.iplass.mtp.impl.auth.authorize.builtin.AuthorizationContextCacheLogic;
import org.iplass.mtp.impl.auth.authorize.builtin.BuiltinAuthorizationContext;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.cache.CacheController;
import org.iplass.mtp.impl.cache.CacheService;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.spi.ServiceRegistry;

public abstract class AuthorizationContextHandler {
    public abstract Class<? extends Permission>[] permissionType();

    protected abstract String cacheNamespace();

    protected abstract AuthorizationContextCacheLogic newAuthorizeContextCacheLogic(TenantAuthorizeContext var1);

    protected abstract AuthorizationContext defaultAuthorizationContext(String var1, TenantAuthorizeContext var2);

    protected abstract String toMetaDataPath(String var1);

    protected abstract String contextName(Permission var1);

    public CacheController<String, BuiltinAuthorizationContext> initCache(TenantAuthorizeContext tac) {
        CacheService cs = ServiceRegistry.getRegistry().getService(CacheService.class);
        return new CacheController<String, BuiltinAuthorizationContext>(cs.getCache(this.cacheNamespace() + "/" + tac.getTenantContext().getTenantId()), false, 0, this.newAuthorizeContextCacheLogic(tac), true, true);
    }

    public boolean useSharedPermission(Permission permission) {
        String metaDataPath = this.toMetaDataPath(this.contextName(permission));
        MetaDataEntry ent = MetaDataContext.getContext().getMetaDataEntry(metaDataPath);
        if (ent == null) {
            return false;
        }
        if (!ent.isSharable()) {
            return false;
        }
        return ent.getRepositryType() == MetaDataEntry.RepositoryType.SHARED && ent.isPermissionSharable();
    }

    public BuiltinAuthorizationContext get(String contextName, TenantAuthorizeContext tac) {
        if (ExecuteContext.getCurrentContext().getClientTenantId() != tac.getTenantContext().getTenantId()) {
            return ExecuteContext.executeAs(tac.getTenantContext(), () -> tac.getContextCache(this.getClass()).get(contextName));
        }
        return tac.getContextCache(this.getClass()).get(contextName);
    }

    public AuthorizationContext getOrDefault(String contextName, TenantAuthorizeContext tac) {
        AuthorizationContext ret = this.get(contextName, tac);
        if (ret == null) {
            ret = this.defaultAuthorizationContext(contextName, tac);
        }
        return ret;
    }

    public void notifyUpdate(String contextName, TenantAuthorizeContext tac) {
        CacheController<String, BuiltinAuthorizationContext> cache = tac.getContextCache(this.getClass());
        if (ExecuteContext.getCurrentContext().getClientTenantId() != tac.getTenantContext().getTenantId()) {
            ExecuteContext.executeAs(tac.getTenantContext(), () -> {
                BuiltinAuthorizationContext context = (BuiltinAuthorizationContext)this.newAuthorizeContextCacheLogic(tac).load(contextName);
                if (context == null) {
                    cache.notifyDeleteByKey(contextName);
                } else {
                    cache.notifyUpdate(context);
                }
                return null;
            });
        } else {
            BuiltinAuthorizationContext context = (BuiltinAuthorizationContext)this.newAuthorizeContextCacheLogic(tac).load(contextName);
            if (context == null) {
                cache.notifyDeleteByKey(contextName);
            } else {
                cache.notifyUpdate(context);
            }
        }
    }
}

