/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin;

import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityEventContext;
import org.iplass.mtp.entity.EntityEventListener;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authorize.AuthorizationProvider;
import org.iplass.mtp.impl.auth.authorize.builtin.AuthorizationContextHandler;
import org.iplass.mtp.impl.auth.authorize.builtin.BuiltinAuthorizationContext;
import org.iplass.mtp.impl.auth.authorize.builtin.BuiltinAuthorizationProvider;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.spi.ServiceRegistry;

public abstract class PermissionEntityEventListener
implements EntityEventListener {
    private static final String KEY_UPDATE = "authContextForUpdate";
    private static final String KEY_DEL = "authContextForDel";
    protected AuthorizationContextHandler handler;

    public PermissionEntityEventListener(Class<? extends Permission> typeForHandler) {
        AuthorizationProvider ap = ServiceRegistry.getRegistry().getService(AuthService.class).getAuthorizationProvider();
        if (ap instanceof BuiltinAuthorizationProvider) {
            this.handler = ((BuiltinAuthorizationProvider)ap).getAuthorizationContextHandler(typeForHandler);
        }
    }

    protected abstract String contextName(Entity var1);

    private TenantAuthorizeContext getTenantAuthorizeContext() {
        return ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class);
    }

    @Override
    public boolean beforeDelete(Entity entity, EntityEventContext context) {
        Entity before;
        if (this.handler != null && (before = ManagerLocator.getInstance().getManager(EntityManager.class).load(entity.getOid(), entity.getDefinitionName())) != null) {
            BuiltinAuthorizationContext beforeContext = this.handler.get(this.contextName(before), this.getTenantAuthorizeContext());
            context.setAttribute(KEY_DEL, beforeContext);
        }
        return true;
    }

    @Override
    public void afterDelete(Entity entity, EntityEventContext context) {
        BuiltinAuthorizationContext beforeContext;
        if (this.handler != null && (beforeContext = (BuiltinAuthorizationContext)context.getAttribute(KEY_DEL)) != null) {
            this.handler.notifyUpdate(beforeContext.getContextName(), this.getTenantAuthorizeContext());
        }
    }

    @Override
    public void afterInsert(Entity entity, EntityEventContext context) {
        if (this.handler != null) {
            this.handler.notifyUpdate(this.contextName(entity), this.getTenantAuthorizeContext());
        }
    }

    @Override
    public boolean beforeUpdate(Entity entity, EntityEventContext context) {
        Entity before;
        if (this.handler != null && (before = ManagerLocator.getInstance().getManager(EntityManager.class).load(entity.getOid(), entity.getDefinitionName())) != null) {
            BuiltinAuthorizationContext beforeContext = this.handler.get(this.contextName(before), this.getTenantAuthorizeContext());
            context.setAttribute(KEY_UPDATE, beforeContext);
        }
        return true;
    }

    @Override
    public void afterUpdate(Entity entity, EntityEventContext context) {
        BuiltinAuthorizationContext beforeContext;
        if (this.handler != null && (beforeContext = (BuiltinAuthorizationContext)context.getAttribute(KEY_UPDATE)) != null) {
            if (!beforeContext.getContextName().equals(this.contextName(entity))) {
                this.handler.notifyUpdate(beforeContext.getContextName(), this.getTenantAuthorizeContext());
            }
            this.handler.notifyUpdate(this.contextName(entity), this.getTenantAuthorizeContext());
        }
    }

    @Override
    public void afterRestore(Entity entity) {
        if (this.handler != null) {
            this.handler.notifyUpdate(this.contextName(entity), this.getTenantAuthorizeContext());
        }
    }
}

