/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin.entity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.impl.auth.authorize.builtin.AuthorizationContextCacheLogic;
import org.iplass.mtp.impl.auth.authorize.builtin.BuiltinAuthorizationContext;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.auth.authorize.builtin.entity.BuiltinEntityAuthContext;
import org.iplass.mtp.impl.auth.authorize.builtin.entity.EntityPermissionEntry;
import org.iplass.mtp.impl.auth.authorize.builtin.entity.EntityPropertyPermissionEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EntityAuthContextCacheLogic
extends AuthorizationContextCacheLogic {
    private static final Logger logger = LoggerFactory.getLogger(EntityAuthContextCacheLogic.class);
    public static final String ENTITY_PERMISSION_DEF_NAME = "mtp.auth.EntityPermission";
    public static final String TARGET_ENTITY = "targetEntity";
    public static final String ROLE = "role";
    public static final String CAN_CREATE = "canCreate";
    public static final String CREATE_COND = "createCondition";
    public static final String CREATE_PROP_CTRL_TYPE = "createPropertyControlType";
    public static final String CREATE_PROP_LIST = "createPropertyList";
    public static final String CAN_REF = "canReference";
    public static final String REF_COND = "referenceCondition";
    public static final String REF_PROP_CTRL_TYPE = "referencePropertyControlType";
    public static final String REF_PROP_LIST = "referencePropertyList";
    public static final String CAN_UPDATE = "canUpdate";
    public static final String UPDATE_COND = "updateCondition";
    public static final String UPDATE_PROP_CTRL_LIST = "updatePropertyControlType";
    public static final String UPDATE_PROP_LIST = "updatePropertyList";
    public static final String CAN_DEL = "canDelete";
    public static final String DEL_COND = "deleteCondition";
    public static final String ENABLE = "E";
    public static final String DISABLE = "D";
    private EntityManager em = ManagerLocator.getInstance().getManager(EntityManager.class);
    private Pattern spliter = Pattern.compile("\\s*,\\s*|\\s+");

    EntityAuthContextCacheLogic(TenantAuthorizeContext authorizeContext) {
        super(authorizeContext);
    }

    @Override
    public BuiltinAuthorizationContext load(String key) {
        return AuthContext.doPrivileged(() -> {
            Query q = new Query().select("oid", "role.code", CAN_CREATE, CREATE_COND, CREATE_PROP_CTRL_TYPE, CREATE_PROP_LIST, CAN_REF, REF_COND, REF_PROP_CTRL_TYPE, REF_PROP_LIST, CAN_UPDATE, UPDATE_COND, UPDATE_PROP_CTRL_LIST, UPDATE_PROP_LIST, CAN_DEL, DEL_COND).from(ENTITY_PERMISSION_DEF_NAME).where(new Equals(TARGET_ENTITY, key));
            boolean[] isFind = new boolean[]{false};
            ArrayList createEntity = new ArrayList();
            ArrayList refEntity = new ArrayList();
            ArrayList updateEntity = new ArrayList();
            ArrayList delEntity = new ArrayList();
            ArrayList createProp = new ArrayList();
            ArrayList refProp = new ArrayList();
            ArrayList updateProp = new ArrayList();
            this.em.search(q, dataModel -> {
                if (dataModel[1] != null) {
                    isFind[0] = true;
                    createEntity.add(new EntityPermissionEntry((String)dataModel[1], (String)dataModel[3], this.checkPermitFlag(dataModel[2])));
                    refEntity.add(new EntityPermissionEntry((String)dataModel[1], (String)dataModel[7], this.checkPermitFlag(dataModel[6])));
                    updateEntity.add(new EntityPermissionEntry((String)dataModel[1], (String)dataModel[11], this.checkPermitFlag(dataModel[10])));
                    delEntity.add(new EntityPermissionEntry((String)dataModel[1], (String)dataModel[15], this.checkPermitFlag(dataModel[14])));
                    if (dataModel[4] != null) {
                        createProp.add(new EntityPropertyPermissionEntry((String)dataModel[1], ((SelectValue)dataModel[4]).getValue().equals(ENABLE), this.toPropNameArray((String)dataModel[5])));
                    } else {
                        createProp.add(new EntityPropertyPermissionEntry((String)dataModel[1], false, (HashSet<String>)null));
                    }
                    if (dataModel[8] != null) {
                        refProp.add(new EntityPropertyPermissionEntry((String)dataModel[1], ((SelectValue)dataModel[8]).getValue().equals(ENABLE), this.toPropNameArray((String)dataModel[9])));
                    } else {
                        refProp.add(new EntityPropertyPermissionEntry((String)dataModel[1], false, (HashSet<String>)null));
                    }
                    if (dataModel[12] != null) {
                        updateProp.add(new EntityPropertyPermissionEntry((String)dataModel[1], ((SelectValue)dataModel[12]).getValue().equals(ENABLE), this.toPropNameArray((String)dataModel[13])));
                    } else {
                        updateProp.add(new EntityPropertyPermissionEntry((String)dataModel[1], false, (HashSet<String>)null));
                    }
                } else {
                    logger.warn("role code not defined. so ignore this entry:oid=" + dataModel[0]);
                }
                return true;
            });
            if (!isFind[0]) {
                return null;
            }
            return new BuiltinEntityAuthContext(key, createEntity.toArray(new EntityPermissionEntry[createEntity.size()]), refEntity.toArray(new EntityPermissionEntry[refEntity.size()]), updateEntity.toArray(new EntityPermissionEntry[updateEntity.size()]), delEntity.toArray(new EntityPermissionEntry[delEntity.size()]), createProp.toArray(new EntityPropertyPermissionEntry[createProp.size()]), refProp.toArray(new EntityPropertyPermissionEntry[refProp.size()]), updateProp.toArray(new EntityPropertyPermissionEntry[updateProp.size()]), this.authorizeContext);
        });
    }

    private boolean checkPermitFlag(Object val) {
        if (val == null) {
            return false;
        }
        return (Boolean)val;
    }

    private String[] toPropNameArray(String propListString) {
        if (propListString == null) {
            return null;
        }
        String[] splited = this.spliter.split(propListString);
        return splited;
    }
}

