/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin.role;

import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.UserBinding;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.command.RequestContextBinding;
import org.iplass.mtp.impl.command.SessionBinding;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleContext {
    private static final Logger logger = LoggerFactory.getLogger(RoleContext.class);
    private static final String SCRIPT_PREFIX = "RoleContext_roleCondition";
    private String roleCode;
    private long rolePriolitiy;
    private Script[] roleCondition;
    private TenantAuthorizeContext tenantAuthContext;

    public RoleContext(String roleCode, long rolePriolitiy, String[] roleConditionExp, TenantAuthorizeContext tenantAuthContext) {
        this.roleCode = roleCode;
        this.tenantAuthContext = tenantAuthContext;
        this.rolePriolitiy = rolePriolitiy;
        if (roleConditionExp != null) {
            this.roleCondition = new Script[roleConditionExp.length];
            ScriptEngine se = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
            for (int i = 0; i < roleConditionExp.length; ++i) {
                try {
                    this.roleCondition[i] = se.createScript(roleConditionExp[i], "RoleContext_roleCondition_" + roleCode + "_" + i);
                    continue;
                }
                catch (RuntimeException e) {
                    logger.error("role condition expression is invalid, so ignore this expression: " + roleConditionExp[i], (Throwable)e);
                }
            }
        }
    }

    public String getRoleCode() {
        return this.roleCode;
    }

    public boolean userInRole(AuthContextHolder userAuthContext) {
        UserBinding user = userAuthContext.newUserBinding(this.tenantAuthContext);
        if (user.isGrantAllPermissions()) {
            return true;
        }
        if (this.roleCondition != null) {
            ScriptEngine se = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
            ScriptContext sc = se.newScriptContext();
            sc.setAttribute("user", user);
            sc.setAttribute("session", SessionBinding.newSessionBinding());
            sc.setAttribute("request", RequestContextBinding.newRequestContextBinding());
            for (Script s : this.roleCondition) {
                Boolean ret;
                if (s == null) continue;
                try {
                    ret = (Boolean)s.eval(sc);
                }
                catch (RuntimeException e) {
                    logger.error("can not eval condition expression. so return false:role=" + this.roleCode + ":" + e.getMessage(), (Throwable)e);
                    return false;
                }
                if (ret == null || !ret.booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public long getPriority() {
        return this.rolePriolitiy;
    }
}

