/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.log;

import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.CredentialUpdateException;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.auth.log.AuthLoggerBase;
import org.iplass.mtp.impl.auth.log.AuthLoggerService;
import org.iplass.mtp.spi.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jAuthLogger
extends AuthLoggerBase {
    public static final String DEFAULT_LOGGER_NAME = "mtp.auth";
    protected Logger auditLog;
    private String slf4LoggerName;

    public String getSlf4LoggerName() {
        return this.slf4LoggerName;
    }

    public void setSlf4LoggerName(String slf4LoggerName) {
        this.slf4LoggerName = slf4LoggerName;
    }

    @Override
    public void inited(AuthLoggerService service, Config config) {
        if (this.slf4LoggerName == null) {
            this.slf4LoggerName = DEFAULT_LOGGER_NAME;
        }
        this.auditLog = LoggerFactory.getLogger((String)this.slf4LoggerName);
    }

    @Override
    public void destroyed() {
    }

    @Override
    public void loginFail(Credential credential, Exception e) {
        if (this.auditLog.isWarnEnabled()) {
            if (e == null) {
                this.auditLog.warn(credential.getId() + ",login,fail");
            } else {
                this.auditLog.warn(credential.getId() + ",login,fail," + e);
            }
        }
    }

    @Override
    public void loginLocked(Credential credential) {
        if (this.auditLog.isWarnEnabled()) {
            this.auditLog.warn(credential.getId() + ",login,locked");
        }
    }

    @Override
    public void loginSuccess(UserContext user) {
        if (this.auditLog.isInfoEnabled()) {
            this.auditLog.info(user.getUser().getAccountId() + ",login,success");
        }
    }

    @Override
    public void loginPasswordExpired(Credential credential) {
        if (this.auditLog.isInfoEnabled()) {
            this.auditLog.info(credential.getId() + ",login,passExpired");
        }
    }

    @Override
    public void updatePasswordSuccess(Credential oldCredential) {
        if (this.auditLog.isInfoEnabled()) {
            this.auditLog.info(oldCredential.getId() + ",updatePass,success");
        }
    }

    @Override
    public void updatePasswordFail(Credential oldCredential, CredentialUpdateException e) {
        if (this.auditLog.isWarnEnabled()) {
            this.auditLog.warn(oldCredential.getId() + ",updatePass,fail," + e.toString());
        }
    }

    @Override
    public void resetPasswordSuccess(Credential credential) {
        if (this.auditLog.isInfoEnabled()) {
            this.auditLog.info(credential.getId() + ",resetPass,success");
        }
    }
}

