/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.iplass.mtp.impl.cache.store.CacheHandler;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.cache.store.CacheStoreFactory;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheService
implements Service {
    private static Logger logger = LoggerFactory.getLogger(CacheService.class);
    private static final String CACHE_STORE_FACTORY_DEFAULT_NAME = "defaultFactory";
    private HashMap<String, CacheStoreFactory> namespaceMap;
    private ArrayList<NamespacePattern> namespacePattern;
    private CacheStoreFactory defaultFactory;
    private List<CacheStoreFactory> factories;
    private ConcurrentHashMap<Object, Object> cacheStore;

    public CacheStore getCache(String namespace) {
        return this.getCache(namespace, true);
    }

    public CacheStore getCache(String namespace, boolean isCreate) {
        CacheStore c = (CacheStore)this.cacheStore.get(namespace);
        if (c == null && isCreate) {
            c = this.create(namespace, false);
            this.cacheStore.putIfAbsent(namespace, c);
            c = (CacheStore)this.cacheStore.get(namespace);
        }
        return c;
    }

    public CacheStore createLocalCache(String namespace) {
        CacheStore ret = this.create(namespace, true);
        return ret;
    }

    public CacheHandler createCacheHandler(CacheStore store) {
        CacheStoreFactory f = store.getFactory();
        return f.createCacheHandler(store);
    }

    private CacheStore create(String namespace, boolean isLocalUse) {
        CacheStoreFactory f = this.namespaceMap.get(namespace);
        if (f != null) {
            if (isLocalUse && !f.canUseForLocalCache()) {
                throw new ServiceConfigrationException(f.getClass() + " can not use for localCache. at CacheStore:" + namespace);
            }
            logger.debug("create CacheStore:" + namespace + " by specific namespace");
            return f.createCacheStore(namespace);
        }
        for (NamespacePattern p : this.namespacePattern) {
            if (!p.pattern.matcher(namespace).matches()) continue;
            if (isLocalUse && !p.factory.canUseForLocalCache()) {
                throw new ServiceConfigrationException(p.factory.getClass() + " can not use for localCache. at CacheStore:" + namespace + " by namespacePattern:" + p.factory.getNamespacePattern() + " Factory");
            }
            logger.debug("create CacheStore:" + namespace + " by namespacePattern:" + p.factory.getNamespacePattern() + " Factory");
            return p.factory.createCacheStore(namespace);
        }
        if (this.defaultFactory != null) {
            if (isLocalUse && !this.defaultFactory.canUseForLocalCache()) {
                throw new ServiceConfigrationException(this.defaultFactory.getClass() + " can not use for localCache. at CacheStore:" + namespace + " by defaultFactory");
            }
            return this.defaultFactory.createCacheStore(namespace);
        }
        throw new ServiceConfigrationException("no CacheStore configration matches for " + namespace);
    }

    public void invalidate(String namespace) {
        CacheStore c;
        ConcurrentHashMap<Object, Object> refCacheStore = this.cacheStore;
        if (refCacheStore != null && (c = (CacheStore)refCacheStore.get(namespace)) != null && refCacheStore.remove(namespace, c)) {
            logger.debug("invaliadte CacheStore:" + namespace);
            c.destroy();
        }
    }

    @Override
    public void destroy() {
        ConcurrentHashMap<Object, Object> refCacheStore = this.cacheStore;
        this.cacheStore = null;
        if (refCacheStore != null) {
            for (Map.Entry<Object, Object> e : refCacheStore.entrySet()) {
                CacheStore c = (CacheStore)e.getValue();
                if (c == null) continue;
                logger.debug("destroy CacheStore:" + e.getKey());
                c.destroy();
            }
        }
    }

    @Override
    public void init(Config config) {
        this.namespaceMap = new HashMap();
        this.namespacePattern = new ArrayList();
        this.cacheStore = new ConcurrentHashMap();
        this.factories = new ArrayList<CacheStoreFactory>();
        Set<String> names = config.getNames();
        for (String n : names) {
            if (n.equals(CACHE_STORE_FACTORY_DEFAULT_NAME)) {
                this.defaultFactory = (CacheStoreFactory)config.getBean(n);
                this.factories.add(this.defaultFactory);
                continue;
            }
            List<?> cacheStoreFactory = config.getBeans(n);
            if (cacheStoreFactory == null) continue;
            for (CacheStoreFactory f : cacheStoreFactory) {
                this.factories.add(f);
                if (f.getNamespace() != null) {
                    this.namespaceMap.put(f.getNamespace(), f);
                    continue;
                }
                this.namespacePattern.add(new NamespacePattern(f));
            }
        }
    }

    public List<CacheStoreFactory> getFactories() {
        return this.factories;
    }

    private class NamespacePattern {
        Pattern pattern;
        CacheStoreFactory factory;

        private NamespacePattern(CacheStoreFactory factory) {
            this.pattern = Pattern.compile(factory.getNamespacePattern());
            this.factory = factory;
        }
    }
}

