/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cache.store.builtin;

import java.lang.ref.WeakReference;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.iplass.mtp.impl.cache.store.builtin.SimpleCacheStoreBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheEntryCleaner {
    private static Logger logger = LoggerFactory.getLogger(CacheEntryCleaner.class);
    private static CacheEntryCleaner instance = new CacheEntryCleaner();
    private ScheduledExecutorService executer;

    public static CacheEntryCleaner getInstance() {
        return instance;
    }

    public static void shutdown() {
        if (!CacheEntryCleaner.instance.executer.isShutdown()) {
            CacheEntryCleaner.instance.executer.shutdown();
            try {
                CacheEntryCleaner.instance.executer.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("exception when shutdown CacheEntryCleaner", e);
            }
        }
    }

    public CacheEntryCleaner() {
        SecurityManager s = System.getSecurityManager();
        ThreadGroup group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.executer = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(group, r, "CacheEntryCleaner", 0L);
            t.setDaemon(true);
            t.setPriority(1);
            t.setUncaughtExceptionHandler((thread, e) -> {
                Thread.UncaughtExceptionHandler uh = Thread.getDefaultUncaughtExceptionHandler();
                if (uh != null) {
                    uh.uncaughtException(thread, e);
                } else {
                    logger.error("Exception in CacheEntryCleaner " + e, e);
                }
            });
            return t;
        });
    }

    public void register(SimpleCacheStoreBase store, long interval) {
        Worker worker = new Worker(store);
        ScheduledFuture<?> future = this.executer.scheduleWithFixedDelay(worker, interval, interval, TimeUnit.MILLISECONDS);
        worker.future = future;
    }

    private static class Worker
    implements Runnable {
        private WeakReference<SimpleCacheStoreBase> ref;
        private volatile ScheduledFuture<?> future;

        private Worker(SimpleCacheStoreBase store) {
            this.ref = new WeakReference<SimpleCacheStoreBase>(store);
        }

        @Override
        public void run() {
            SimpleCacheStoreBase cs = (SimpleCacheStoreBase)this.ref.get();
            if (cs == null) {
                this.future.cancel(true);
            } else {
                cs.removeInvalidEntry();
            }
        }
    }
}

