/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cache.store.builtin;

import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.cache.store.CacheStoreFactory;
import org.iplass.mtp.impl.cache.store.event.CacheEventListener;

public class IndexedCacheStoreWrapper
implements CacheStore {
    private final CacheStore wrapped;
    private final CacheStore[] indexStore;
    private final ReentrantReadWriteLock[] locks;
    private final int segmentMask;
    private final int segmentShift;

    public IndexedCacheStoreWrapper(CacheStore wrapped, CacheStore[] indexStore, int concurrencyLevel, boolean fair) {
        int ssize;
        this.wrapped = wrapped;
        this.indexStore = indexStore;
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.locks = new ReentrantReadWriteLock[ssize];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new ReentrantReadWriteLock(fair);
        }
    }

    private static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    private final ReentrantReadWriteLock lockFor(int hash) {
        return this.locks[hash >>> this.segmentShift & this.segmentMask];
    }

    @Override
    public String getNamespace() {
        return this.wrapped.getNamespace();
    }

    @Override
    public CacheStoreFactory getFactory() {
        return this.wrapped.getFactory();
    }

    @Override
    public CacheEntry put(CacheEntry entry, boolean clean) {
        return null;
    }

    @Override
    public CacheEntry putIfAbsent(CacheEntry entry) {
        return null;
    }

    @Override
    public CacheEntry get(Object key) {
        return null;
    }

    @Override
    public CacheEntry remove(Object key) {
        return null;
    }

    @Override
    public boolean remove(CacheEntry entry) {
        return false;
    }

    @Override
    public CacheEntry replace(CacheEntry entry) {
        return null;
    }

    @Override
    public boolean replace(CacheEntry oldEntry, CacheEntry newEntry) {
        return false;
    }

    @Override
    public void removeAll() {
    }

    @Override
    public List<Object> keySet() {
        return null;
    }

    @Override
    public CacheEntry getByIndex(int indexKey, Object indexValue) {
        return null;
    }

    @Override
    public List<CacheEntry> getListByIndex(int indexKey, Object indexValue) {
        return null;
    }

    @Override
    public List<CacheEntry> removeByIndex(int indexKey, Object indexValue) {
        return null;
    }

    @Override
    public void addCacheEventListenner(CacheEventListener listener) {
    }

    @Override
    public void removeCacheEventListenner(CacheEventListener listener) {
    }

    @Override
    public String trace() {
        return null;
    }

    @Override
    public void destroy() {
    }

    @Override
    public List<CacheEventListener> getListeners() {
        return null;
    }
}

