/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cluster;

import java.util.List;
import org.iplass.mtp.impl.cluster.ClusterEventListener;
import org.iplass.mtp.impl.cluster.ListenerMap;
import org.iplass.mtp.impl.cluster.Message;
import org.iplass.mtp.impl.cluster.channel.MessageChannel;
import org.iplass.mtp.impl.cluster.channel.MessageReceiver;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterService
implements Service {
    private static Logger logger = LoggerFactory.getLogger(ClusterService.class);
    private MessageChannel messageChannel;
    private final ListenerMap listenerMap = new ListenerMap();

    @Override
    public void init(Config config) {
        this.listenerMap.init();
        this.messageChannel = (MessageChannel)config.getBean("messageChannel");
        if (this.messageChannel != null) {
            this.messageChannel.setMessageReceiver(new MessageReceiver(){

                @Override
                public void receiveMessage(Message msg) {
                    List<ClusterEventListener> listeners = ClusterService.this.listenerMap.getListener(msg.getEventName());
                    for (ClusterEventListener l : listeners) {
                        try {
                            l.onMessage(msg);
                        }
                        catch (RuntimeException e) {
                            logger.error("exception occurred while handling message at " + l + ":" + e + ", " + msg, (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void destroy() {
    }

    public MessageChannel getMessageChannel() {
        return this.messageChannel;
    }

    public void setMessageChannel(MessageChannel messageChannel) {
        this.messageChannel = messageChannel;
    }

    public void sendMessage(Message msg) {
        if (this.messageChannel != null) {
            this.messageChannel.sendMessage(msg);
        }
    }

    public void registerListener(String[] eventNames, ClusterEventListener listener) {
        for (String e : eventNames) {
            this.listenerMap.addListener(e, listener);
        }
    }

    public void removeListener(String[] eventNames, ClusterEventListener listener) {
        for (String e : eventNames) {
            this.listenerMap.removeListener(e, listener);
        }
    }
}

