/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command;

import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.CommandInvoker;
import org.iplass.mtp.command.CommandRuntimeException;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.async.AsyncRequestContext;
import org.iplass.mtp.command.async.ResultHandler;
import org.iplass.mtp.impl.command.CommandService;
import org.iplass.mtp.impl.command.InterceptorService;
import org.iplass.mtp.impl.command.InvocationImpl;
import org.iplass.mtp.impl.command.MetaMetaCommand;
import org.iplass.mtp.impl.command.async.AsyncCommandService;
import org.iplass.mtp.impl.command.async.MetaAsyncCommand;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.TransactionOption;

public class CommandInvokerImpl
implements CommandInvoker {
    public static final String COMMAND_META_META_PATH = "/commandClass/";
    public static final String INVOKER_INTERCEPTOR_NAME = "invoker";
    CommandService service = ServiceRegistry.getRegistry().getService(CommandService.class);
    InterceptorService interceptorService = ServiceRegistry.getRegistry().getService(InterceptorService.class);
    AsyncCommandService acs = ServiceRegistry.getRegistry().getService(AsyncCommandService.class);

    @Override
    public String execute(String cmdName, RequestContext request) {
        return this.execute(cmdName, request, null);
    }

    @Override
    public String execute(String cmdName, RequestContext request, TransactionOption transactionOption) {
        MetaMetaCommand.MetaCommandRuntime handler = (MetaMetaCommand.MetaCommandRuntime)this.service.getRuntimeByName(cmdName);
        InvocationImpl invocation = new InvocationImpl(this.interceptorService.getInterceptors(INVOKER_INTERCEPTOR_NAME), handler, request, transactionOption);
        return invocation.proceedCommand();
    }

    @Override
    public String execute(Command cmd, RequestContext request) {
        return this.execute(cmd, request, null);
    }

    @Override
    public String execute(Command cmd, RequestContext request, TransactionOption transactionOption) {
        CommandClass cc = cmd.getClass().getAnnotation(CommandClass.class);
        String cmdName = cc != null ? cc.name() : cmd.getClass().getName();
        InvocationImpl invocation = new InvocationImpl(this.interceptorService.getInterceptors(INVOKER_INTERCEPTOR_NAME), cmd, request, transactionOption, cmdName);
        return invocation.proceedCommand();
    }

    @Override
    public Command getCommandInstance(String cmdName) {
        MetaMetaCommand.MetaCommandRuntime handler = (MetaMetaCommand.MetaCommandRuntime)this.service.getRuntimeByName(cmdName);
        Command cmd = handler.newCommand();
        return cmd;
    }

    @Override
    public long executeAsync(String asyncTaskCmdName, AsyncRequestContext request) {
        return this.executeAsync(asyncTaskCmdName, request, null);
    }

    @Override
    public long executeAsync(String asyncTaskCmdName, AsyncRequestContext request, ResultHandler resultHandler) {
        MetaAsyncCommand.AsyncCommandRuntime runtime = (MetaAsyncCommand.AsyncCommandRuntime)this.acs.getRuntimeByName(asyncTaskCmdName);
        if (runtime == null) {
            throw new CommandRuntimeException("AsyncCommand:" + asyncTaskCmdName + " not found");
        }
        if (request == null) {
            request = new AsyncRequestContext();
        }
        return runtime.executeAsync(request, resultHandler);
    }
}

