/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command.beanmapper.el;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELException;
import org.iplass.mtp.impl.command.beanmapper.el.PropertyInfo;
import org.iplass.mtp.impl.command.beanmapper.el.SoftConcurrentHashMap;

class BeanInfo {
    private static SoftConcurrentHashMap<Class<?>, BeanInfo> biMap = new SoftConcurrentHashMap(256);
    private final Map<String, PropertyInfo> propertyMap = new HashMap<String, PropertyInfo>();

    static BeanInfo getBeanInfo(Class<?> beanClass) {
        BeanInfo bi = biMap.get(beanClass);
        if (bi == null) {
            bi = new BeanInfo(beanClass);
            biMap.put(beanClass, bi);
        }
        return bi;
    }

    static PropertyInfo getPropertyInfo(Class<?> beanClass, String propName) {
        BeanInfo bi = BeanInfo.getBeanInfo(beanClass);
        return bi.getProperty(propName);
    }

    BeanInfo(Class<?> beanClass) {
        PropertyDescriptor[] descriptors;
        try {
            descriptors = Introspector.getBeanInfo(beanClass).getPropertyDescriptors();
        }
        catch (IntrospectionException ie) {
            throw new ELException((Throwable)ie);
        }
        for (PropertyDescriptor pd : descriptors) {
            PropertyInfo pi = new PropertyInfo(beanClass, pd);
            if (pi.getTypeKind() == null) continue;
            this.propertyMap.put(pd.getName(), pi);
        }
    }

    public Collection<PropertyInfo> getProperties() {
        return this.propertyMap.values();
    }

    public PropertyInfo getProperty(String property) {
        return this.propertyMap.get(property);
    }
}

