/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command.beanmapper.el;

import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.impl.command.beanmapper.el.BeanInfo;
import org.iplass.mtp.impl.command.beanmapper.el.BeanMapperELContext;
import org.iplass.mtp.impl.command.beanmapper.el.EntityELResolver;
import org.iplass.mtp.impl.command.beanmapper.el.PropertyInfo;

public class ExtendedBeanELResolver
extends ELResolver {
    private static Set<String> DEFAULT_SUPPRESS_PROPERTIES;
    private Set<String> suppressProperties;
    private EntityELResolver entityResolver = new EntityELResolver();

    public ExtendedBeanELResolver() {
        this(DEFAULT_SUPPRESS_PROPERTIES);
    }

    public ExtendedBeanELResolver(Set<String> suppressProperties) {
        this.suppressProperties = suppressProperties == null ? Collections.emptySet() : suppressProperties;
    }

    private void checkSuppress(Object property) {
        if (property != null && this.suppressProperties.contains(property.toString())) {
            throw new PropertyNotFoundException("The property:" + property.toString() + " is defined as must suppressed.");
        }
    }

    public Object getValue(ELContext context, Object base, Object property) {
        Method method;
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        this.checkSuppress(property);
        PropertyInfo pi = BeanInfo.getPropertyInfo(base.getClass(), property.toString());
        if (pi != null && (method = pi.getReadMethod()) != null) {
            Object value;
            try {
                value = method.invoke(base, new Object[0]);
                context.setPropertyResolved(base, property);
                BeanMapperELContext bmc = (BeanMapperELContext)((Object)context.getContext(BeanMapperELContext.class));
                if (bmc.getElMapper().isAutoGrow()) {
                    if (value == null && (value = this.newPropertyInstance(pi)) != null) {
                        this.setValue(pi, base, value);
                    }
                    bmc.setPropertyRef(base, pi, value);
                }
            }
            catch (ELException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                throw new ELException(e.getCause());
            }
            catch (Exception e) {
                throw new ELException((Throwable)e);
            }
            return value;
        }
        if (base instanceof Entity) {
            Object value = this.entityResolver.getValue(context, base, property);
            if (context.isPropertyResolved()) {
                return value;
            }
        }
        throw new PropertyNotFoundException("The class:" + base.getClass().getName() + " does not have a readable property:" + property.toString());
    }

    private Object newPropertyInstance(PropertyInfo propertyInfo) throws InstantiationException, IllegalAccessException {
        switch (propertyInfo.getTypeKind()) {
            case BEAN: {
                return propertyInfo.getPropertyType().newInstance();
            }
            case ENTITY: {
                if (propertyInfo.getPropertyType().isInterface()) {
                    return new GenericEntity();
                }
                return propertyInfo.getPropertyType().newInstance();
            }
            case ARRAY: {
                return Array.newInstance(propertyInfo.getComponentType(), 0);
            }
            case LIST: {
                return new ArrayList();
            }
            case MAP: {
                return new HashMap();
            }
        }
        return null;
    }

    private void setValue(PropertyInfo pi, Object bean, Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = pi.getWriteMethod();
        if (method == null) {
            throw new PropertyNotWritableException("The class:" + bean.getClass().getName() + " does not have a writable property:" + pi.getDescriptor().getName());
        }
        method.invoke(bean, value);
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        this.checkSuppress(property);
        PropertyInfo pi = BeanInfo.getPropertyInfo(base.getClass(), property.toString());
        if (pi != null) {
            context.setPropertyResolved(true);
            return pi.getPropertyType();
        }
        if (base instanceof Entity) {
            Class<?> type = this.entityResolver.getType(context, base, property);
            if (context.isPropertyResolved()) {
                return type;
            }
        }
        throw new PropertyNotFoundException("The class:" + base.getClass().getName() + " does not have the property:" + property.toString());
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        PropertyInfo pi;
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return;
        }
        this.checkSuppress(property);
        if (value instanceof String) {
            BeanMapperELContext bmc = (BeanMapperELContext)((Object)context.getContext(BeanMapperELContext.class));
            if (bmc.getElMapper().isTrim()) {
                value = ((String)value).trim();
            }
            if (bmc.getElMapper().isEmptyToNull() && ((String)value).isEmpty()) {
                value = null;
            }
        }
        if ((pi = BeanInfo.getPropertyInfo(base.getClass(), property.toString())) != null) {
            try {
                this.setValue(pi, base, value);
                context.setPropertyResolved(base, property);
                return;
            }
            catch (ELException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                throw new ELException(e.getCause());
            }
            catch (Exception e) {
                if (null == value) {
                    value = "null";
                }
                throw new ELException("Can't set property:" + property.toString() + " on class:" + base.getClass().getName() + " to value:" + value, (Throwable)e);
            }
        }
        if (base instanceof Entity) {
            this.entityResolver.setValue(context, base, property, value);
            if (context.isPropertyResolved()) {
                return;
            }
        }
        throw new PropertyNotFoundException("The class:" + base.getClass().getName() + " does not have the property:" + property.toString());
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return false;
        }
        this.checkSuppress(property);
        context.setPropertyResolved(true);
        PropertyInfo pi = BeanInfo.getPropertyInfo(base.getClass(), property.toString());
        if (pi != null) {
            return pi.isReadOnly();
        }
        if (base instanceof Entity) {
            return false;
        }
        throw new PropertyNotFoundException("The class:" + base.getClass().getName() + " does not have the property:" + property.toString());
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        BeanInfo info = BeanInfo.getBeanInfo(base.getClass());
        if (info == null) {
            return null;
        }
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>();
        for (PropertyInfo pi : info.getProperties()) {
            PropertyDescriptor pd = pi.getDescriptor();
            pd.setValue("type", pd.getPropertyType());
            pd.setValue("resolvableAtDesignTime", Boolean.TRUE);
            list.add(pd);
        }
        return list.iterator();
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        return Object.class;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("class");
        set.add("metaClass");
        DEFAULT_SUPPRESS_PROPERTIES = Collections.unmodifiableSet(set);
    }
}

