/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command.interceptors;

import org.iplass.mtp.command.interceptor.CommandInterceptor;
import org.iplass.mtp.command.interceptor.CommandInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LoggingInterceptor
implements CommandInterceptor {
    private static final String MDC_CMD = "command";
    private static Logger commandLogger = LoggerFactory.getLogger((String)"mtp.command");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String intercept(CommandInvocation invocation) {
        String prev = MDC.get((String)MDC_CMD);
        MDC.put((String)MDC_CMD, (String)invocation.getCommandName());
        try {
            if (commandLogger.isDebugEnabled()) {
                long start = System.currentTimeMillis();
                String res = null;
                try {
                    String string = res = invocation.proceedCommand();
                    return string;
                }
                catch (RuntimeException e) {
                    res = e.toString();
                    throw e;
                }
                finally {
                    String cmd = "";
                    if (invocation.getCommand() != null) {
                        cmd = invocation.getCommand().toString();
                    }
                    commandLogger.debug(cmd + "," + res + "," + (System.currentTimeMillis() - start) + "ms");
                }
            }
            String string = invocation.proceedCommand();
            return string;
        }
        finally {
            if (prev == null) {
                MDC.remove((String)MDC_CMD);
            } else {
                MDC.put((String)MDC_CMD, (String)prev);
            }
        }
    }
}

