/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.core;

import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.Manager;
import org.iplass.mtp.impl.core.ManagerConstructor;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceConfigrationException;

public class ManagerFactory
implements Service {
    private Map<Class<?>, ManagerConstructor> map;

    @Override
    public void init(Config config) {
        this.map = new HashMap();
        for (String name : config.getNames()) {
            ManagerConstructor mc;
            Class<?> ifType;
            try {
                ifType = Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                throw new ServiceConfigrationException(e.toString(), e);
            }
            Object value = config.getBean(name);
            if (value instanceof ManagerConstructor) {
                mc = (ManagerConstructor)value;
            } else {
                Class<?> implType;
                try {
                    implType = Class.forName((String)value);
                }
                catch (ClassNotFoundException e) {
                    throw new ServiceConfigrationException(e.toString(), e);
                }
                if (!Manager.class.isAssignableFrom(ifType)) {
                    throw new ServiceConfigrationException("interface type:" + ifType.getName() + " must extends/implements Manager interface");
                }
                if (!ifType.isAssignableFrom(implType)) {
                    throw new ServiceConfigrationException(implType.getName() + " must extends/implements " + ifType.getName());
                }
                mc = () -> {
                    try {
                        return (Manager)implType.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new ServiceConfigrationException("Can't instanceate manager:" + implType.getName(), e);
                    }
                };
            }
            this.map.put(ifType, mc);
        }
    }

    @Override
    public void destroy() {
    }

    public <M extends Manager> M create(Class<M> type) {
        ManagerConstructor constructor = this.map.get(type);
        if (constructor == null) {
            throw new ServiceConfigrationException("Manager:" + type.getName() + " not registered.");
        }
        Manager m = constructor.construct();
        return (M)m;
    }
}

