/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.core.config;

import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.codehaus.groovy.control.CompilationFailedException;
import org.iplass.mtp.impl.core.config.ConfigPreprocessor;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyPreprocessor
implements ConfigPreprocessor {
    private static Logger logger = LoggerFactory.getLogger(GroovyPreprocessor.class);
    private Pattern pattern = Pattern.compile("(?i)<serviceDefinition\\s*preprocess\\s*=\\s*(\"|')true(\"|')\\s*>");

    @Override
    public String preprocess(String xml, String filePath) {
        if (this.pattern.matcher(xml).find()) {
            if (logger.isDebugEnabled()) {
                logger.debug("preprocess " + filePath);
            }
            try {
                GStringTemplateEngine eng = new GStringTemplateEngine();
                Template tmpl = eng.createTemplate(xml);
                HashMap<String, String> binding = new HashMap<String, String>();
                binding.put("filePath", filePath);
                xml = tmpl.make(null).toString();
            }
            catch (IOException | ClassNotFoundException | CompilationFailedException e) {
                throw new ServiceConfigrationException("preprocess failed:" + filePath, e);
            }
        }
        return xml;
    }
}

