/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.counter;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.entity.EntityApplicationException;
import org.iplass.mtp.entity.EntityConcurrentUpdateException;
import org.iplass.mtp.entity.EntityDuplicateValueException;
import org.iplass.mtp.impl.cache.CacheService;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.cache.store.keyresolver.CacheKeyResolver;
import org.iplass.mtp.impl.counter.CounterService;
import org.iplass.mtp.impl.counter.RdbTableCounterService;
import org.iplass.mtp.impl.counter.sql.RdbTableCounterSql;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachableRdbTableCounterService
implements CounterService {
    private static final String COUNTER_CACHE_NAMESPACE = "mtp.counter.rdbTableCounter";
    private static Logger logger = LoggerFactory.getLogger(CachableRdbTableCounterService.class);
    private int cacheSize = 20;
    private RdbTableCounterService rdbCounter;
    private CacheStore cache;

    @Override
    public void init(Config config) {
        this.rdbCounter = new RdbTableCounterService();
        this.rdbCounter.init(config);
        this.cacheSize = config.getValue("cacheSize", Integer.TYPE, 20);
        CacheService cs = config.getDependentService(CacheService.class);
        this.cache = cs.getCache(COUNTER_CACHE_NAMESPACE);
    }

    @Override
    public void destroy() {
        this.rdbCounter.destroy();
        CacheService cs = ServiceRegistry.getRegistry().getService(CacheService.class);
        cs.invalidate(COUNTER_CACHE_NAMESPACE);
    }

    @Override
    public long increment(int tenantId, String incrementUnitKey, long initialCount) {
        CacheEntry newCe;
        CounterKey key = new CounterKey(tenantId, this.rdbCounter.getCounterTypeName(), incrementUnitKey);
        CacheEntry ce = this.cache.get(key);
        if (ce == null && (ce = this.cache.putIfAbsent(newCe = new CacheEntry((Object)key, (Object)new Counter(key, initialCount), new Object[0]))) == null) {
            ce = newCe;
        }
        return ((Counter)ce.getValue()).increment();
    }

    @Override
    public void resetCounter(int tenantId, String incrementUnitKey) {
        this.resetCounter(tenantId, incrementUnitKey, 0L);
    }

    @Override
    public void resetCounter(int tenantId, String incrementUnitKey, long currentCount) {
        Transaction.requiresNew(t -> this.rdbCounter.resetCounter(tenantId, incrementUnitKey, currentCount));
        this.cache.remove(new CounterKey(tenantId, this.rdbCounter.getCounterTypeName(), incrementUnitKey));
    }

    @Override
    public void deleteCounter(int tenantId, String incrementUnitKey) {
        Transaction.requiresNew(t -> this.rdbCounter.deleteCounter(tenantId, incrementUnitKey));
        this.cache.remove(new CounterKey(tenantId, this.rdbCounter.getCounterTypeName(), incrementUnitKey));
    }

    @Override
    public long current(int tenantId, String incrementUnitKey) {
        CounterKey key = new CounterKey(tenantId, this.rdbCounter.getCounterTypeName(), incrementUnitKey);
        CacheEntry ce = this.cache.get(key);
        if (ce != null) {
            return ((Counter)ce.getValue()).current();
        }
        return this.rdbCounter.current(tenantId, incrementUnitKey);
    }

    public static class CounterCacheKeyResolver
    implements CacheKeyResolver {
        @Override
        public String toString(Object cacheKey) {
            CounterKey key = (CounterKey)cacheKey;
            StringBuilder sb = new StringBuilder();
            sb.append(key.getTenantId()).append(':').append(key.getIncrementUnitKey());
            return sb.toString();
        }

        @Override
        public Object toCacheKey(String cacheKeyString) {
            int index = cacheKeyString.indexOf(58);
            int tenantId = Integer.parseInt(cacheKeyString.substring(0, index));
            int index2 = cacheKeyString.indexOf(index + 1, 58);
            String type = cacheKeyString.substring(index, index2);
            String incUnitKey = cacheKeyString.substring(index2 + 1);
            return new CounterKey(tenantId, type, incUnitKey);
        }
    }

    private class Counter {
        private final CounterKey key;
        private long cachedMax;
        private long count;
        private boolean inited;

        private Counter(CounterKey key, long initCount) {
            this.key = key;
            this.cachedMax = this.count = initCount;
            this.inited = false;
        }

        public synchronized long increment() {
            if (!this.inited || this.count == this.cachedMax) {
                for (int i = 0; i < CachableRdbTableCounterService.this.rdbCounter.getRetryCount(); ++i) {
                    try {
                        this.loadNextCount();
                        break;
                    }
                    catch (RuntimeException e) {
                        if (i + 1 == CachableRdbTableCounterService.this.rdbCounter.getRetryCount()) {
                            throw e;
                        }
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("fail to increment counter:" + CachableRdbTableCounterService.this.rdbCounter.getCounterTypeName() + "." + this.key.getIncrementUnitKey() + ", retry...");
                        continue;
                    }
                }
            }
            ++this.count;
            return this.count;
        }

        private void loadNextCount() {
            if (logger.isDebugEnabled()) {
                logger.debug("counter:" + CachableRdbTableCounterService.this.rdbCounter.getCounterTypeName() + "." + this.key.getIncrementUnitKey() + " load to cache, size=" + CachableRdbTableCounterService.this.cacheSize);
            }
            EntityApplicationException eae = null;
            Long rdbCount = null;
            try {
                rdbCount = Transaction.requiresNew(t -> {
                    SqlExecuter<Long> executer = new SqlExecuter<Long>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Long logic() throws SQLException {
                            RdbTableCounterSql sql = CachableRdbTableCounterService.this.rdbCounter.getCounterSql();
                            String select = sql.currentValueSql(Counter.this.key.getTenantId(), CachableRdbTableCounterService.this.rdbCounter.getCounterTypeName(), Counter.this.key.getIncrementUnitKey(), true, CachableRdbTableCounterService.this.rdbCounter.getRdbAdapter());
                            long current = Long.MIN_VALUE;
                            try (ResultSet rs = this.getStatement().executeQuery(select);){
                                if (rs.next()) {
                                    current = rs.getLong(1);
                                }
                            }
                            if (current != Long.MIN_VALUE) {
                                String update = sql.incrementSql(Counter.this.key.getTenantId(), CachableRdbTableCounterService.this.rdbCounter.getCounterTypeName(), Counter.this.key.getIncrementUnitKey(), CachableRdbTableCounterService.this.cacheSize, CachableRdbTableCounterService.this.rdbCounter.getRdbAdapter());
                                int res = this.getStatement().executeUpdate(update);
                                if (res != 1) {
                                    throw new SystemException("counter:" + CachableRdbTableCounterService.this.rdbCounter.getCounterTypeName() + "." + Counter.this.key.getIncrementUnitKey() + " increment failed");
                                }
                                return current;
                            }
                            String create = sql.createCounterSql(Counter.this.key.getTenantId(), CachableRdbTableCounterService.this.rdbCounter.getCounterTypeName(), Counter.this.key.getIncrementUnitKey(), Counter.this.count - 1L + (long)CachableRdbTableCounterService.this.cacheSize, CachableRdbTableCounterService.this.rdbCounter.getRdbAdapter());
                            int res = this.getStatement().executeUpdate(create);
                            if (res != 1) {
                                throw new SystemException("counter:" + CachableRdbTableCounterService.this.rdbCounter.getCounterTypeName() + "." + Counter.this.key.getIncrementUnitKey() + " increment failed");
                            }
                            return Counter.this.count - 1L;
                        }
                    };
                    return (Long)executer.execute(CachableRdbTableCounterService.this.rdbCounter.getRdbAdapter(), true);
                });
            }
            catch (EntityDuplicateValueException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("counter:" + CachableRdbTableCounterService.this.rdbCounter.getCounterTypeName() + "." + this.key.getIncrementUnitKey() + " init process is failed, mybe antoher thread or server inited.retry get counter...", (Throwable)e);
                } else {
                    logger.warn("counter:" + CachableRdbTableCounterService.this.rdbCounter.getCounterTypeName() + "." + this.key.getIncrementUnitKey() + " init process is failed, mybe antoher thread or server inited.retry get counter...");
                }
                eae = e;
            }
            catch (EntityConcurrentUpdateException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("counter:" + CachableRdbTableCounterService.this.rdbCounter.getCounterTypeName() + "." + this.key.getIncrementUnitKey() + " init process is failed, mybe antoher thread or server inited.retry get counter...", (Throwable)e);
                } else {
                    logger.warn("counter:" + CachableRdbTableCounterService.this.rdbCounter.getCounterTypeName() + "." + this.key.getIncrementUnitKey() + " init process is failed, mybe antoher thread or server inited.retry get counter...");
                }
                eae = e;
            }
            if (eae != null) {
                rdbCount = Transaction.requiresNew(t -> {
                    SqlExecuter<Long> executer = new SqlExecuter<Long>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Long logic() throws SQLException {
                            RdbTableCounterSql sql = CachableRdbTableCounterService.this.rdbCounter.getCounterSql();
                            String select = sql.currentValueSql(Counter.this.key.getTenantId(), CachableRdbTableCounterService.this.rdbCounter.getCounterTypeName(), Counter.this.key.getIncrementUnitKey(), true, CachableRdbTableCounterService.this.rdbCounter.getRdbAdapter());
                            long current = Long.MIN_VALUE;
                            try (ResultSet rs = this.getStatement().executeQuery(select);){
                                if (rs.next()) {
                                    current = rs.getLong(1);
                                }
                            }
                            if (current != Long.MIN_VALUE) {
                                String update = sql.incrementSql(Counter.this.key.getTenantId(), CachableRdbTableCounterService.this.rdbCounter.getCounterTypeName(), Counter.this.key.getIncrementUnitKey(), CachableRdbTableCounterService.this.cacheSize, CachableRdbTableCounterService.this.rdbCounter.getRdbAdapter());
                                int res = this.getStatement().executeUpdate(update);
                                if (res != 1) {
                                    throw new SystemException("counter:" + CachableRdbTableCounterService.this.rdbCounter.getCounterTypeName() + "." + Counter.this.key.getIncrementUnitKey() + " increment failed");
                                }
                                return current;
                            }
                            return null;
                        }
                    };
                    return (Long)executer.execute(CachableRdbTableCounterService.this.rdbCounter.getRdbAdapter(), true);
                });
            }
            if (rdbCount == null) {
                throw new SystemException("counter:" + CachableRdbTableCounterService.this.rdbCounter.getCounterTypeName() + "." + this.key.getIncrementUnitKey() + " increment failed");
            }
            this.count = rdbCount;
            this.cachedMax = rdbCount + (long)CachableRdbTableCounterService.this.cacheSize;
            this.inited = true;
        }

        public synchronized long current() {
            if (this.inited) {
                return this.count;
            }
            return CachableRdbTableCounterService.this.rdbCounter.current(this.key.getTenantId(), this.key.getIncrementUnitKey());
        }
    }

    private static class CounterKey
    implements Serializable {
        private static final long serialVersionUID = 9085282190400818284L;
        private final int tenantId;
        private final String typeName;
        private final String incrementUnitKey;

        public CounterKey(int tenantId, String typeName, String incrementUnitKey) {
            this.tenantId = tenantId;
            this.typeName = typeName;
            this.incrementUnitKey = incrementUnitKey;
        }

        public int getTenantId() {
            return this.tenantId;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getIncrementUnitKey() {
            return this.incrementUnitKey;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.incrementUnitKey == null ? 0 : this.incrementUnitKey.hashCode());
            result = 31 * result + this.tenantId;
            result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CounterKey other = (CounterKey)obj;
            if (this.incrementUnitKey == null ? other.incrementUnitKey != null : !this.incrementUnitKey.equals(other.incrementUnitKey)) {
                return false;
            }
            if (this.tenantId != other.tenantId) {
                return false;
            }
            return !(this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName));
        }
    }
}

