/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.counter;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.counter.CounterService;
import org.iplass.mtp.impl.counter.sql.RdbTableCounterSql;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.transaction.Propagation;
import org.iplass.mtp.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbTableCounterService
implements CounterService {
    private static Logger logger = LoggerFactory.getLogger(RdbTableCounterService.class);
    private boolean separateTransaction;
    private int retryCount;
    private String counterTypeName;
    private RdbTableCounterSql sql;
    private RdbAdapter rdb;

    public String getCounterTypeName() {
        return this.counterTypeName;
    }

    public void setCounterTypeName(String counterTypeName) {
        this.counterTypeName = counterTypeName;
    }

    protected RdbAdapter getRdbAdapter() {
        return this.rdb;
    }

    protected RdbTableCounterSql getCounterSql() {
        return this.sql;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public boolean isSeparateTransaction() {
        return this.separateTransaction;
    }

    @Override
    public void init(Config config) {
        this.rdb = config.getDependentService(RdbAdapterService.class).getRdbAdapter();
        this.separateTransaction = config.getValue("separateTransaction", Boolean.TYPE, false);
        this.retryCount = config.getValue("retryCount", Integer.TYPE, 3);
        this.sql = this.rdb.getUpdateSqlCreator(RdbTableCounterSql.class);
        this.counterTypeName = config.getValue("counterTypeName");
        if (this.counterTypeName == null) {
            this.counterTypeName = "defaultCounter";
        }
    }

    @Override
    public void destroy() {
    }

    private Long incrementInternal(final int tenantId, final String incrementUnitKey) {
        SqlExecuter<Long> executer = new SqlExecuter<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long logic() throws SQLException {
                String select = RdbTableCounterService.this.sql.currentValueSql(tenantId, RdbTableCounterService.this.counterTypeName, incrementUnitKey, true, RdbTableCounterService.this.rdb);
                long current = Long.MIN_VALUE;
                try (ResultSet rs = this.getStatement().executeQuery(select);){
                    if (rs.next()) {
                        current = rs.getLong(1);
                    }
                }
                if (current != Long.MIN_VALUE) {
                    String update = RdbTableCounterService.this.sql.incrementSql(tenantId, RdbTableCounterService.this.counterTypeName, incrementUnitKey, 1, RdbTableCounterService.this.rdb);
                    int res = this.getStatement().executeUpdate(update);
                    if (res != 1) {
                        throw new SystemException("counter:" + RdbTableCounterService.this.counterTypeName + "." + incrementUnitKey + " increment failed");
                    }
                    return current + 1L;
                }
                return null;
            }
        };
        return (Long)executer.execute(this.rdb, true);
    }

    private Long incrementOrInit(int tenantId, String incrementUnitKey, long initialCount) {
        Long v = this.incrementInternal(tenantId, incrementUnitKey);
        if (v == null) {
            this.resetCounter(tenantId, incrementUnitKey, initialCount - 1L);
            if (logger.isDebugEnabled()) {
                logger.debug("init Counter:tenandId=" + tenantId + ", key=" + incrementUnitKey + ", startsWith=" + initialCount);
            }
            v = this.incrementInternal(tenantId, incrementUnitKey);
        }
        return v;
    }

    @Override
    public long increment(int tenantId, String incrementUnitKey, long initialCount) {
        Propagation p = this.separateTransaction ? Propagation.REQUIRES_NEW : Propagation.REQUIRED;
        Long v = null;
        RuntimeException exp = null;
        for (int i = 0; i < this.retryCount; ++i) {
            try {
                v = Transaction.with(p, t -> this.incrementOrInit(tenantId, incrementUnitKey, initialCount));
            }
            catch (RuntimeException e) {
                exp = e;
            }
            if (v != null) {
                return v;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("fail to increment counter:" + this.counterTypeName + "." + incrementUnitKey + ", retry...");
        }
        if (exp != null) {
            throw exp;
        }
        throw new SystemException("counter:" + this.counterTypeName + "." + incrementUnitKey + " increment failed. created counter row can't view... May be Transaction Isolation Level is not READ_COMITTED...");
    }

    @Override
    public void resetCounter(int tenantId, String incrementUnitKey) {
        this.resetCounter(tenantId, incrementUnitKey, 0L);
    }

    @Override
    public void resetCounter(final int tenantId, final String incrementUnitKey, final long currentCount) {
        Transaction.required(t -> {
            SqlExecuter<Void> executer = new SqlExecuter<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void logic() throws SQLException {
                    String select = RdbTableCounterService.this.sql.currentValueSql(tenantId, RdbTableCounterService.this.counterTypeName, incrementUnitKey, true, RdbTableCounterService.this.rdb);
                    Long current = null;
                    try (ResultSet rs = this.getStatement().executeQuery(select);){
                        if (rs.next()) {
                            current = rs.getLong(1);
                        }
                    }
                    if (current != null) {
                        String delete = RdbTableCounterService.this.sql.deleteCounterSql(tenantId, RdbTableCounterService.this.counterTypeName, incrementUnitKey, RdbTableCounterService.this.rdb);
                        this.getStatement().addBatch(delete);
                    }
                    String create = RdbTableCounterService.this.sql.createCounterSql(tenantId, RdbTableCounterService.this.counterTypeName, incrementUnitKey, currentCount, RdbTableCounterService.this.rdb);
                    this.getStatement().addBatch(create);
                    int[] res = this.getStatement().executeBatch();
                    if (res[res.length - 1] != 1) {
                        throw new SystemException("counter:" + RdbTableCounterService.this.counterTypeName + "." + incrementUnitKey + " reset failed");
                    }
                    return null;
                }
            };
            return (Void)executer.execute(this.rdb, true);
        });
    }

    @Override
    public void deleteCounter(final int tenantId, final String incrementUnitKey) {
        Transaction.required(t -> {
            SqlExecuter<Void> executer = new SqlExecuter<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void logic() throws SQLException {
                    String select = RdbTableCounterService.this.sql.currentValueSql(tenantId, RdbTableCounterService.this.counterTypeName, incrementUnitKey, true, RdbTableCounterService.this.rdb);
                    Long current = null;
                    try (ResultSet rs = this.getStatement().executeQuery(select);){
                        if (rs.next()) {
                            current = rs.getLong(1);
                        }
                    }
                    if (current != null) {
                        String delete = RdbTableCounterService.this.sql.deleteCounterSql(tenantId, RdbTableCounterService.this.counterTypeName, incrementUnitKey, RdbTableCounterService.this.rdb);
                        this.getStatement().executeUpdate(delete);
                    }
                    return null;
                }
            };
            return (Void)executer.execute(this.rdb, true);
        });
    }

    @Override
    public long current(final int tenantId, final String incrementUnitKey) {
        SqlExecuter<Long> executer = new SqlExecuter<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long logic() throws SQLException {
                Long current;
                block4: {
                    String select = RdbTableCounterService.this.sql.currentValueSql(tenantId, RdbTableCounterService.this.counterTypeName, incrementUnitKey, false, RdbTableCounterService.this.rdb);
                    current = null;
                    try (ResultSet rs = this.getStatement().executeQuery(select);){
                        if (rs.next()) {
                            current = rs.getLong(1);
                            break block4;
                        }
                        Long l = -1L;
                        return l;
                    }
                }
                return (long)current;
            }
        };
        return (Long)executer.execute(this.rdb, true);
    }
}

