/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.impl.counter.CounterService;
import org.iplass.mtp.impl.datastore.MetaEntityStore;
import org.iplass.mtp.impl.datastore.RdbDataStore;
import org.iplass.mtp.impl.datastore.StoreService;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.StorageSpaceMap;
import org.iplass.mtp.impl.datastore.grdb.strategy.GRdbApplyMetaDataStrategy;
import org.iplass.mtp.impl.datastore.grdb.strategy.GRdbEntityStoreStrategy;
import org.iplass.mtp.impl.datastore.strategy.ApplyMetaDataStrategy;
import org.iplass.mtp.impl.datastore.strategy.EntityStoreStrategy;
import org.iplass.mtp.impl.entity.MetaSchemalessRdbStoreMapping;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.spi.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRdbDataStore
extends RdbDataStore {
    private static Logger logger = LoggerFactory.getLogger(GRdbDataStore.class);
    private GRdbEntityStoreStrategy entityStore;
    private GRdbApplyMetaDataStrategy applyMeta;
    private Map<String, StorageSpaceMap> storageSpaceMap;
    private List<StorageSpaceMap> storageSpace;
    private boolean enableWindowFunctionEmulation;
    private Integer stringTypeLengthOnQuery;

    public Map<String, StorageSpaceMap> getStorageSpaceMap() {
        return this.storageSpaceMap;
    }

    public List<StorageSpaceMap> getStorageSpace() {
        return this.storageSpace;
    }

    public void setStorageSpace(List<StorageSpaceMap> storageSpace) {
        this.storageSpace = storageSpace;
    }

    @Override
    public ApplyMetaDataStrategy getApplyMetaDataStrategy() {
        return this.applyMeta;
    }

    @Override
    public EntityStoreStrategy getEntityStoreStrategy() {
        return this.entityStore;
    }

    public boolean isEnableWindowFunctionEmulation() {
        return this.enableWindowFunctionEmulation;
    }

    public void setEnableWindowFunctionEmulation(boolean enableWindowFunctionEmulation) {
        this.enableWindowFunctionEmulation = enableWindowFunctionEmulation;
    }

    public Integer getStringTypeLengthOnQuery() {
        return this.stringTypeLengthOnQuery;
    }

    public void setStringTypeLengthOnQuery(Integer stringTypeLengthOnQuery) {
        this.stringTypeLengthOnQuery = stringTypeLengthOnQuery;
    }

    @Override
    public void inited(StoreService service, Config config) {
        this.storageSpaceMap = new HashMap<String, StorageSpaceMap>();
        if (this.storageSpace != null) {
            for (StorageSpaceMap m : this.storageSpace) {
                this.storageSpaceMap.put(m.getStorageSpaceName(), m);
            }
        }
        CounterService cs = (CounterService)config.getDependentService("OidCounter");
        RdbAdapter rdb = config.getDependentService(RdbAdapterService.class).getRdbAdapter();
        this.entityStore = new GRdbEntityStoreStrategy(this, rdb, cs);
        this.applyMeta = new GRdbApplyMetaDataStrategy(this, rdb);
    }

    @Override
    public void destroyed() {
    }

    @Override
    public MetaEntityStore newEntityStoreInstance() {
        return new MetaGRdbEntityStore();
    }

    @Override
    public Class<? extends MetaEntityStore> getEntityStoreType() {
        return MetaGRdbEntityStore.class;
    }

    @Override
    public List<String> getStorageSpaceList() {
        if (this.storageSpaceMap != null) {
            return new ArrayList<String>(this.storageSpaceMap.keySet());
        }
        return Collections.emptyList();
    }

    public StorageSpaceMap getStorageSpaceMapOrDefault(String name) {
        StorageSpaceMap ret = this.storageSpaceMap.get(name);
        if (ret == null) {
            if (name != null) {
                logger.warn("not define storageSpace:" + name + ", so use storageSpace of 'default'.");
            }
            ret = this.storageSpaceMap.get("default");
        }
        return ret;
    }

    public StorageSpaceMap getStorageSpaceMapOrDefault(MetaSchemalessRdbStoreMapping metaMapping) {
        String name = null;
        if (metaMapping != null) {
            name = metaMapping.getStorageSpace();
        }
        return this.getStorageSpaceMapOrDefault(name);
    }
}

